/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import java.io.File;
import javax.swing.Icon;

public class ProjectCheckoutListener
implements CheckoutListener {
    public boolean processCheckedOutDirectory(Project project, File directory2) {
        File[] files2 = directory2.listFiles((dir, name) -> dir.isFile() && name.endsWith(".ipr"));
        if (files2 != null && files2.length > 0) {
            String message = VcsBundle.message((String)"checkout.open.project.prompt", (Object[])new Object[]{ProjectCheckoutListener.getProductNameWithArticle(), files2[0].getPath()});
            if (Messages.showYesNoDialog((Project)project, (String)message, (String)VcsBundle.message((String)"checkout.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                ProjectUtil.openProject(files2[0].getPath(), project, false);
            }
            return true;
        }
        return false;
    }

    public void processOpenedProject(Project lastOpenedProject) {
    }

    static String getProductNameWithArticle() {
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        String article = StringUtil.isVowel((char)Character.toLowerCase(productName.charAt(0))) ? "an " : "a ";
        return article + productName;
    }
}

