/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcsesI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllVcses
implements AllVcsesI,
Disposable {
    private final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.projectlevelman.AllVcses");
    private final Map<String, AbstractVcs> myVcses;
    private final Object myLock;
    private final Project myProject;
    private final Map<String, VcsEP> myExtensions;

    private AllVcses(Project project) {
        this.myProject = project;
        this.myVcses = new HashMap<String, AbstractVcs>();
        this.myLock = new Object();
        VcsEP[] vcsEPs = (VcsEP[])Extensions.getExtensions(VcsEP.EP_NAME, (AreaInstance)this.myProject);
        HashMap<String, VcsEP> map2 = new HashMap<String, VcsEP>();
        for (VcsEP vcsEP : vcsEPs) {
            map2.put(vcsEP.name, vcsEP);
        }
        this.myExtensions = Collections.unmodifiableMap(map2);
    }

    public static AllVcsesI getInstance(Project project) {
        return (AllVcsesI)ServiceManager.getService((Project)project, AllVcsesI.class);
    }

    private void addVcs(AbstractVcs vcs) {
        this.registerVcs(vcs);
        this.myVcses.put(vcs.getName(), vcs);
    }

    private void registerVcs(AbstractVcs vcs) {
        try {
            vcs.loadSettings();
            vcs.doStart();
        }
        catch (VcsException e) {
            this.LOG.debug((Throwable)e);
        }
        vcs.getProvidedStatuses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerManually(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            AllVcses.$$$reportNull$$$0(0);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myVcses.containsKey(vcs.getName())) {
                return;
            }
            this.addVcs(vcs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterManually(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            AllVcses.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myVcses.containsKey(vcs.getName())) {
                return;
            }
            this.unregisterVcs(vcs);
            this.myVcses.remove(vcs.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractVcs getByName(String name) {
        Object object = this.myLock;
        synchronized (object) {
            AbstractVcs vcs = this.myVcses.get(name);
            if (vcs != null) {
                return vcs;
            }
        }
        VcsEP ep = this.myExtensions.get(name);
        if (ep == null) {
            return null;
        }
        AbstractVcs vcs1 = ep.getVcs(this.myProject);
        this.LOG.assertTrue(vcs1 != null, (Object)name);
        Object object2 = this.myLock;
        synchronized (object2) {
            if (!this.myVcses.containsKey(name)) {
                this.addVcs(vcs1);
            }
            return vcs1;
        }
    }

    @Override
    @Nullable
    public VcsDescriptor getDescriptor(String name) {
        VcsEP ep = this.myExtensions.get(name);
        return ep == null ? null : ep.createDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            for (AbstractVcs vcs : this.myVcses.values()) {
                this.unregisterVcs(vcs);
            }
        }
    }

    private void unregisterVcs(AbstractVcs vcs) {
        try {
            vcs.doShutdown();
        }
        catch (VcsException e) {
            this.LOG.info((Throwable)e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.myExtensions.isEmpty();
    }

    @Override
    public VcsDescriptor[] getAll() {
        ArrayList<VcsDescriptor> result2 = new ArrayList<VcsDescriptor>(this.myExtensions.size());
        for (VcsEP vcsEP : this.myExtensions.values()) {
            result2.add(vcsEP.createDescriptor());
        }
        Collections.sort(result2);
        return result2.toArray(new VcsDescriptor[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "vcs";
        objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/AllVcses";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerManually";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterManually";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

