/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsBalloonProblemNotifier
implements Runnable {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Common Version Control Messages", (String)ChangesViewContentManager.TOOLWINDOW_ID);
    private final Project myProject;
    private final String myMessage;
    private final MessageType myMessageType;
    @Nullable
    private final NamedRunnable[] myNotificationListener;

    public VcsBalloonProblemNotifier(@NotNull Project project, @NotNull String message, MessageType messageType) {
        if (project == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(0);
        }
        if (message == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(1);
        }
        this(project, message, messageType, null);
    }

    public VcsBalloonProblemNotifier(@NotNull Project project, @NotNull String message, MessageType messageType, @Nullable NamedRunnable[] notificationListener) {
        if (project == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(2);
        }
        if (message == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myMessage = message;
        this.myMessageType = messageType;
        this.myNotificationListener = notificationListener;
    }

    public static void showOverChangesView(@NotNull Project project, @NotNull String message, MessageType type, NamedRunnable ... notificationListener) {
        if (project == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(4);
        }
        if (message == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(5);
        }
        VcsBalloonProblemNotifier.show(project, message, type, notificationListener);
    }

    public static void showOverVersionControlView(@NotNull Project project, @NotNull String message, MessageType type) {
        if (project == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(6);
        }
        if (message == null) {
            VcsBalloonProblemNotifier.$$$reportNull$$$0(7);
        }
        VcsBalloonProblemNotifier.show(project, message, type, null);
    }

    private static void show(Project project, String message, MessageType type, @Nullable NamedRunnable[] notificationListener) {
        Application application = ApplicationManager.getApplication();
        if (application.isHeadlessEnvironment()) {
            return;
        }
        Runnable showErrorAction = () -> new VcsBalloonProblemNotifier(project, message, type, notificationListener).run();
        if (application.isDispatchThread()) {
            showErrorAction.run();
        } else {
            application.invokeLater(showErrorAction);
        }
    }

    @Override
    public void run() {
        Notification notification2;
        if (this.myNotificationListener != null && this.myNotificationListener.length > 0) {
            StringBuilder sb = new StringBuilder(this.myMessage);
            for (NamedRunnable runnable2 : this.myNotificationListener) {
                String name = runnable2.toString();
                sb.append("<br/><a href=\"").append(name).append("\">").append(name).append("</a>");
            }
            NotificationListener listener2 = (currentNotification, event) -> {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(event.getEventType())) {
                    if (this.myNotificationListener.length == 1) {
                        this.myNotificationListener[0].run();
                    } else {
                        String description = event.getDescription();
                        if (description != null) {
                            for (NamedRunnable runnable2 : this.myNotificationListener) {
                                if (!description.equals(runnable2.toString())) continue;
                                runnable2.run();
                                break;
                            }
                        }
                    }
                    currentNotification.expire();
                }
            };
            notification2 = NOTIFICATION_GROUP.createNotification("", sb.toString(), this.myMessageType.toNotificationType(), listener2);
        } else {
            notification2 = NOTIFICATION_GROUP.createNotification(this.myMessage, this.myMessageType);
        }
        notification2.notify(this.myProject.isDefault() ? null : this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/ui/VcsBalloonProblemNotifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showOverChangesView";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showOverVersionControlView";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

