/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.Alarm;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.Nullable;

public class ShowProgressTestDialogAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        new MyDialogWrapper(e.getProject()).show();
    }

    private static class MyDialogWrapper
    extends DialogWrapper {
        private final List<JProgressBar> pbList = new ArrayList<JProgressBar>();
        private final Alarm alarm = new Alarm(this.getDisposable());

        public MyDialogWrapper(Project project) {
            super(project);
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            panel2.add(this.createPanel(false, null, false));
            panel2.add(this.createPanel(false, ColorProgressBar.RED, false));
            panel2.add(this.createPanel(false, ColorProgressBar.GREEN, false));
            panel2.add(this.createPanel(false, null, true));
            panel2.add(this.createPanel(false, ColorProgressBar.RED, true));
            panel2.add(this.createPanel(false, ColorProgressBar.GREEN, true));
            panel2.add(this.createPanel(true, null, false));
            panel2.add(this.createPanel(true, null, true));
            panel2.add(this.createPanel(true, ColorProgressBar.RED, false));
            panel2.add(this.createPanel(true, ColorProgressBar.GREEN, false));
            panel2.add(this.createPanel(true, ColorProgressBar.RED, true));
            panel2.add(this.createPanel(true, ColorProgressBar.GREEN, true));
            for (final JProgressBar pb : this.pbList) {
                if (pb.isIndeterminate()) continue;
                Runnable request = new Runnable(){

                    @Override
                    public void run() {
                        if (pb.getValue() < pb.getMaximum()) {
                            pb.setValue(pb.getValue() + 1);
                            alarm.addRequest((Runnable)this, 100);
                        }
                    }
                };
                this.alarm.addRequest(request, 200, ModalityState.any());
            }
            return panel2;
        }

        private JComponent createPanel(boolean indeterminate, Color foreground, boolean modeless) {
            String text2 = indeterminate ? "indeterminate" : "determinate";
            JLabel label2 = new JLabel(text2);
            JProgressBar progress = new JProgressBar(0, 100);
            progress.setIndeterminate(indeterminate);
            progress.setValue(0);
            progress.setForeground(foreground);
            if (modeless) {
                progress.putClientProperty("ProgressBar.stripeWidth", 2);
            }
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            panel2.add(label2);
            panel2.add(progress);
            panel2.add(Box.createVerticalStrut(5));
            this.pbList.add(progress);
            return panel2;
        }
    }
}

