/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.XmlAttributeImpl;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.XmlAttributeDescriptorEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeReference
implements PsiReference {
    private final NullableLazyValue<XmlAttributeDescriptor> myDescriptor;
    private final XmlAttributeImpl myAttribute;

    public XmlAttributeReference(@NotNull XmlAttributeImpl attribute) {
        if (attribute == null) {
            XmlAttributeReference.$$$reportNull$$$0(0);
        }
        this.myDescriptor = new NullableLazyValue<XmlAttributeDescriptor>(){

            protected XmlAttributeDescriptor compute() {
                return XmlAttributeReference.this.myAttribute.getDescriptor();
            }
        };
        this.myAttribute = attribute;
    }

    @NotNull
    public XmlAttribute getElement() {
        XmlAttributeImpl xmlAttributeImpl = this.myAttribute;
        if (xmlAttributeImpl == null) {
            XmlAttributeReference.$$$reportNull$$$0(1);
        }
        return xmlAttributeImpl;
    }

    @NotNull
    public TextRange getRangeInElement() {
        int nsLen;
        int parentOffset = this.myAttribute.getNameElement().getStartOffsetInParent();
        TextRange textRange = new TextRange(parentOffset + (nsLen += (nsLen = this.myAttribute.getNamespacePrefix().length()) > 0 && !this.myAttribute.getRealLocalName().isEmpty() ? 1 : -nsLen), parentOffset + this.myAttribute.getNameElement().getTextLength());
        if (textRange == null) {
            XmlAttributeReference.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    public PsiElement resolve() {
        XmlAttributeDescriptor descriptor2 = this.getDescriptor();
        return descriptor2 != null ? descriptor2.getDeclaration() : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myAttribute.getName();
        if (string == null) {
            XmlAttributeReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        XmlAttributeDescriptorEx xmlAttributeDescriptorEx;
        String s;
        String newName = newElementName;
        if (this.getDescriptor() instanceof XmlAttributeDescriptorEx && (s = (xmlAttributeDescriptorEx = (XmlAttributeDescriptorEx)this.getDescriptor()).handleTargetRename(newElementName)) != null) {
            String prefix = this.myAttribute.getNamespacePrefix();
            newName = StringUtil.isEmpty((String)prefix) ? s : prefix + ":" + s;
        }
        return this.myAttribute.setName(newName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiMetaOwner owner;
        if (element == null) {
            XmlAttributeReference.$$$reportNull$$$0(4);
        }
        if (element instanceof PsiMetaOwner && (owner = (PsiMetaOwner)element).getMetaData() instanceof XmlElementDescriptor) {
            this.myAttribute.setName(owner.getMetaData().getName());
        }
        throw new IncorrectOperationException("Cant bind to not a xml element definition!");
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.myAttribute.getManager().areElementsEquivalent(element, this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            XmlAttributeReference.$$$reportNull$$$0(5);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return this.getDescriptor() == null;
    }

    @Nullable
    private XmlAttributeDescriptor getDescriptor() {
        return (XmlAttributeDescriptor)this.myDescriptor.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlAttributeReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlAttributeReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

