/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;

public abstract class CardLayoutPanel<K, UI, V extends Component>
extends JComponent
implements Accessible,
Disposable {
    private final IdentityHashMap<K, V> myContent = new IdentityHashMap();
    private volatile boolean myDisposed;
    private K myKey;

    protected abstract UI prepare(K var1);

    protected abstract V create(UI var1);

    protected void dispose(K key) {
    }

    public void dispose() {
        if (!this.myDisposed) {
            this.myDisposed = true;
            this.removeAll();
        }
    }

    public K getKey() {
        return this.myKey;
    }

    public V getValue(K key, boolean create2) {
        Component value = (Component)this.myContent.get(key);
        return (V)(create2 && value == null && !this.myContent.containsKey(key) ? this.createValue(key, this.prepare(key)) : value);
    }

    private V createValue(K key, UI ui2) {
        V value = this.create(ui2);
        this.myContent.put(key, value);
        if (value != null) {
            ((Component)value).setVisible(false);
            this.add((Component)value);
        }
        return value;
    }

    public ActionCallback select(K key, boolean now) {
        this.myKey = key;
        ActionCallback callback2 = new ActionCallback();
        if (now) {
            this.select(callback2, key, this.prepare(key));
        } else {
            this.selectLater(callback2, key);
        }
        return callback2;
    }

    private void select(ActionCallback callback2, K key, UI ui2) {
        if (this.myKey != key) {
            callback2.setRejected();
        } else {
            Component value = (Component)this.myContent.get(key);
            if (value == null && !this.myContent.containsKey(key)) {
                value = this.createValue(key, ui2);
            }
            for (Component component : this.getComponents()) {
                component.setVisible(component == value);
            }
            callback2.setDone();
        }
    }

    private void selectLater(ActionCallback callback2, K key) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (!this.myDisposed) {
                UI ui1 = this.prepare(key);
                ApplicationManager.getApplication().invokeLater(() -> {
                    HeavyProcessLatch.INSTANCE.prioritizeUiActivity();
                    if (!this.myDisposed) {
                        this.select(callback2, key, ui1);
                    } else {
                        callback2.setRejected();
                    }
                }, ModalityState.stateForComponent((Component)this));
            } else {
                callback2.setRejected();
            }
        });
    }

    @Override
    public void doLayout() {
        Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
        for (Component component : this.getComponents()) {
            component.setBounds(bounds);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        for (Component component : this.getComponents()) {
            if (!component.isVisible()) continue;
            return component.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        for (Component component : this.getComponents()) {
            if (!component.isVisible()) continue;
            return component.getMinimumSize();
        }
        return super.getMinimumSize();
    }

    @Override
    public void remove(int index) {
        super.remove(index);
        Iterator<Map.Entry<K, V>> it = this.myContent.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> entry = it.next();
            Component value = (Component)entry.getValue();
            if (value == null || this == value.getParent()) continue;
            this.dispose(entry.getKey());
            it.remove();
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        for (K key : this.myContent.keySet()) {
            this.dispose(key);
        }
        this.myContent.clear();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCardLayoutPanel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleCardLayoutPanel
    extends JComponent.AccessibleJComponent {
        protected AccessibleCardLayoutPanel() {
            super(CardLayoutPanel.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

