/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.tree.TreeVisitor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTreeNodeVisitor<T>
implements TreeVisitor {
    protected static final Logger LOG = Logger.getInstance(AbstractTreeNodeVisitor.class);
    private final Supplier<T> supplier;
    private final Predicate<TreePath> predicate;

    public AbstractTreeNodeVisitor(Supplier<T> supplier, Predicate<TreePath> predicate) {
        this.supplier = supplier;
        this.predicate = predicate;
    }

    public AbstractTreeNodeVisitor(Supplier<T> supplier, Consumer<TreePath> consumer) {
        this(supplier, consumer == null ? null : path -> {
            consumer.accept((TreePath)path);
            return false;
        });
    }

    @NotNull
    public TreeVisitor.Action visit(@NotNull TreePath path) {
        T element;
        if (path == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(0);
        }
        if (LOG.isTraceEnabled()) {
            LOG.debug("process ", new Object[]{path});
        }
        T t = element = this.supplier == null ? null : (T)this.supplier.get();
        if (element == null) {
            TreeVisitor.Action action = TreeVisitor.Action.SKIP_SIBLINGS;
            if (action == null) {
                AbstractTreeNodeVisitor.$$$reportNull$$$0(1);
            }
            return action;
        }
        Object component = path.getLastPathComponent();
        if (component instanceof AbstractTreeNode) {
            TreeVisitor.Action action = this.visit(path, (AbstractTreeNode)component, element);
            if (action == null) {
                AbstractTreeNodeVisitor.$$$reportNull$$$0(2);
            }
            return action;
        }
        if (component instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)component;
            Object object = node.getUserObject();
            if (object instanceof AbstractTreeNode) {
                TreeVisitor.Action action = this.visit(path, (AbstractTreeNode)object, element);
                if (action == null) {
                    AbstractTreeNodeVisitor.$$$reportNull$$$0(3);
                }
                return action;
            }
            if (object instanceof String) {
                LOG.debug("ignore children: ", new Object[]{object});
            } else {
                LOG.warn(object == null ? "no object" : "unexpected object " + object.getClass());
            }
        } else if (component instanceof String) {
            LOG.debug("ignore children: ", new Object[]{component});
        } else {
            LOG.warn(component == null ? "no component" : "unexpected component " + component.getClass());
        }
        TreeVisitor.Action action = TreeVisitor.Action.SKIP_CHILDREN;
        if (action == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(4);
        }
        return action;
    }

    @NotNull
    protected TreeVisitor.Action visit(@NotNull TreePath path, @NotNull AbstractTreeNode node, @NotNull T element) {
        if (path == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(5);
        }
        if (node == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(6);
        }
        if (element == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(7);
        }
        if (this.matches(node, element)) {
            LOG.debug("found ", new Object[]{path});
            if (this.predicate == null) {
                TreeVisitor.Action action = TreeVisitor.Action.INTERRUPT;
                if (action == null) {
                    AbstractTreeNodeVisitor.$$$reportNull$$$0(8);
                }
                return action;
            }
            if (this.predicate.test(path)) {
                TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
                if (action == null) {
                    AbstractTreeNodeVisitor.$$$reportNull$$$0(9);
                }
                return action;
            }
        } else if (this.contains(node, element)) {
            LOG.debug("visit ", new Object[]{path});
            TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
            if (action == null) {
                AbstractTreeNodeVisitor.$$$reportNull$$$0(10);
            }
            return action;
        }
        TreeVisitor.Action action = TreeVisitor.Action.SKIP_CHILDREN;
        if (action == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(11);
        }
        return action;
    }

    protected boolean matches(@NotNull AbstractTreeNode node, @NotNull T element) {
        if (node == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(12);
        }
        if (element == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(13);
        }
        return node.canRepresent(element);
    }

    protected boolean contains(@NotNull AbstractTreeNode node, @NotNull T element) {
        T content;
        if (node == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(14);
        }
        if (element == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(15);
        }
        return (content = this.getContent(node)) != null && this.isAncestor(content, element);
    }

    protected T getContent(@NotNull AbstractTreeNode node) {
        if (node == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(16);
        }
        return null;
    }

    protected boolean isAncestor(@NotNull T content, @NotNull T element) {
        if (content == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(17);
        }
        if (element == null) {
            AbstractTreeNodeVisitor.$$$reportNull$$$0(18);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/AbstractTreeNodeVisitor";
                break;
            }
            case 6: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/AbstractTreeNodeVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "visit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

