/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.util.concurrency.Invoker;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public final class ProjectFileChangeListener
implements BulkFileListener {
    private final BiConsumer<? super Module, VirtualFile> consumer;
    private final Project project;
    private final Invoker invoker;

    public ProjectFileChangeListener(@NotNull Invoker invoker, @NotNull Project project, @NotNull BiConsumer<Module, VirtualFile> consumer) {
        if (invoker == null) {
            ProjectFileChangeListener.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ProjectFileChangeListener.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            ProjectFileChangeListener.$$$reportNull$$$0(2);
        }
        this.consumer = consumer;
        this.project = project;
        this.invoker = invoker;
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            ProjectFileChangeListener.$$$reportNull$$$0(3);
        }
        this.invoker.invokeLaterIfNeeded(() -> {
            if (events == null) {
                ProjectFileChangeListener.$$$reportNull$$$0(6);
            }
            for (VFileEvent event : events) {
                VirtualFile parent;
                if (event instanceof VFileCreateEvent) {
                    VFileCreateEvent create2 = (VFileCreateEvent)event;
                    this.invalidate(create2.getParent());
                    continue;
                }
                if (event instanceof VFileCopyEvent) {
                    VFileCopyEvent copy = (VFileCopyEvent)event;
                    this.invalidate(copy.getNewParent());
                    continue;
                }
                if (event instanceof VFileMoveEvent) {
                    VFileMoveEvent move = (VFileMoveEvent)event;
                    parent = move.getOldParent();
                    if (parent != null) {
                        this.invalidate(parent);
                    }
                    this.invalidate(move.getNewParent());
                    this.invalidate(move.getFile());
                    continue;
                }
                VirtualFile file2 = event.getFile();
                if (file2 == null) continue;
                if (event instanceof VFileDeleteEvent && (parent = file2.getParent()) != null) {
                    this.invalidate(parent);
                }
                this.invalidate(file2);
            }
        });
    }

    public void invalidate(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectFileChangeListener.$$$reportNull$$$0(4);
        }
        this.invoker.invokeLaterIfNeeded(() -> {
            if (file2 == null) {
                ProjectFileChangeListener.$$$reportNull$$$0(5);
            }
            if (!this.project.isDisposed()) {
                Module module2 = ProjectFileIndex.getInstance((Project)this.project).getModuleForFile(file2);
                if (module2 != null) {
                    this.consumer.accept((Module)module2, file2);
                } else {
                    VirtualFile ancestor = this.project.getBaseDir();
                    if (ancestor != null && VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)false)) {
                        this.consumer.accept(null, file2);
                    }
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tree/ProjectFileChangeListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invalidate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$invalidate$1";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$after$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

