/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.ui.frame.CommitPanel;
import com.intellij.vcs.log.ui.frame.WrappedFlowLayout;
import com.intellij.vcs.log.ui.render.LabelIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferencesPanel
extends JPanel {
    public static final int H_GAP = 4;
    protected static final int V_GAP = 0;
    private final int myRefsLimit;
    @NotNull
    private List<VcsRef> myReferences;
    @NotNull
    protected MultiMap<VcsRefType, VcsRef> myGroupedVisibleReferences;

    public ReferencesPanel() {
        this((LayoutManager)new WrappedFlowLayout(JBUI.scale((int)4), JBUI.scale((int)0)), -1);
    }

    public ReferencesPanel(LayoutManager layout, int limit) {
        super(layout);
        this.myRefsLimit = limit;
        this.myReferences = Collections.emptyList();
        this.myGroupedVisibleReferences = MultiMap.create();
        this.setOpaque(false);
    }

    public void setReferences(@NotNull List<VcsRef> references) {
        if (references == null) {
            ReferencesPanel.$$$reportNull$$$0(0);
        }
        if (this.myReferences.equals(references)) {
            return;
        }
        this.myReferences = references;
        List<VcsRef> visibleReferences = this.myRefsLimit > 0 ? this.myReferences.subList(0, Math.min(this.myReferences.size(), this.myRefsLimit)) : this.myReferences;
        this.myGroupedVisibleReferences = ContainerUtil.groupBy(visibleReferences, VcsRef::getType);
        this.update();
    }

    public void update() {
        this.removeAll();
        int height = this.getIconHeight();
        JBLabel firstLabel = null;
        for (Map.Entry typeAndRefs : this.myGroupedVisibleReferences.entrySet()) {
            VcsRefType type = (VcsRefType)typeAndRefs.getKey();
            Collection refs = (Collection)typeAndRefs.getValue();
            int refIndex = 0;
            for (VcsRef reference : refs) {
                Icon icon = this.createIcon(type, refs, refIndex, height);
                String ending = refIndex != refs.size() - 1 ? "," : "";
                String text2 = reference.getName() + ending;
                JBLabel label2 = this.createLabel(text2, icon);
                if (firstLabel == null) {
                    firstLabel = label2;
                    this.add((Component)label2);
                } else {
                    this.addWrapped(label2, firstLabel);
                }
                ++refIndex;
            }
        }
        if (this.getHiddenReferencesSize() > 0) {
            JBLabel label3 = this.createRestLabel(this.getHiddenReferencesSize());
            this.addWrapped(label3, (JBLabel)ObjectUtils.assertNotNull(firstLabel));
        }
        this.setVisible(!this.myGroupedVisibleReferences.isEmpty());
        this.revalidate();
        this.repaint();
    }

    private int getHiddenReferencesSize() {
        return this.myRefsLimit > 0 ? this.myReferences.size() - Math.min(this.myReferences.size(), this.myRefsLimit) : 0;
    }

    protected int getIconHeight() {
        return this.getFontMetrics(this.getLabelsFont()).getHeight();
    }

    @NotNull
    protected JBLabel createRestLabel(int restSize) {
        JBLabel jBLabel = this.createLabel("... " + restSize + " more", null);
        if (jBLabel == null) {
            ReferencesPanel.$$$reportNull$$$0(1);
        }
        return jBLabel;
    }

    @Nullable
    protected Icon createIcon(@NotNull VcsRefType type, @NotNull Collection<VcsRef> refs, int refIndex, int height) {
        if (type == null) {
            ReferencesPanel.$$$reportNull$$$0(2);
        }
        if (refs == null) {
            ReferencesPanel.$$$reportNull$$$0(3);
        }
        if (refIndex == 0) {
            Color color = type.getBackgroundColor();
            return new LabelIcon(this, height, this.getBackground(), refs.size() > 1 ? ContainerUtil.newArrayList((Object[])new Color[]{color, color}) : Collections.singletonList(color));
        }
        return null;
    }

    private void addWrapped(@NotNull JBLabel label2, @NotNull JBLabel referent) {
        if (label2 == null) {
            ReferencesPanel.$$$reportNull$$$0(4);
        }
        if (referent == null) {
            ReferencesPanel.$$$reportNull$$$0(5);
        }
        Wrapper wrapper2 = new Wrapper((JComponent)label2);
        wrapper2.setVerticalSizeReferent((JComponent)referent);
        this.add((Component)wrapper2);
    }

    @NotNull
    protected JBLabel createLabel(@NotNull String text2, @Nullable Icon icon) {
        if (text2 == null) {
            ReferencesPanel.$$$reportNull$$$0(6);
        }
        JBLabel label2 = new JBLabel(text2, icon, 2);
        label2.setFont(this.getLabelsFont());
        label2.setIconTextGap(0);
        label2.setHorizontalAlignment(2);
        label2.setVerticalTextPosition(0);
        label2.setCopyable(true);
        JBLabel jBLabel = label2;
        if (jBLabel == null) {
            ReferencesPanel.$$$reportNull$$$0(7);
        }
        return jBLabel;
    }

    @NotNull
    protected Font getLabelsFont() {
        Font font = FontUtil.getCommitMetadataFont();
        if (font == null) {
            ReferencesPanel.$$$reportNull$$$0(8);
        }
        return font;
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    @Override
    public Color getBackground() {
        return CommitPanel.getCommitDetailsBackground();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/ReferencesPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/ReferencesPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRestLabel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelsFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setReferences";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createIcon";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addWrapped";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

