/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;

public class ViewBreakpointsAction
extends AnAction
implements AnAction.TransparentUpdate,
DumbAware {
    private Object myInitialBreakpoint;

    public ViewBreakpointsAction() {
        this(ActionsBundle.actionText((String)"ViewBreakpoints"), null);
    }

    public ViewBreakpointsAction(String name, Object initialBreakpoint) {
        super(name);
        this.myInitialBreakpoint = initialBreakpoint;
    }

    public void actionPerformed(AnActionEvent e) {
        Editor editor;
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        if (this.myInitialBreakpoint == null && (editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) != null) {
            this.myInitialBreakpoint = XBreakpointUtil.findSelectedBreakpoint((Project)project, (Editor)editor).second;
        }
        BreakpointsDialogFactory.getInstance(project).showDialog(this.myInitialBreakpoint);
        this.myInitialBreakpoint = null;
    }

    public void update(AnActionEvent event) {
        event.getPresentation().setEnabled(event.getProject() != null);
    }
}

