/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaComplianceChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaComplianceInspection
extends LocalInspectionTool {
    public boolean myCaseInsensitiveEnum = false;

    @NotNull
    public String getDisplayName() {
        String string = JsonBundle.message("json.schema.inspection.compliance.name", new Object[0]);
        if (string == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, final @NotNull LocalInspectionToolSession session2) {
        VirtualFile virtualFile;
        PsiFile file2;
        JsonValue root;
        if (holder == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(2);
        }
        if (session2 == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(3);
        }
        JsonValue jsonValue = root = (file2 = holder.getFile()) instanceof JsonFile ? (JsonValue)ObjectUtils.tryCast((Object)file2.getFirstChild(), JsonValue.class) : null;
        if (root == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JsonSchemaComplianceInspection.$$$reportNull$$$0(4);
            }
            return psiElementVisitor;
        }
        JsonSchemaService service2 = JsonSchemaService.Impl.get(file2.getProject());
        if (!service2.isApplicableToFile(virtualFile = file2.getViewProvider().getVirtualFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JsonSchemaComplianceInspection.$$$reportNull$$$0(5);
            }
            return psiElementVisitor;
        }
        final JsonSchemaObject rootSchema = service2.getSchemaObject(virtualFile);
        if (rootSchema == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JsonSchemaComplianceInspection.$$$reportNull$$$0(6);
            }
            return psiElementVisitor;
        }
        final JsonComplianceCheckerOptions options = new JsonComplianceCheckerOptions(this.myCaseInsensitiveEnum);
        JsonElementVisitor jsonElementVisitor = new JsonElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element == root) {
                    JsonSchemaComplianceInspection.annotate(element, rootSchema, holder, session2, options);
                }
                super.visitElement(element);
            }
        };
        if (jsonElementVisitor == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(7);
        }
        return jsonElementVisitor;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JsonBundle.message("json.schema.inspection.case.insensitive.enum", new Object[0]), "myCaseInsensitiveEnum");
        return optionsPanel;
    }

    private static void annotate(@NotNull PsiElement element, @NotNull JsonSchemaObject rootSchema, @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session2, JsonComplianceCheckerOptions options) {
        JsonLikePsiWalker walker;
        if (element == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(8);
        }
        if (rootSchema == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(10);
        }
        if (session2 == null) {
            JsonSchemaComplianceInspection.$$$reportNull$$$0(11);
        }
        if ((walker = JsonLikePsiWalker.getWalker(element, rootSchema)) == null) {
            return;
        }
        new JsonSchemaComplianceChecker(rootSchema, holder, walker, session2, options).annotate(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaComplianceInspection";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSchema";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaComplianceInspection";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

