/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.fstrings;

import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.List;

public class PyFStringAwareRecursiveVisitor
extends PyRecursiveElementVisitor {
    protected PyStringLiteralExpression myContainingFString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitPyStringLiteralExpression(PyStringLiteralExpression pyString) {
        List formatNodeRanges = ContainerUtil.mapNotNull(pyString.getStringNodes(), node -> {
            PyUtil.StringNodeInfo nodeInfo = new PyUtil.StringNodeInfo((ASTNode)node);
            return nodeInfo.isFormatted() ? nodeInfo.getAbsoluteContentRange().shiftRight(-pyString.getTextOffset()) : null;
        });
        if (!formatNodeRanges.isEmpty()) {
            InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance((Project)pyString.getProject());
            for (Pair pair : ContainerUtil.notNullize((List)injectionManager.getInjectedPsiFiles((PsiElement)pyString))) {
                PyFile pyFile = PyUtil.as(pair.getFirst(), PyFile.class);
                if (pyFile == null || !ContainerUtil.exists((Iterable)formatNodeRanges, range2 -> range2.contains((TextRange)pair.getSecond()))) continue;
                this.myContainingFString = pyString;
                try {
                    pyFile.accept(this);
                }
                finally {
                    this.myContainingFString = null;
                }
            }
        }
        super.visitPyStringLiteralExpression(pyString);
    }
}

