/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.google.common.collect.Ordering;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PyImportOptimizer
implements ImportOptimizer {
    private static final Logger LOG = Logger.getInstance(PyImportOptimizer.class);
    private boolean mySortImports = true;

    @NotNull
    public static PyImportOptimizer onlyRemoveUnused() {
        PyImportOptimizer optimizer = new PyImportOptimizer();
        optimizer.mySortImports = false;
        PyImportOptimizer pyImportOptimizer = optimizer;
        if (pyImportOptimizer == null) {
            PyImportOptimizer.$$$reportNull$$$0(0);
        }
        return pyImportOptimizer;
    }

    public boolean supports(PsiFile file2) {
        return true;
    }

    @NotNull
    public Runnable processFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            PyImportOptimizer.$$$reportNull$$$0(1);
        }
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(file2, 0, file2.getTextLength());
        final PyUnresolvedReferencesInspection.Visitor visitor2 = new PyUnresolvedReferencesInspection.Visitor(null, session2, Collections.emptyList());
        file2.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitElement(PsiElement node) {
                super.visitElement(node);
                node.accept((PsiElementVisitor)visitor2);
            }
        });
        Runnable runnable2 = () -> {
            if (file2 == null) {
                PyImportOptimizer.$$$reportNull$$$0(3);
            }
            LOG.debug(String.format("----------------- OPTIMIZE IMPORTS STARTED (%s) -----------------", file2.getVirtualFile()));
            visitor2.optimizeImports();
            if (this.mySortImports && file2 instanceof PyFile) {
                new ImportSorter((PyFile)file2).run();
            }
            LOG.debug("----------------- OPTIMIZE IMPORTS FINISHED -----------------");
        };
        if (runnable2 == null) {
            PyImportOptimizer.$$$reportNull$$$0(2);
        }
        return runnable2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/imports/PyImportOptimizer";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "onlyRemoveUnused";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/imports/PyImportOptimizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ImportSorter {
        private static final Comparator<PyImportElement> IMPORT_ELEMENT_COMPARATOR = (o1, o2) -> {
            int byImportedName = Comparing.compare((Comparable)o1.getImportedQName(), (Comparable)o2.getImportedQName());
            if (byImportedName != 0) {
                return byImportedName;
            }
            return Comparing.compare((Comparable)((Object)o1.getAsName()), (Comparable)((Object)o2.getAsName()));
        };
        private final PyFile myFile;
        private final PyCodeStyleSettings myPySettings;
        private final List<PyImportStatementBase> myImportBlock;
        private final Map<AddImportHelper.ImportPriority, List<PyImportStatementBase>> myGroups;
        private final MultiMap<PyImportStatementBase, PsiComment> myOldImportToLineComments;
        private final MultiMap<PyImportStatementBase, PsiComment> myOldImportToInnerComments;
        private final MultiMap<String, PyFromImportStatement> myOldFromImportBySources;
        private final MultiMap<PyImportStatementBase, PsiComment> myNewImportToLineComments;
        private final MultiMap<PyImportStatementBase, PsiComment> myNewImportToInnerComments;
        private final List<PsiComment> myDanglingComments;

        private ImportSorter(@NotNull PyFile file2) {
            if (file2 == null) {
                ImportSorter.$$$reportNull$$$0(0);
            }
            this.myOldImportToLineComments = MultiMap.create();
            this.myOldImportToInnerComments = MultiMap.create();
            this.myOldFromImportBySources = MultiMap.create();
            this.myNewImportToLineComments = MultiMap.create();
            this.myNewImportToInnerComments = MultiMap.create();
            this.myDanglingComments = new ArrayList<PsiComment>();
            this.myFile = file2;
            this.myPySettings = (PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)this.myFile, PyCodeStyleSettings.class);
            this.myImportBlock = this.myFile.getImportBlock();
            this.myGroups = new EnumMap<AddImportHelper.ImportPriority, List<PyImportStatementBase>>(AddImportHelper.ImportPriority.class);
            for (AddImportHelper.ImportPriority priority : AddImportHelper.ImportPriority.values()) {
                this.myGroups.put(priority, new ArrayList());
            }
        }

        public void run() {
            if (this.myImportBlock.isEmpty()) {
                return;
            }
            this.analyzeImports(this.myImportBlock);
            for (PyImportStatementBase importStatement : this.myImportBlock) {
                AddImportHelper.ImportPriorityChoice choice = AddImportHelper.getImportPriorityWithReason(importStatement);
                LOG.debug(String.format("Import group for '%s' is %s: %s", new Object[]{importStatement.getText(), choice.getPriority(), choice.getDescription()}));
                this.myGroups.get((Object)choice.getPriority()).add(importStatement);
            }
            boolean hasTransformedImports = false;
            for (AddImportHelper.ImportPriority priority : AddImportHelper.ImportPriority.values()) {
                List<PyImportStatementBase> transformed;
                List<PyImportStatementBase> original = this.myGroups.get((Object)priority);
                hasTransformedImports |= !original.equals(transformed = this.transformImportStatements(original));
                this.myGroups.put(priority, transformed);
            }
            if (hasTransformedImports || this.needBlankLinesBetweenGroups() || this.groupsNotSorted()) {
                this.applyResults();
            }
        }

        private void analyzeImports(@NotNull List<PyImportStatementBase> imports) {
            if (imports == null) {
                ImportSorter.$$$reportNull$$$0(1);
            }
            for (PyImportStatementBase statement : imports) {
                PyFromImportStatement fromImport = PyUtil.as(statement, PyFromImportStatement.class);
                if (fromImport != null && !fromImport.isStarImport()) {
                    this.myOldFromImportBySources.putValue((Object)ImportSorter.getNormalizedFromImportSource(fromImport), (Object)fromImport);
                }
                Couple<List<PsiComment>> boundAndOthers = ImportSorter.collectPrecedingLineComments(statement);
                this.myOldImportToLineComments.putValues((Object)statement, (Collection)boundAndOthers.getFirst());
                if (statement != this.myImportBlock.get(0)) {
                    this.myDanglingComments.addAll((Collection)boundAndOthers.getSecond());
                }
                this.myOldImportToInnerComments.putValues((Object)statement, PsiTreeUtil.collectElementsOfType((PsiElement)statement, (Class[])new Class[]{PsiComment.class}));
            }
        }

        @NotNull
        private List<PyImportStatementBase> transformImportStatements(@NotNull List<PyImportStatementBase> imports) {
            if (imports == null) {
                ImportSorter.$$$reportNull$$$0(2);
            }
            ArrayList<PyImportStatementBase> result2 = new ArrayList<PyImportStatementBase>();
            PyElementGenerator generator = PyElementGenerator.getInstance(this.myFile.getProject());
            LanguageLevel langLevel = LanguageLevel.forElement((PsiElement)this.myFile);
            for (PyImportStatementBase statement : imports) {
                if (statement instanceof PyImportStatement) {
                    PyImportStatement importStatement = (PyImportStatement)statement;
                    Object[] importElements = importStatement.getImportElements();
                    if (importElements.length > 1) {
                        List newImports = ContainerUtil.map((Object[])importElements, e -> generator.createImportStatement(langLevel, e.getText(), null));
                        PyImportStatement topmostImport = this.myPySettings.OPTIMIZE_IMPORTS_SORT_IMPORTS ? (PyImportStatement)Collections.min(newImports, AddImportHelper.getSameGroupImportsComparator(this.myFile)) : (PyImportStatement)newImports.get(0);
                        this.myNewImportToLineComments.putValues((Object)topmostImport, this.myOldImportToLineComments.get((Object)statement));
                        this.myNewImportToInnerComments.putValues((Object)topmostImport, this.myOldImportToInnerComments.get((Object)statement));
                        result2.addAll(newImports);
                        continue;
                    }
                    this.myNewImportToLineComments.putValues((Object)statement, this.myOldImportToLineComments.get((Object)statement));
                    result2.add(importStatement);
                    continue;
                }
                if (!(statement instanceof PyFromImportStatement)) continue;
                PyFromImportStatement fromImport = (PyFromImportStatement)statement;
                String source = ImportSorter.getNormalizedFromImportSource(fromImport);
                ArrayList newStatementElements = new ArrayList();
                boolean forceParentheses = false;
                if (!fromImport.isStarImport()) {
                    Collection sameSourceImports = this.myOldFromImportBySources.get((Object)source);
                    if (sameSourceImports.isEmpty()) continue;
                    boolean bl = forceParentheses = sameSourceImports.size() == 1 && fromImport.getLeftParen() != null;
                    if (this.myPySettings.OPTIMIZE_IMPORTS_JOIN_FROM_IMPORTS_WITH_SAME_SOURCE && sameSourceImports.size() > 1) {
                        for (PyFromImportStatement sameSourceImport : sameSourceImports) {
                            ContainerUtil.addAll(newStatementElements, (Object[])sameSourceImport.getImportElements());
                        }
                        this.myOldFromImportBySources.remove((Object)source);
                    } else if (this.myPySettings.OPTIMIZE_IMPORTS_SORT_NAMES_IN_FROM_IMPORTS) {
                        List<PyImportElement> originalElements = Arrays.asList(fromImport.getImportElements());
                        if (!Ordering.from(IMPORT_ELEMENT_COMPARATOR).isOrdered(originalElements)) {
                            ContainerUtil.addAll(newStatementElements, originalElements);
                        }
                    }
                }
                if (!newStatementElements.isEmpty()) {
                    if (this.myPySettings.OPTIMIZE_IMPORTS_SORT_NAMES_IN_FROM_IMPORTS) {
                        Collections.sort(newStatementElements, IMPORT_ELEMENT_COMPARATOR);
                    }
                    String importedNames = StringUtil.join(newStatementElements, ImportSorter::getNormalizedImportElementText, (String)", ");
                    if (forceParentheses) {
                        importedNames = "(" + importedNames + ")";
                    }
                    PyFromImportStatement combinedImport = generator.createFromImportStatement(langLevel, source, importedNames, null);
                    ContainerUtil.map2LinkedSet(newStatementElements, e -> (PyImportStatementBase)e.getParent()).forEach(affected -> {
                        this.myNewImportToLineComments.putValues((Object)combinedImport, this.myOldImportToLineComments.get(affected));
                        this.myNewImportToInnerComments.putValues((Object)combinedImport, this.myOldImportToInnerComments.get(affected));
                    });
                    result2.add(combinedImport);
                    continue;
                }
                this.myNewImportToLineComments.putValues((Object)fromImport, this.myOldImportToLineComments.get((Object)fromImport));
                result2.add(fromImport);
            }
            ArrayList<PyImportStatementBase> arrayList = result2;
            if (arrayList == null) {
                ImportSorter.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        @NotNull
        private static String getNormalizedImportElementText(@NotNull PyImportElement element) {
            if (element == null) {
                ImportSorter.$$$reportNull$$$0(4);
            }
            String string = element.getText().replaceAll("#.*", "").replaceAll("[\\s\\\\]+", " ");
            if (string == null) {
                ImportSorter.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        private static Couple<List<PsiComment>> collectPrecedingLineComments(@NotNull PyImportStatementBase statement) {
            List<PsiComment> boundComments;
            PsiComment firstComment;
            if (statement == null) {
                ImportSorter.$$$reportNull$$$0(6);
            }
            if ((firstComment = (PsiComment)ContainerUtil.getFirstItem(boundComments = PyPsiUtils.getPrecedingComments((PsiElement)statement, true))) != null && ImportSorter.isFirstInFile((PsiElement)firstComment)) {
                Couple couple = Couple.of(Collections.emptyList(), boundComments);
                if (couple == null) {
                    ImportSorter.$$$reportNull$$$0(7);
                }
                return couple;
            }
            List<PsiComment> remainingComments = PyPsiUtils.getPrecedingComments((PsiElement)ObjectUtils.notNull((Object)firstComment, (Object)statement), false);
            Couple couple = Couple.of(boundComments, remainingComments);
            if (couple == null) {
                ImportSorter.$$$reportNull$$$0(8);
            }
            return couple;
        }

        private static boolean isFirstInFile(@NotNull PsiElement element) {
            if (element == null) {
                ImportSorter.$$$reportNull$$$0(9);
            }
            if (element.getTextRange().getStartOffset() == 0) {
                return true;
            }
            PsiWhiteSpace prevWhitespace = PyUtil.as(PsiTreeUtil.prevLeaf((PsiElement)element), PsiWhiteSpace.class);
            return prevWhitespace != null && prevWhitespace.getTextRange().getStartOffset() == 0;
        }

        @NotNull
        public static String getNormalizedFromImportSource(@NotNull PyFromImportStatement statement) {
            if (statement == null) {
                ImportSorter.$$$reportNull$$$0(10);
            }
            String string = StringUtil.repeatSymbol((char)'.', (int)statement.getRelativeLevel()) + Objects.toString(statement.getImportSourceQName(), "");
            if (string == null) {
                ImportSorter.$$$reportNull$$$0(11);
            }
            return string;
        }

        private boolean groupsNotSorted() {
            if (!this.myPySettings.OPTIMIZE_IMPORTS_SORT_IMPORTS) {
                return false;
            }
            Ordering importOrdering = Ordering.from(AddImportHelper.getSameGroupImportsComparator(this.myFile));
            return ContainerUtil.exists(this.myGroups.values(), imports -> !importOrdering.isOrdered((Iterable)imports));
        }

        private boolean needBlankLinesBetweenGroups() {
            return ((StreamEx)StreamEx.of(this.myGroups.values()).remove(List::isEmpty)).count() > 1L;
        }

        private void applyResults() {
            PyImportStatementBase firstImport;
            List boundComments;
            if (this.myPySettings.OPTIMIZE_IMPORTS_SORT_IMPORTS) {
                for (AddImportHelper.ImportPriority priority : this.myGroups.keySet()) {
                    List<PyImportStatementBase> imports = this.myGroups.get((Object)priority);
                    Collections.sort(imports, AddImportHelper.getSameGroupImportsComparator(this.myFile));
                    this.myGroups.put(priority, imports);
                }
            }
            PyImportStatementBase firstElementToRemove = (boundComments = (List)ImportSorter.collectPrecedingLineComments(firstImport = this.myImportBlock.get(0)).getFirst()).isEmpty() ? firstImport : (PsiElement)boundComments.get(0);
            PyImportStatementBase lastImport = (PyImportStatementBase)ContainerUtil.getLastItem(this.myImportBlock);
            assert (lastImport != null);
            this.addImportsAfter((PsiElement)lastImport);
            ImportSorter.deleteRangeThroughDocument((PsiElement)firstElementToRemove, PyPsiUtils.getNextNonWhitespaceSibling((PsiElement)lastImport).getPrevSibling());
        }

        private void addImportsAfter(@NotNull PsiElement anchor2) {
            if (anchor2 == null) {
                ImportSorter.$$$reportNull$$$0(12);
            }
            StringBuilder content = new StringBuilder();
            for (List<PyImportStatementBase> imports : this.myGroups.values()) {
                if (content.length() > 0 && !imports.isEmpty()) {
                    content.append("\n");
                }
                for (PyImportStatementBase statement : imports) {
                    for (PsiComment comment2 : this.myNewImportToLineComments.get((Object)statement)) {
                        content.append(comment2.getText()).append("\n");
                    }
                    content.append(statement.getText());
                    Collection innerComments = this.myNewImportToInnerComments.get((Object)statement);
                    if (!innerComments.isEmpty()) {
                        content.append("  # ");
                        String combinedComment = StringUtil.join((Collection)innerComments, comment -> comment.getText().substring(1).trim(), (String)"; ");
                        content.append(combinedComment).append("\n");
                        continue;
                    }
                    content.append("\n");
                }
            }
            if (!this.myDanglingComments.isEmpty()) {
                content.append("\n");
                for (PsiComment comment3 : this.myDanglingComments) {
                    content.append(comment3.getText()).append("\n");
                }
            }
            Project project = anchor2.getProject();
            PyElementGenerator generator = PyElementGenerator.getInstance(project);
            PyFile file2 = (PyFile)generator.createDummyFile(LanguageLevel.forElement(anchor2), content.toString());
            PyFile reformattedFile = (PyFile)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file2);
            List<PyImportStatementBase> newImportBlock = reformattedFile.getImportBlock();
            assert (newImportBlock != null);
            this.myFile.addRangeAfter(reformattedFile.getFirstChild(), reformattedFile.getLastChild(), anchor2);
        }

        private static void deleteRangeThroughDocument(@NotNull PsiElement first, @NotNull PsiElement last) {
            if (first == null) {
                ImportSorter.$$$reportNull$$$0(13);
            }
            if (last == null) {
                ImportSorter.$$$reportNull$$$0(14);
            }
            PyUtil.updateDocumentUnblockedAndCommitted(first, (Consumer<Document>)((Consumer)document -> {
                if (first == null) {
                    ImportSorter.$$$reportNull$$$0(15);
                }
                if (last == null) {
                    ImportSorter.$$$reportNull$$$0(16);
                }
                document.deleteString(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "imports";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/imports/PyImportOptimizer$ImportSorter";
                    break;
                }
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "last";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/imports/PyImportOptimizer$ImportSorter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "transformImportStatements";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNormalizedImportElementText";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectPrecedingLineComments";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNormalizedFromImportSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "analyzeImports";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "transformImportStatements";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 11: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getNormalizedImportElementText";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "collectPrecedingLineComments";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isFirstInFile";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getNormalizedFromImportSource";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "addImportsAfter";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteRangeThroughDocument";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$deleteRangeThroughDocument$6";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

