/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyRemoteDebugProcessAware;
import java.net.ServerSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteDebugProcess
extends PyDebugProcess {
    private final int myLocalPort;
    private final String mySettraceCall;
    private boolean isStopCalled;

    public PyRemoteDebugProcess(@NotNull XDebugSession session2, @NotNull ServerSocket serverSocket, @NotNull ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler2, @Nullable String settraceCall) {
        if (session2 == null) {
            PyRemoteDebugProcess.$$$reportNull$$$0(0);
        }
        if (serverSocket == null) {
            PyRemoteDebugProcess.$$$reportNull$$$0(1);
        }
        if (executionConsole == null) {
            PyRemoteDebugProcess.$$$reportNull$$$0(2);
        }
        super(session2, serverSocket, executionConsole, processHandler2, false);
        this.isStopCalled = false;
        if (processHandler2 instanceof PyRemoteDebugProcessAware) {
            ((PyRemoteDebugProcessAware)processHandler2).setRemoteDebugProcess(this);
        }
        this.myLocalPort = serverSocket.getLocalPort();
        this.mySettraceCall = settraceCall;
    }

    @Override
    public void sessionInitialized() {
        super.sessionInitialized();
        this.printConsoleInfo();
    }

    protected void printConsoleInfo() {
        this.printToConsole("Starting debug server at port " + this.myLocalPort + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        this.printToConsole("Use the following code to connect to the debugger:\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        if (!StringUtil.isEmpty((String)this.mySettraceCall)) {
            this.printToConsole(this.mySettraceCall + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    @Override
    protected String getConnectionMessage() {
        return "Waiting for process connection...";
    }

    @Override
    protected String getConnectionTitle() {
        return "Waiting for connection";
    }

    @Override
    protected boolean shouldLogConnectionException(Exception e) {
        return !this.isStopCalled || !e.getMessage().contains("closed");
    }

    @Override
    protected void detachDebuggedProcess() {
        this.waitForNextConnection();
    }

    @Override
    public void stop() {
        super.stop();
        this.isStopCalled = true;
    }

    @Override
    protected void beforeConnect() {
        this.printToConsole(this.getCurrentStateMessage() + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    @Override
    protected void afterConnect() {
    }

    public void waitForNextConnection() {
        if (this.isConnected()) {
            this.disconnect();
        }
        if (this.getSession().isSuspended()) {
            this.getSession().resume();
        }
        if (!this.isWaitingForConnection()) {
            this.setWaitingForConnection(true);
            ApplicationManager.getApplication().invokeLater(() -> this.waitForConnection(this.getCurrentStateMessage(), this.getConnectionTitle()), ModalityState.defaultModalityState());
        }
    }

    @Override
    public int getConnectTimeout() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "serverSocket";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "executionConsole";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/debugger/PyRemoteDebugProcess";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

