/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBroadExceptionInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.too.broad.exception.clauses", new Object[0]);
        if (string == null) {
            PyBroadExceptionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyBroadExceptionInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyBroadExceptionInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyBroadExceptionInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    public static boolean equalsException(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PyBroadExceptionInspection.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyBroadExceptionInspection.$$$reportNull$$$0(5);
        }
        PyType type = context.getType(cls);
        return ("Exception".equals(cls.getName()) || "BaseException".equals(cls.getName())) && type != null && type.isBuiltin();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyBroadExceptionInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyBroadExceptionInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "equalsException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
        }

        @Override
        public void visitPyExceptBlock(PyExceptPart node) {
            PyType type;
            PyExpression exceptClass = node.getExceptClass();
            if (Visitor.reRaised(node)) {
                return;
            }
            if (exceptClass == null) {
                this.registerProblem(node.getFirstChild(), "Too broad exception clause");
            }
            if (exceptClass != null && (type = this.myTypeEvalContext.getType(exceptClass)) instanceof PyClassType) {
                PyClass cls = ((PyClassType)type).getPyClass();
                PyExpression target2 = node.getTarget();
                if (PyBroadExceptionInspection.equalsException(cls, this.myTypeEvalContext) && (target2 == null || !Visitor.isExceptionUsed(node, target2.getText()))) {
                    this.registerProblem((PsiElement)exceptClass, "Too broad exception clause");
                }
            }
        }

        private static boolean reRaised(PyExceptPart node) {
            PyStatementList statementList = node.getStatementList();
            if (statementList != null) {
                for (PyStatement st : statementList.getStatements()) {
                    if (!(st instanceof PyRaiseStatement)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isExceptionUsed(PyExceptPart node, String text2) {
            Stack stack = new Stack();
            PyStatementList statementList = node.getStatementList();
            if (statementList != null) {
                for (PyStatement st : statementList.getStatements()) {
                    stack.push((Object)st);
                    while (!stack.isEmpty()) {
                        PsiElement resolved;
                        PsiReference reference;
                        PsiElement e = (PsiElement)stack.pop();
                        if (e instanceof PyReferenceExpression && (reference = e.getReference()) != null && (resolved = reference.resolve()) != null && resolved.getText().equals(text2)) {
                            return true;
                        }
                        for (PsiElement psiElement : e.getChildren()) {
                            stack.push((Object)psiElement);
                        }
                    }
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyBroadExceptionInspection$Visitor", "<init>"));
        }
    }
}

