/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Consumer;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.ChainedComparisonsQuickFix;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyChainedComparisonsInspection
extends PyInspection {
    private static final String INSPECTION_SHORT_NAME = "PyChainedComparisonsInspection";
    public boolean ignoreConstantInTheMiddle = false;
    private static final String ourIgnoreConstantOptionText = "Ignore statements with a constant in the middle";

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.chained.comparisons", new Object[0]);
        if (string == null) {
            PyChainedComparisonsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyChainedComparisonsInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyChainedComparisonsInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2, this.ignoreConstantInTheMiddle);
        if (visitor2 == null) {
            PyChainedComparisonsInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.add((Component)new CheckBox(ourIgnoreConstantOptionText, (InspectionProfileEntry)this, "ignoreConstantInTheMiddle"), "First");
        return rootPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyChainedComparisonsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyChainedComparisonsInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DontSimplifyStatementsWithConstantInTheMiddleQuickFix
    implements LocalQuickFix {
        private DontSimplifyStatementsWithConstantInTheMiddleQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if (PyChainedComparisonsInspection.ourIgnoreConstantOptionText == null) {
                DontSimplifyStatementsWithConstantInTheMiddleQuickFix.$$$reportNull$$$0(0);
            }
            return PyChainedComparisonsInspection.ourIgnoreConstantOptionText;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                DontSimplifyStatementsWithConstantInTheMiddleQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                DontSimplifyStatementsWithConstantInTheMiddleQuickFix.$$$reportNull$$$0(2);
            }
            PsiFile file2 = descriptor2.getStartElement().getContainingFile();
            InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile(project, (Consumer<InspectionProfileModifiableModel>)((Consumer)it -> {
                ((PyChainedComparisonsInspection)it.getUnwrappedTool((String)PyChainedComparisonsInspection.INSPECTION_SHORT_NAME, (PsiElement)file2)).ignoreConstantInTheMiddle = true;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyChainedComparisonsInspection$DontSimplifyStatementsWithConstantInTheMiddleQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyChainedComparisonsInspection$DontSimplifyStatementsWithConstantInTheMiddleQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Visitor
    extends PyInspectionVisitor {
        boolean myIsLeft;
        boolean myIsRight;
        PyElementType myOperator;
        boolean getInnerRight;
        boolean isConstantInTheMiddle;
        boolean ignoreConstantInTheMiddle;

        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session2, boolean ignoreConstantInTheMiddle) {
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
            this.ignoreConstantInTheMiddle = ignoreConstantInTheMiddle;
        }

        @Override
        public void visitPyBinaryExpression(PyBinaryExpression node) {
            this.myIsLeft = false;
            this.myIsRight = false;
            this.myOperator = null;
            this.getInnerRight = false;
            PyBinaryExpression leftExpression = PyUtil.as(node.getLeftExpression(), PyBinaryExpression.class);
            PyBinaryExpression rightExpression = PyUtil.as(node.getRightExpression(), PyBinaryExpression.class);
            if (leftExpression != null && rightExpression != null && node.getOperator() == PyTokenTypes.AND_KEYWORD) {
                boolean applicable = false;
                if (leftExpression.getOperator() == PyTokenTypes.AND_KEYWORD) {
                    PyBinaryExpression leftLeft = PyUtil.as(leftExpression.getLeftExpression(), PyBinaryExpression.class);
                    PyBinaryExpression leftRight = PyUtil.as(leftExpression.getRightExpression(), PyBinaryExpression.class);
                    if (leftLeft != null && (this.isRightSimplified(leftLeft, rightExpression) || this.isLeftSimplified(leftLeft, rightExpression))) {
                        applicable = true;
                        this.getInnerRight = false;
                    } else if (leftRight != null && (this.isRightSimplified(leftRight, rightExpression) || this.isLeftSimplified(leftRight, rightExpression))) {
                        applicable = true;
                        this.getInnerRight = true;
                    }
                } else if (this.isRightSimplified(leftExpression, rightExpression) || this.isLeftSimplified(leftExpression, rightExpression)) {
                    applicable = true;
                }
                if (applicable) {
                    if (this.isConstantInTheMiddle) {
                        if (!this.ignoreConstantInTheMiddle) {
                            this.registerProblem((PsiElement)node, "Simplify chained comparison", new ChainedComparisonsQuickFix(this.myIsLeft, this.myIsRight, this.getInnerRight), new DontSimplifyStatementsWithConstantInTheMiddleQuickFix());
                        }
                    } else {
                        this.registerProblem((PsiElement)node, "Simplify chained comparison", new ChainedComparisonsQuickFix(this.myIsLeft, this.myIsRight, this.getInnerRight));
                    }
                }
            }
        }

        private boolean isRightSimplified(@NotNull PyBinaryExpression leftExpression, @NotNull PyBinaryExpression rightExpression) {
            PyExpression leftRight;
            if (leftExpression == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (rightExpression == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((leftRight = leftExpression.getRightExpression()) instanceof PyBinaryExpression && PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)((PyBinaryExpression)leftRight).getOperator()) && this.isRightSimplified((PyBinaryExpression)leftRight, rightExpression)) {
                return true;
            }
            this.myOperator = leftExpression.getOperator();
            if (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)this.myOperator) && leftRight != null) {
                if (leftRight.getText().equals(this.getLeftExpression(rightExpression, true).getText())) {
                    this.myIsLeft = false;
                    this.myIsRight = true;
                    this.isConstantInTheMiddle = leftRight instanceof PyLiteralExpression;
                    return true;
                }
                PyExpression right = this.getSmallestRight(rightExpression, true);
                if (right != null && leftRight.getText().equals(right.getText())) {
                    this.myIsLeft = false;
                    this.myIsRight = false;
                    this.isConstantInTheMiddle = leftRight instanceof PyLiteralExpression;
                    return true;
                }
            }
            return false;
        }

        private static boolean isOpposite(PyElementType op1, PyElementType op2) {
            if (!(op1 != PyTokenTypes.GT && op1 != PyTokenTypes.GE || op2 != PyTokenTypes.LT && op2 != PyTokenTypes.LE)) {
                return true;
            }
            return !(op2 != PyTokenTypes.GT && op2 != PyTokenTypes.GE || op1 != PyTokenTypes.LT && op1 != PyTokenTypes.LE);
        }

        private boolean isLeftSimplified(PyBinaryExpression leftExpression, PyBinaryExpression rightExpression) {
            PyExpression leftLeft = leftExpression.getLeftExpression();
            if (leftLeft instanceof PyBinaryExpression && PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)((PyBinaryExpression)leftLeft).getOperator()) && this.isLeftSimplified((PyBinaryExpression)leftLeft, rightExpression)) {
                return true;
            }
            this.myOperator = leftExpression.getOperator();
            if (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)this.myOperator) && leftLeft != null) {
                if (leftLeft.getText().equals(this.getLeftExpression(rightExpression, false).getText())) {
                    this.myIsLeft = true;
                    this.myIsRight = true;
                    this.isConstantInTheMiddle = leftLeft instanceof PyLiteralExpression;
                    return true;
                }
                PyExpression right = this.getSmallestRight(rightExpression, false);
                if (right != null && leftLeft.getText().equals(right.getText())) {
                    this.myIsLeft = true;
                    this.myIsRight = false;
                    this.isConstantInTheMiddle = leftLeft instanceof PyLiteralExpression;
                    return true;
                }
            }
            return false;
        }

        private PyExpression getLeftExpression(PyBinaryExpression expression, boolean isRight) {
            PyExpression result2 = expression;
            while (result2 instanceof PyBinaryExpression && (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)result2.getOperator()) || PyTokenTypes.EQUALITY_OPERATIONS.contains((IElementType)result2.getOperator()))) {
                boolean opposite = Visitor.isOpposite(result2.getOperator(), this.myOperator);
                if (isRight && opposite || !isRight && !opposite) break;
                result2 = result2.getLeftExpression();
            }
            return result2;
        }

        @Nullable
        private PyExpression getSmallestRight(PyBinaryExpression expression, boolean isRight) {
            PyExpression result2 = expression;
            while (result2 instanceof PyBinaryExpression && (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)result2.getOperator()) || PyTokenTypes.EQUALITY_OPERATIONS.contains((IElementType)result2.getOperator()))) {
                boolean opposite = Visitor.isOpposite(result2.getOperator(), this.myOperator);
                if (isRight && !opposite || !isRight && opposite) break;
                result2 = result2.getRightExpression();
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightExpression";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyChainedComparisonsInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isRightSimplified";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

