/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.stdlib.PyDataclassParameters;
import com.jetbrains.python.codeInsight.stdlib.PyDataclassesKt;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.inspections.PyDataclassInspection;
import com.jetbrains.python.inspections.PyDataclassInspection$Visitor$visitPyDelStatement$;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyNamedTupleInspection;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDelStatement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.stubs.PyDataclassFieldStubImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.stubs.PyDataclassFieldStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/inspections/PyDataclassInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "Visitor", "intellij.python.community.impl"})
public final class PyDataclassInspection
extends PyInspection {
    private static final Set<String> ORDER_OPERATORS;
    private static final Set<String> DATACLASSES_HELPERS;
    private static final Set<String> ATTRS_HELPERS;
    public static final Companion Companion;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        return new Visitor(holder, session2);
    }

    static {
        Companion = new Companion(null);
        ORDER_OPERATORS = SetsKt.setOf((Object[])new String[]{"__lt__", "__le__", "__gt__", "__ge__"});
        DATACLASSES_HELPERS = SetsKt.setOf((Object[])new String[]{"dataclasses.fields", "dataclasses.asdict", "dataclasses.astuple", "dataclasses.replace"});
        ATTRS_HELPERS = SetsKt.setOf((Object[])new String[]{"attr.__init__.fields", "attr.__init__.fields_dict", "attr.__init__.asdict", "attr.__init__.astuple", "attr.__init__.assoc", "attr.__init__.evolve"});
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J*\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0018\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0010\u0010#\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0018\u0010$\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010%\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010&\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010'\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010(\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010)\u001a\u00020\b2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0002J\u001a\u0010.\u001a\u00020\b2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0002J&\u0010/\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001201H\u0002J\u0012\u00102\u001a\u00020\b2\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0012\u00105\u001a\u00020\b2\b\u00103\u001a\u0004\u0018\u000106H\u0016J\u0012\u00107\u001a\u00020\b2\b\u00103\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u00108\u001a\u00020\b2\b\u00103\u001a\u0004\u0018\u000109H\u0016J\u0012\u0010:\u001a\u00020\b2\b\u00103\u001a\u0004\u0018\u00010;H\u0016J\u0012\u0010<\u001a\u00020\b2\b\u00103\u001a\u0004\u0018\u00010\u0012H\u0016\u00a8\u0006="}, d2={"Lcom/jetbrains/python/inspections/PyDataclassInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "checkMutatingFrozenAttribute", "", "expression", "Lcom/jetbrains/python/psi/PyQualifiedExpression;", "getInstancePyClass", "Lcom/jetbrains/python/psi/PyClass;", "element", "Lcom/jetbrains/python/psi/PyTypedElement;", "isInitVar", "", "field", "Lcom/jetbrains/python/psi/PyTargetExpression;", "isNotExpectedDataclass", "type", "Lcom/jetbrains/python/psi/types/PyType;", "dataclassType", "Lcom/jetbrains/python/codeInsight/stdlib/PyDataclassParameters$Type;", "allowDefinition", "allowInstance", "processAsInitVar", "postInit", "Lcom/jetbrains/python/psi/PyFunction;", "processAttrIbFunctionCalls", "cls", "processAttrsAutoAttribs", "dataclassParameters", "Lcom/jetbrains/python/codeInsight/stdlib/PyDataclassParameters;", "processAttrsDefaultThroughDecorator", "processAttrsInitializersAndValidators", "processAttrsParameters", "processAttrsPostInitDefinition", "processDataclassParameters", "processDefaultFieldValue", "processFieldFunctionCall", "processHelperAttrsArgument", "argument", "Lcom/jetbrains/python/psi/PyExpression;", "calleeQName", "", "processHelperDataclassArgument", "processPostInitDefinition", "initVars", "", "visitPyBinaryExpression", "node", "Lcom/jetbrains/python/psi/PyBinaryExpression;", "visitPyCallExpression", "Lcom/jetbrains/python/psi/PyCallExpression;", "visitPyClass", "visitPyDelStatement", "Lcom/jetbrains/python/psi/PyDelStatement;", "visitPyReferenceExpression", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "visitPyTargetExpression", "intellij.python.community.impl"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @Override
        public void visitPyTargetExpression(@Nullable PyTargetExpression node) {
            super.visitPyTargetExpression(node);
            if (node != null) {
                this.checkMutatingFrozenAttribute(node);
            }
        }

        @Override
        public void visitPyDelStatement(@Nullable PyDelStatement node) {
            super.visitPyDelStatement(node);
            if (node != null) {
                Object[] objectArray = node.getTargets();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"node\n          .targets");
                Sequence $receiver$iv = ArraysKt.asSequence((Object[])objectArray);
                Sequence sequence = SequencesKt.filter((Sequence)$receiver$iv, (Function1)Visitor$visitPyDelStatement$$inlined$filterIsInstance$1.INSTANCE);
                if (sequence == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                $receiver$iv = sequence;
                for (Object element$iv : $receiver$iv) {
                    PyReferenceExpression it = (PyReferenceExpression)element$iv;
                    this.checkMutatingFrozenAttribute(it);
                }
            }
        }

        @Override
        public void visitPyClass(@Nullable PyClass node) {
            super.visitPyClass(node);
            if (node != null) {
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                PyDataclassParameters dataclassParameters = PyDataclassesKt.parseDataclassParameters(node, typeEvalContext);
                if (dataclassParameters != null) {
                    if (dataclassParameters.getType() == PyDataclassParameters.Type.STD) {
                        this.processDataclassParameters(node, dataclassParameters);
                        PyFunction postInit = node.findMethodByName("__post_init__", false, this.myTypeEvalContext);
                        List initVars = new ArrayList();
                        node.processClassLevelDeclarations(new PsiScopeProcessor(this, postInit, initVars){
                            final /* synthetic */ Visitor this$0;
                            final /* synthetic */ PyFunction $postInit;
                            final /* synthetic */ List $initVars;

                            public final boolean execute(@NotNull PsiElement element, @NotNull ResolveState $noName_1) {
                                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                if (element instanceof PyTargetExpression) {
                                    if (!PyTypingTypeProvider.isClassVar((PyAnnotationOwner)element, this.this$0.myTypeEvalContext)) {
                                        Visitor.access$processDefaultFieldValue(this.this$0, (PyTargetExpression)element);
                                        PyTargetExpression pyTargetExpression = Visitor.access$processAsInitVar(this.this$0, (PyTargetExpression)element, this.$postInit);
                                        if (pyTargetExpression != null) {
                                            PyTargetExpression pyTargetExpression2;
                                            PyTargetExpression it = pyTargetExpression2 = pyTargetExpression;
                                            this.$initVars.add(it);
                                        }
                                    }
                                    Visitor.access$processFieldFunctionCall(this.this$0, (PyTargetExpression)element);
                                }
                                return true;
                            }
                            {
                                this.this$0 = visitor2;
                                this.$postInit = pyFunction;
                                this.$initVars = list2;
                            }
                        });
                        if (postInit != null) {
                            this.processPostInitDefinition(postInit, dataclassParameters, initVars);
                        }
                    } else if (dataclassParameters.getType() == PyDataclassParameters.Type.ATTRS) {
                        this.processAttrsParameters(node, dataclassParameters);
                        PyFunction pyFunction = node.findMethodByName("__attrs_post_init__", false, this.myTypeEvalContext);
                        if (pyFunction != null) {
                            PyFunction pyFunction2;
                            PyFunction it;
                            PyFunction pyFunction3 = it = (pyFunction2 = pyFunction);
                            Intrinsics.checkExpressionValueIsNotNull((Object)pyFunction3, (String)"it");
                            this.processAttrsPostInitDefinition(pyFunction3, dataclassParameters);
                        }
                        this.processAttrsDefaultThroughDecorator(node);
                        this.processAttrsInitializersAndValidators(node);
                        this.processAttrsAutoAttribs(node, dataclassParameters);
                        this.processAttrIbFunctionCalls(node);
                    }
                    PyNamedTupleInspection.Companion.inspectFieldsOrder(node, (Function3<? super PsiElement, ? super String, ? super ProblemHighlightType, Unit>)((Function3)new Function3<PsiElement, String, ProblemHighlightType, Unit>(this){

                        public final void invoke(PsiElement p1, String p2, ProblemHighlightType p3) {
                            ((Visitor)((Object)this.receiver)).registerProblem(p1, p2, p3);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(Visitor.class);
                        }

                        public final String getName() {
                            return "registerProblem";
                        }

                        public final String getSignature() {
                            return "registerProblem(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;)V";
                        }
                    }), (Function1<? super PyTargetExpression, Boolean>)((Function1)new Function1<PyTargetExpression, Boolean>(this){
                        final /* synthetic */ Visitor this$0;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean invoke(@NotNull PyTargetExpression it) {
                            PyDataclassFieldStub fieldStub;
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            PyTargetExpressionStub stub = (PyTargetExpressionStub)it.getStub();
                            PyDataclassFieldStub pyDataclassFieldStub = fieldStub = stub == null ? PyDataclassFieldStubImpl.Companion.create(it) : stub.getCustomStub(PyDataclassFieldStub.class);
                            if (pyDataclassFieldStub != null) {
                                if (!pyDataclassFieldStub.initValue()) return false;
                            }
                            if (PyTypingTypeProvider.isClassVar(it, this.this$0.myTypeEvalContext)) return false;
                            return true;
                        }
                        {
                            this.this$0 = visitor2;
                            super(1);
                        }
                    }), (Function1<? super PyTargetExpression, Boolean>)((Function1)new Function1<PyTargetExpression, Boolean>(dataclassParameters, node){
                        final /* synthetic */ PyDataclassParameters $dataclassParameters;
                        final /* synthetic */ PyClass $node;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean invoke(@NotNull PyTargetExpression it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            PyDataclassFieldStub fieldStub = PyDataclassFieldStubImpl.Companion.create(it);
                            if (fieldStub != null) {
                                if (fieldStub.hasDefault()) return true;
                                if (fieldStub.hasDefaultFactory()) return true;
                                if (this.$dataclassParameters.getType() != PyDataclassParameters.Type.ATTRS) return false;
                                PyFunction[] pyFunctionArray = this.$node.getMethods();
                                Intrinsics.checkExpressionValueIsNotNull((Object)pyFunctionArray, (String)"node.methods");
                                PyFunction[] $receiver$iv = pyFunctionArray;
                                int n = $receiver$iv.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    PyFunction element$iv;
                                    PyFunction m;
                                    PyFunction pyFunction = m = (element$iv = $receiver$iv[n2]);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)pyFunction, (String)"m");
                                    PyDecoratorList pyDecoratorList = pyFunction.getDecoratorList();
                                    if ((pyDecoratorList != null ? pyDecoratorList.findDecorator(it.getName() + ".default") : null) != null) {
                                        return true;
                                    }
                                    boolean bl = false;
                                    if (bl) {
                                        return true;
                                    }
                                    ++n2;
                                }
                                return false;
                            }
                            PyExpression assignedValue = it.findAssignedValue();
                            if (assignedValue == null) return false;
                            if (PyDataclassesKt.resolvesToOmittedDefault(assignedValue, this.$dataclassParameters.getType())) return false;
                            return true;
                        }
                        {
                            this.$dataclassParameters = pyDataclassParameters;
                            this.$node = pyClass;
                            super(1);
                        }
                    }));
                }
            }
        }

        @Override
        public void visitPyBinaryExpression(@Nullable PyBinaryExpression node) {
            super.visitPyBinaryExpression(node);
            if (node != null && CollectionsKt.contains((Iterable)ORDER_OPERATORS, (Object)node.getReferencedName())) {
                PyClass pyClass = this.getInstancePyClass(node.getLeftExpression());
                if (pyClass == null) {
                    return;
                }
                PyClass leftClass = pyClass;
                PyClass pyClass2 = this.getInstancePyClass(node.getRightExpression());
                if (pyClass2 == null) {
                    return;
                }
                PyClass rightClass = pyClass2;
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                PyDataclassParameters leftDataclassParameters = PyDataclassesKt.parseDataclassParameters(leftClass, typeEvalContext);
                if (Intrinsics.areEqual((Object)leftClass, (Object)rightClass) ^ true && leftDataclassParameters != null) {
                    TypeEvalContext typeEvalContext2 = this.myTypeEvalContext;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext2, (String)"myTypeEvalContext");
                    if (PyDataclassesKt.parseDataclassParameters(rightClass, typeEvalContext2) != null) {
                        this.registerProblem(node.getPsiOperator(), '\'' + node.getReferencedName() + "' not supported between instances of '" + leftClass.getName() + "' and '" + rightClass.getName() + '\'', ProblemHighlightType.GENERIC_ERROR);
                    }
                }
                if (Intrinsics.areEqual((Object)leftClass, (Object)rightClass)) {
                    PyDataclassParameters pyDataclassParameters = leftDataclassParameters;
                    if (pyDataclassParameters != null) {
                        if (!pyDataclassParameters.getOrder()) {
                            this.registerProblem(node.getPsiOperator(), '\'' + node.getReferencedName() + "' not supported between instances of '" + leftClass.getName() + '\'', ProblemHighlightType.GENERIC_ERROR);
                        }
                    }
                }
            }
        }

        @Override
        public void visitPyCallExpression(@Nullable PyCallExpression node) {
            super.visitPyCallExpression(node);
            if (node != null) {
                String calleeQName;
                PyCallable callee;
                PyCallExpression.PyMarkedCallee markedCallee;
                PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(this.myTypeEvalContext);
                List<PyCallExpression.PyMarkedCallee> list2 = node.multiResolveCallee(resolveContext);
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"node.multiResolveCallee(resolveContext)");
                PyCallExpression.PyMarkedCallee pyMarkedCallee = markedCallee = (PyCallExpression.PyMarkedCallee)CollectionsKt.singleOrNull(list2);
                PyCallable pyCallable = callee = pyMarkedCallee != null ? pyMarkedCallee.getElement() : null;
                String string = calleeQName = pyCallable != null ? pyCallable.getQualifiedName() : null;
                if (markedCallee != null && callee != null) {
                    PyExpression dataclassArgument;
                    Object v7;
                    PyDataclassParameters.Type dataclassType;
                    block12: {
                        PyDataclassParameters.Type type;
                        if (CollectionsKt.contains((Iterable)DATACLASSES_HELPERS, (Object)calleeQName)) {
                            type = PyDataclassParameters.Type.STD;
                        } else if (CollectionsKt.contains((Iterable)ATTRS_HELPERS, (Object)calleeQName)) {
                            type = PyDataclassParameters.Type.ATTRS;
                        } else {
                            return;
                        }
                        dataclassType = type;
                        PyCallExpression.PyArgumentsMapping pyArgumentsMapping = PyCallExpressionHelper.mapArguments(node, markedCallee, this.myTypeEvalContext);
                        Intrinsics.checkExpressionValueIsNotNull((Object)pyArgumentsMapping, (String)"PyCallExpressionHelper.m\u2026allee, myTypeEvalContext)");
                        PyCallExpression.PyArgumentsMapping mapping = pyArgumentsMapping;
                        List<PyCallableParameter> list3 = callee.getParameters(this.myTypeEvalContext);
                        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"callee.getParameters(myTypeEvalContext)");
                        PyCallableParameter dataclassParameter = (PyCallableParameter)CollectionsKt.firstOrNull(list3);
                        Iterable $receiver$iv = mapping.getMappedParameters().entrySet();
                        for (Object element$iv : $receiver$iv) {
                            Map.Entry it = (Map.Entry)element$iv;
                            if (!Intrinsics.areEqual((Object)((PyCallableParameter)it.getValue()), (Object)dataclassParameter)) continue;
                            v7 = element$iv;
                            break block12;
                        }
                        v7 = null;
                    }
                    Map.Entry entry = v7;
                    PyExpression pyExpression = dataclassArgument = entry != null ? (PyExpression)entry.getKey() : null;
                    if (dataclassType == PyDataclassParameters.Type.STD) {
                        String string2 = calleeQName;
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.processHelperDataclassArgument(dataclassArgument, string2);
                    } else if (dataclassType == PyDataclassParameters.Type.ATTRS) {
                        String string3 = calleeQName;
                        if (string3 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.processHelperAttrsArgument(dataclassArgument, string3);
                    }
                }
            }
        }

        @Override
        public void visitPyReferenceExpression(@Nullable PyReferenceExpression node) {
            super.visitPyReferenceExpression(node);
            if (node != null && node.isQualified()) {
                PyClass pyClass = this.getInstancePyClass(node.getQualifier());
                if (pyClass == null) {
                    return;
                }
                PyClass cls = pyClass;
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyDataclassesKt.parseStdDataclassParameters(cls, typeEvalContext) != null) {
                    cls.processClassLevelDeclarations(new PsiScopeProcessor(this, node, cls){
                        final /* synthetic */ Visitor this$0;
                        final /* synthetic */ PyReferenceExpression $node;
                        final /* synthetic */ PyClass $cls;

                        public final boolean execute(@NotNull PsiElement element, @NotNull ResolveState $noName_1) {
                            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                            Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                            if (element instanceof PyTargetExpression && Intrinsics.areEqual((Object)((PyTargetExpression)element).getName(), (Object)this.$node.getName()) && Visitor.access$isInitVar(this.this$0, (PyTargetExpression)element)) {
                                this.this$0.registerProblem(this.$node.getLastChild(), '\'' + this.$cls.getName() + "' object could have no attribute '" + ((PyTargetExpression)element).getName() + "' because it is declared as init-only", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                                return false;
                            }
                            return true;
                        }
                        {
                            this.this$0 = visitor2;
                            this.$node = pyReferenceExpression;
                            this.$cls = pyClass;
                        }
                    });
                }
            }
        }

        private final void checkMutatingFrozenAttribute(PyQualifiedExpression expression) {
            PyClass pyClass = this.getInstancePyClass(expression.getQualifier());
            if (pyClass == null) {
                return;
            }
            PyClass cls = pyClass;
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
            PyDataclassParameters pyDataclassParameters = PyDataclassesKt.parseDataclassParameters(cls, typeEvalContext);
            if (pyDataclassParameters != null) {
                if (pyDataclassParameters.getFrozen()) {
                    this.registerProblem((PsiElement)expression, '\'' + cls.getName() + "' object attribute '" + expression.getName() + "' is read-only", ProblemHighlightType.GENERIC_ERROR);
                }
            }
        }

        private final PyClass getInstancePyClass(PyTypedElement element) {
            PyClassType type;
            PyType pyType;
            PyType pyType2;
            PyTypedElement pyTypedElement = element;
            if (pyTypedElement != null) {
                PyTypedElement pyTypedElement2;
                PyTypedElement it = pyTypedElement2 = pyTypedElement;
                pyType2 = this.myTypeEvalContext.getType(it);
            } else {
                pyType2 = pyType = null;
            }
            if (!(pyType2 instanceof PyClassType)) {
                pyType = null;
            }
            return (type = (PyClassType)pyType) != null && !type.isDefinition() ? type.getPyClass() : null;
        }

        private final void processDataclassParameters(PyClass cls, PyDataclassParameters dataclassParameters) {
            PyFunction it;
            if (!dataclassParameters.getEq() && dataclassParameters.getOrder()) {
                this.registerProblem((PsiElement)dataclassParameters.getEqArgument(), "'eq' must be true if 'order' is true", ProblemHighlightType.GENERIC_ERROR);
            }
            boolean initMethodExists = false;
            boolean reprMethodExists = false;
            boolean eqMethodExists = false;
            boolean orderMethodsExist = false;
            boolean mutatingMethodsExist = false;
            boolean hashMethodExists = false;
            PyFunction[] pyFunctionArray = cls.getMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)pyFunctionArray, (String)"cls.methods");
            PyFunction[] $receiver$iv = pyFunctionArray;
            int n = $receiver$iv.length;
            for (int i = 0; i < n; ++i) {
                PyFunction element$iv;
                PyFunction pyFunction = it = (element$iv = $receiver$iv[i]);
                Intrinsics.checkExpressionValueIsNotNull((Object)pyFunction, (String)"it");
                String string = pyFunction.getName();
                if (Intrinsics.areEqual((Object)string, (Object)"__init__")) {
                    initMethodExists = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__repr__")) {
                    reprMethodExists = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__eq__")) {
                    eqMethodExists = true;
                    continue;
                }
                if (CollectionsKt.contains((Iterable)ORDER_OPERATORS, (Object)string)) {
                    orderMethodsExist = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__setattr__") || Intrinsics.areEqual((Object)string, (Object)"__delattr__")) {
                    mutatingMethodsExist = true;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"__hash__")) continue;
                hashMethodExists = true;
            }
            hashMethodExists = hashMethodExists || cls.findClassAttribute("__hash__", false, this.myTypeEvalContext) != null;
            List useless = new ArrayList();
            if (dataclassParameters.getInit() && initMethodExists) {
                useless.add(new Triple((Object)dataclassParameters.getInitArgument(), (Object)"init", (Object)"__init__"));
            }
            if (dataclassParameters.getRepr() && reprMethodExists) {
                useless.add(new Triple((Object)dataclassParameters.getReprArgument(), (Object)"repr", (Object)"__repr__"));
            }
            if (dataclassParameters.getEq() && eqMethodExists) {
                useless.add(new Triple((Object)dataclassParameters.getEqArgument(), (Object)"eq", (Object)"__eq__"));
            }
            Iterable $receiver$iv2 = useless;
            for (PyFunction element$iv : $receiver$iv2) {
                it = (Triple)element$iv;
                this.registerProblem((PsiElement)it.getFirst(), '\'' + (String)it.getSecond() + "' is ignored if the class already defines '" + (String)it.getThird() + "' method", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
            if (dataclassParameters.getOrder() && orderMethodsExist) {
                this.registerProblem((PsiElement)dataclassParameters.getOrderArgument(), "'order' should be false if the class defines one of order methods", ProblemHighlightType.GENERIC_ERROR);
            }
            if (dataclassParameters.getFrozen() && mutatingMethodsExist) {
                this.registerProblem((PsiElement)dataclassParameters.getFrozenArgument(), "'frozen' should be false if the class defines '__setattr__' or '__delattr__'", ProblemHighlightType.GENERIC_ERROR);
            }
            if (dataclassParameters.getUnsafeHash() && hashMethodExists) {
                this.registerProblem((PsiElement)dataclassParameters.getUnsafeHashArgument(), "'unsafe_hash' should be false if the class defines '__hash__'", ProblemHighlightType.GENERIC_ERROR);
            }
        }

        private final void processAttrsParameters(PyClass cls, PyDataclassParameters dataclassParameters) {
            Iterable $receiver$iv3;
            Collection collection;
            String string;
            PyFunction element$iv2;
            PyFunction it;
            PyFunction initMethod = null;
            PyFunction reprMethod = null;
            PyFunction strMethod = null;
            List cmpMethods = new ArrayList();
            List mutatingMethods = new ArrayList();
            PsiNameIdentifierOwner hashMethod = null;
            PyFunction[] pyFunctionArray = cls.getMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)pyFunctionArray, (String)"cls.methods");
            PyFunction[] $receiver$iv2 = pyFunctionArray;
            int n = $receiver$iv2.length;
            for (int i = 0; i < n; ++i) {
                PyFunction pyFunction = it = (element$iv2 = $receiver$iv2[i]);
                Intrinsics.checkExpressionValueIsNotNull((Object)pyFunction, (String)"it");
                string = pyFunction.getName();
                if (Intrinsics.areEqual((Object)string, (Object)"__init__")) {
                    initMethod = it;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__repr__")) {
                    reprMethod = it;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__str__")) {
                    strMethod = it;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__eq__") || CollectionsKt.contains((Iterable)ORDER_OPERATORS, (Object)string)) {
                    cmpMethods.add(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__setattr__") || Intrinsics.areEqual((Object)string, (Object)"__delattr__")) {
                    mutatingMethods.add(it);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"__hash__")) continue;
                hashMethod = it;
            }
            PsiNameIdentifierOwner psiNameIdentifierOwner = hashMethod;
            if (psiNameIdentifierOwner == null) {
                psiNameIdentifierOwner = cls.findClassAttribute("__hash__", false, this.myTypeEvalContext);
            }
            hashMethod = psiNameIdentifierOwner;
            List problems = new ArrayList();
            if (dataclassParameters.getInit() && initMethod != null) {
                problems.add(TuplesKt.to((Object)initMethod, (Object)"init"));
            }
            if (dataclassParameters.getRepr() && reprMethod != null) {
                problems.add(TuplesKt.to((Object)reprMethod, (Object)"repr"));
            }
            if (PyEvaluator.evaluateAsBoolean(PyUtil.peelArgument(dataclassParameters.getOthers().get("str")), false) && strMethod != null) {
                problems.add(TuplesKt.to((Object)strMethod, (Object)"str"));
            }
            if (dataclassParameters.getOrder() && !(collection = (Collection)cmpMethods).isEmpty()) {
                Iterable $receiver$iv3 = cmpMethods;
                Iterator iterator = $receiver$iv3.iterator();
                while (iterator.hasNext()) {
                    it = element$iv2 = iterator.next();
                    problems.add(TuplesKt.to((Object)it, (Object)"cmp"));
                }
            }
            if (dataclassParameters.getFrozen() && !($receiver$iv3 = (Collection)mutatingMethods).isEmpty()) {
                $receiver$iv3 = mutatingMethods;
                Iterator iterator = $receiver$iv3.iterator();
                while (iterator.hasNext()) {
                    it = element$iv2 = iterator.next();
                    problems.add(TuplesKt.to((Object)it, (Object)"frozen"));
                }
            }
            if (dataclassParameters.getUnsafeHash() && hashMethod != null) {
                problems.add(TuplesKt.to((Object)hashMethod, (Object)"hash"));
            }
            Iterable $receiver$iv22 = problems;
            for (PyFunction element$iv2 : $receiver$iv22) {
                it = (Pair)element$iv2;
                if ((PsiNameIdentifierOwner)it.getFirst() == null) continue;
                String $receiver = string;
                this.registerProblem($receiver.getNameIdentifier(), '\'' + $receiver.getName() + "' is ignored if the class already defines '" + (String)it.getSecond() + "' parameter", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
            if (dataclassParameters.getOrder() && dataclassParameters.getFrozen() && hashMethod != null) {
                PsiNameIdentifierOwner psiNameIdentifierOwner2 = hashMethod;
                this.registerProblem((PsiElement)(psiNameIdentifierOwner2 != null ? psiNameIdentifierOwner2.getNameIdentifier() : null), "'__hash__' is ignored if the class already defines 'cmp' and 'frozen' parameters", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }

        private final void processDefaultFieldValue(PyTargetExpression field) {
            if (field.getAnnotationValue() == null) {
                return;
            }
            PyExpression value = field.findAssignedValue();
            if (PyUtil.isForbiddenMutableDefault(value, this.myTypeEvalContext)) {
                PyExpression pyExpression = value;
                this.registerProblem((PsiElement)value, "Mutable default '" + (pyExpression != null ? pyExpression.getText() : null) + "' is not allowed. Use 'default_factory'", ProblemHighlightType.GENERIC_ERROR);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processAttrsDefaultThroughDecorator(PyClass cls) {
            Sequence decorators;
            Map initializers = new LinkedHashMap();
            PyFunction[] pyFunctionArray = cls.getMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)pyFunctionArray, (String)"cls.methods");
            Object $receiver$iv = pyFunctionArray;
            int n = ((PyFunction[])$receiver$iv).length;
            for (int i = 0; i < n; ++i) {
                Object object;
                PyFunction element$iv;
                PyFunction method;
                PyFunction pyFunction = method = (element$iv = $receiver$iv[i]);
                Intrinsics.checkExpressionValueIsNotNull((Object)pyFunction, (String)"method");
                PyDecoratorList pyDecoratorList = pyFunction.getDecoratorList();
                Object object2 = decorators = pyDecoratorList != null ? pyDecoratorList.getDecorators() : null;
                if (decorators == null) continue;
                if ((String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])decorators), (Function1)processAttrsDefaultThroughDecorator.1.1.INSTANCE), (Function1)processAttrsDefaultThroughDecorator.1.2.INSTANCE), (Function1)processAttrsDefaultThroughDecorator.1.3.INSTANCE)) == null) continue;
                Object name = object;
                PyTargetExpression attribute = cls.findClassAttribute((String)name, false, this.myTypeEvalContext);
                if (attribute == null) continue;
                ((List)initializers.computeIfAbsent(name, processAttrsDefaultThroughDecorator.1.4.1.INSTANCE)).add(method);
                PyDataclassFieldStub stub = PyDataclassFieldStubImpl.Companion.create(attribute);
                if (stub == null || !stub.hasDefault() && !stub.hasDefaultFactory()) continue;
                this.registerProblem(method.getNameIdentifier(), "A default is set using 'attr.ib()'", ProblemHighlightType.GENERIC_ERROR);
            }
            $receiver$iv = initializers.values();
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                void $receiver$iv2;
                Object element$iv = iterator.next();
                List sameAttrInitializers = (List)element$iv;
                PyFunction first = (PyFunction)sameAttrInitializers.get(0);
                decorators = SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)sameAttrInitializers), (int)1);
                for (Object element$iv2 : $receiver$iv2) {
                    PyFunction it = (PyFunction)element$iv2;
                    this.registerProblem(it.getNameIdentifier(), "A default is set using '" + first.getName() + '\'', ProblemHighlightType.GENERIC_ERROR);
                }
            }
        }

        private final void processAttrsInitializersAndValidators(PyClass cls) {
            cls.visitMethods((Processor<PyFunction>)((Processor)new Processor<PyFunction>(this){
                final /* synthetic */ Visitor this$0;

                public final boolean process(PyFunction method) {
                    Object[] decorators;
                    PyFunction pyFunction = method;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pyFunction, (String)"method");
                    PyDecoratorList pyDecoratorList = pyFunction.getDecoratorList();
                    Object object = decorators = pyDecoratorList != null ? pyDecoratorList.getDecorators() : null;
                    if (decorators != null) {
                        Sequence $receiver$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])decorators), (Function1)processAttrsInitializersAndValidators.1.INSTANCE), (Function1)processAttrsInitializersAndValidators.2.INSTANCE), (Function1)processAttrsInitializersAndValidators.3.INSTANCE);
                        block8: for (E element$iv : $receiver$iv) {
                            PyParameterList actualParameters;
                            int n;
                            String it;
                            switch (it = (String)element$iv) {
                                case "default": {
                                    n = 1;
                                    break;
                                }
                                case "validator": {
                                    n = 3;
                                    break;
                                }
                                default: {
                                    continue block8;
                                }
                            }
                            int expectedParameters = n;
                            Intrinsics.checkExpressionValueIsNotNull((Object)method.getParameterList(), (String)"method.parameterList");
                            if (actualParameters.getParameters().length == expectedParameters) continue;
                            String message = '\'' + method.getName() + "' should take only " + expectedParameters + " parameter" + (expectedParameters > 1 ? "s" : "");
                            this.this$0.registerProblem((PsiElement)actualParameters, message, ProblemHighlightType.GENERIC_ERROR);
                        }
                    }
                    return true;
                }
                {
                    this.this$0 = visitor2;
                }
            }), false, this.myTypeEvalContext);
        }

        private final void processAttrsAutoAttribs(PyClass cls, PyDataclassParameters dataclassParameters) {
            if (PyEvaluator.evaluateAsBoolean(PyUtil.peelArgument(dataclassParameters.getOthers().get("auto_attribs")), false)) {
                cls.processClassLevelDeclarations(new PsiScopeProcessor(this){
                    final /* synthetic */ Visitor this$0;

                    public final boolean execute(@NotNull PsiElement element, @NotNull ResolveState $noName_1) {
                        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                        Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                        if (element instanceof PyTargetExpression && ((PyTargetExpression)element).getAnnotation() == null && PyDataclassFieldStubImpl.Companion.create((PyTargetExpression)element) != null) {
                            this.this$0.registerProblem(element, "Attribute '" + ((PyTargetExpression)element).getName() + "' lacks a type annotation", ProblemHighlightType.GENERIC_ERROR);
                        }
                        return true;
                    }
                    {
                        this.this$0 = visitor2;
                    }
                });
            }
        }

        private final void processAttrIbFunctionCalls(PyClass cls) {
            cls.processClassLevelDeclarations(new PsiScopeProcessor(this){
                final /* synthetic */ Visitor this$0;

                public final boolean execute(@NotNull PsiElement element, @NotNull ResolveState $noName_1) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                    if (element instanceof PyTargetExpression) {
                        PyExpression pyExpression = ((PyTargetExpression)element).findAssignedValue();
                        if (!(pyExpression instanceof PyCallExpression)) {
                            pyExpression = null;
                        }
                        PyCallExpression call = (PyCallExpression)pyExpression;
                        PyDataclassFieldStub stub = PyDataclassFieldStubImpl.Companion.create((PyTargetExpression)element);
                        if (call != null && stub != null && stub.hasDefaultFactory()) {
                            if (stub.hasDefault()) {
                                this.this$0.registerProblem((PsiElement)call.getArgumentList(), "Cannot specify both 'default' and 'factory'", ProblemHighlightType.GENERIC_ERROR);
                            } else {
                                PyExpression pyExpression2 = call.getKeywordArgument("default");
                                PyExpression factory = call.getKeywordArgument("factory");
                                if (pyExpression2 != null && factory != null && !PyDataclassesKt.resolvesToOmittedDefault(pyExpression2, PyDataclassParameters.Type.ATTRS)) {
                                    this.this$0.registerProblem((PsiElement)call.getArgumentList(), "Cannot specify both 'default' and 'factory'", ProblemHighlightType.GENERIC_ERROR);
                                }
                            }
                        }
                    }
                    return true;
                }
                {
                    this.this$0 = visitor2;
                }
            });
        }

        private final PyTargetExpression processAsInitVar(PyTargetExpression field, PyFunction postInit) {
            if (this.isInitVar(field)) {
                if (postInit == null) {
                    this.registerProblem((PsiElement)field, "Attribute '" + field.getName() + "' is useless until '__post_init__' is declared", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                }
                return field;
            }
            return null;
        }

        private final void processFieldFunctionCall(PyTargetExpression field) {
            PyDataclassFieldStub pyDataclassFieldStub = PyDataclassFieldStubImpl.Companion.create(field);
            if (pyDataclassFieldStub == null) {
                return;
            }
            PyDataclassFieldStub fieldStub = pyDataclassFieldStub;
            PyExpression pyExpression = field.findAssignedValue();
            if (!(pyExpression instanceof PyCallExpression)) {
                pyExpression = null;
            }
            PyCallExpression pyCallExpression = (PyCallExpression)pyExpression;
            if (pyCallExpression == null) {
                return;
            }
            PyCallExpression call = pyCallExpression;
            if (PyTypingTypeProvider.isClassVar(field, this.myTypeEvalContext) || this.isInitVar(field)) {
                if (fieldStub.hasDefaultFactory()) {
                    this.registerProblem((PsiElement)call.getKeywordArgument("default_factory"), "Field cannot have a default factory", ProblemHighlightType.GENERIC_ERROR);
                }
            } else if (fieldStub.hasDefault() && fieldStub.hasDefaultFactory()) {
                this.registerProblem((PsiElement)call.getArgumentList(), "Cannot specify both 'default' and 'default_factory'", ProblemHighlightType.GENERIC_ERROR);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processPostInitDefinition(PyFunction postInit, PyDataclassParameters dataclassParameters, List<? extends PyTargetExpression> initVars) {
            List list2;
            if (!dataclassParameters.getInit()) {
                this.registerProblem(postInit.getNameIdentifier(), "'__post_init__' would not be called until 'init' parameter is set to True", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            }
            List list3 = postInit.getParameters(this.myTypeEvalContext);
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"postInit.getParameters(myTypeEvalContext)");
            List implicitParameters = list3;
            if (implicitParameters.isEmpty()) {
                list2 = CollectionsKt.emptyList();
            } else {
                List list4 = ContainerUtil.subList((List)implicitParameters, (int)1);
                list2 = list4;
                Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"ContainerUtil.subList(implicitParameters, 1)");
            }
            List parameters2 = list2;
            String message = "'__post_init__' should take all init-only variables in the same order as they are defined";
            if (parameters2.size() != initVars.size()) {
                this.registerProblem((PsiElement)postInit.getParameterList(), message, ProblemHighlightType.GENERIC_ERROR);
            } else {
                boolean bl;
                boolean bl2;
                block7: {
                    void $receiver$iv;
                    Sequence sequence = SequencesKt.zip((Sequence)CollectionsKt.asSequence((Iterable)parameters2), (Sequence)CollectionsKt.asSequence((Iterable)initVars));
                    for (Object element$iv : $receiver$iv) {
                        Pair it = (Pair)element$iv;
                        if (Intrinsics.areEqual((Object)((PyCallableParameter)it.getFirst()).getName(), (Object)((PyTargetExpression)it.getSecond()).getName())) continue;
                        bl2 = false;
                        break block7;
                    }
                    bl2 = true;
                }
                boolean it = bl = bl2;
                if (!it) {
                    this.registerProblem((PsiElement)postInit.getParameterList(), message);
                }
            }
        }

        private final void processAttrsPostInitDefinition(PyFunction postInit, PyDataclassParameters dataclassParameters) {
            if (!dataclassParameters.getInit()) {
                this.registerProblem(postInit.getNameIdentifier(), "'__attrs_post_init__' would not be called until 'init' parameter is set to True", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            }
            if (postInit.getParameters(this.myTypeEvalContext).size() != 1) {
                this.registerProblem((PsiElement)postInit.getParameterList(), "'__attrs_post_init__' should not take any parameters except 'self'", ProblemHighlightType.GENERIC_ERROR);
            }
        }

        private final void processHelperDataclassArgument(PyExpression argument, String calleeQName) {
            if (argument == null) {
                return;
            }
            boolean allowDefinition = Intrinsics.areEqual((Object)calleeQName, (Object)"dataclasses.fields");
            if (this.isNotExpectedDataclass(this.myTypeEvalContext.getType(argument), PyDataclassParameters.Type.STD, allowDefinition, true)) {
                String message = '\'' + calleeQName + "' method should be called on dataclass instances" + (allowDefinition ? " or types" : "");
                this.registerProblem((PsiElement)argument, message);
            }
        }

        private final void processHelperAttrsArgument(PyExpression argument, String calleeQName) {
            if (argument == null) {
                return;
            }
            boolean instance = Intrinsics.areEqual((Object)calleeQName, (Object)"attr.__init__.fields") ^ true && Intrinsics.areEqual((Object)calleeQName, (Object)"attr.__init__.fields_dict") ^ true;
            if (this.isNotExpectedDataclass(this.myTypeEvalContext.getType(argument), PyDataclassParameters.Type.ATTRS, !instance, instance)) {
                String presentableCalleeQName = StringsKt.replaceFirst$default((String)calleeQName, (String)".__init__.", (String)".", (boolean)false, (int)4, null);
                String message = '\'' + presentableCalleeQName + "' method should be called on attrs " + (instance ? "instances" : "types");
                this.registerProblem((PsiElement)argument, message);
            }
        }

        private final boolean isInitVar(PyTargetExpression field) {
            PyType pyType = this.myTypeEvalContext.getType(field);
            if (!(pyType instanceof PyClassType)) {
                pyType = null;
            }
            PyClassType pyClassType = (PyClassType)pyType;
            return Intrinsics.areEqual((Object)(pyClassType != null ? pyClassType.getClassQName() : null), (Object)"dataclasses.InitVar");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNotExpectedDataclass(PyType type, PyDataclassParameters.Type dataclassType, boolean allowDefinition, boolean allowInstance) {
            if (type instanceof PyStructuralType) return false;
            if (PyTypeChecker.isUnknown(type, this.myTypeEvalContext)) {
                return false;
            }
            if (type instanceof PyUnionType) {
                Object element$iv;
                PyType it;
                Collection<PyType> collection = ((PyUnionType)type).getMembers();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"type.members");
                Iterable $receiver$iv = collection;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    return true;
                }
                Iterator iterator = $receiver$iv.iterator();
                do {
                    if (!iterator.hasNext()) return true;
                } while (this.isNotExpectedDataclass(it = (PyType)(element$iv = iterator.next()), dataclassType, allowDefinition, allowInstance));
                return false;
            }
            if (!(type instanceof PyClassType)) return true;
            if (!allowDefinition) {
                if (((PyClassType)type).isDefinition()) return true;
            }
            if (!allowInstance) {
                if (!((PyClassType)type).isDefinition()) return true;
            }
            PyClass pyClass = ((PyClassType)type).getPyClass();
            Intrinsics.checkExpressionValueIsNotNull((Object)pyClass, (String)"type.pyClass");
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
            PyDataclassParameters pyDataclassParameters = PyDataclassesKt.parseDataclassParameters(pyClass, typeEvalContext);
            if ((pyDataclassParameters != null ? pyDataclassParameters.getType() : null) == dataclassType) return false;
            return true;
        }

        public Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
            super(holder, session2);
        }

        public static final /* synthetic */ void access$processDefaultFieldValue(Visitor $this, @NotNull PyTargetExpression field) {
            $this.processDefaultFieldValue(field);
        }

        @Nullable
        public static final /* synthetic */ PyTargetExpression access$processAsInitVar(Visitor $this, @NotNull PyTargetExpression field, @Nullable PyFunction postInit) {
            return $this.processAsInitVar(field, postInit);
        }

        public static final /* synthetic */ void access$processFieldFunctionCall(Visitor $this, @NotNull PyTargetExpression field) {
            $this.processFieldFunctionCall(field);
        }

        public static final /* synthetic */ boolean access$isInitVar(Visitor $this, @NotNull PyTargetExpression field) {
            return $this.isInitVar(field);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/inspections/PyDataclassInspection$Companion;", "", "()V", "ATTRS_HELPERS", "", "", "DATACLASSES_HELPERS", "ORDER_OPERATORS", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

