/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.SimplifyBooleanCheckQuickFix;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyConditionalStatementPart;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySimplifyBooleanCheckInspection
extends PyInspection {
    private static final List<String> COMPARISON_LITERALS = ImmutableList.of((Object)"True", (Object)"False", (Object)"[]");
    public boolean ignoreComparisonToZero = true;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.check.can.be.simplified", new Object[0]);
        if (string == null) {
            PySimplifyBooleanCheckInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PySimplifyBooleanCheckInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PySimplifyBooleanCheckInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2, this.ignoreComparisonToZero);
        if (visitor2 == null) {
            PySimplifyBooleanCheckInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox("Ignore comparison to zero", "ignoreComparisonToZero");
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PyBinaryExpressionVisitor
    extends PyInspectionVisitor {
        private final boolean myIgnoreComparisonToZero;

        public PyBinaryExpressionVisitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session2, boolean ignoreComparisonToZero) {
            if (session2 == null) {
                PyBinaryExpressionVisitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
            this.myIgnoreComparisonToZero = ignoreComparisonToZero;
        }

        @Override
        public void visitPyBinaryExpression(PyBinaryExpression node) {
            super.visitPyBinaryExpression(node);
            PyElementType operator = node.getOperator();
            PyExpression rightExpression = node.getRightExpression();
            if (rightExpression == null || rightExpression instanceof PyBinaryExpression || node.getLeftExpression() instanceof PyBinaryExpression) {
                return;
            }
            if (PyTokenTypes.EQUALITY_OPERATIONS.contains((IElementType)operator) && (PyBinaryExpressionVisitor.operandsEqualTo(node, COMPARISON_LITERALS) || !this.myIgnoreComparisonToZero && PyBinaryExpressionVisitor.operandsEqualTo(node, Collections.singleton("0")))) {
                this.registerProblem(node);
            }
        }

        private static boolean operandsEqualTo(@NotNull PyBinaryExpression expr, @NotNull Collection<String> literals) {
            if (expr == null) {
                PyBinaryExpressionVisitor.$$$reportNull$$$0(1);
            }
            if (literals == null) {
                PyBinaryExpressionVisitor.$$$reportNull$$$0(2);
            }
            String leftExpressionText = expr.getLeftExpression().getText();
            PyExpression rightExpression = expr.getRightExpression();
            String rightExpressionText = rightExpression != null ? rightExpression.getText() : null;
            for (String literal : literals) {
                if (!literal.equals(leftExpressionText) && !literal.equals(rightExpressionText)) continue;
                return true;
            }
            return false;
        }

        private void registerProblem(PyBinaryExpression binaryExpression) {
            this.registerProblem((PsiElement)binaryExpression, PyBundle.message("INSP.expression.can.be.simplified", new Object[0]), new SimplifyBooleanCheckQuickFix(binaryExpression));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literals";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection$PyBinaryExpressionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "operandsEqualTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private final boolean myIgnoreComparisonToZero;

        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session2, boolean ignoreComparisonToZero) {
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
            this.myIgnoreComparisonToZero = ignoreComparisonToZero;
        }

        @Override
        public void visitPyConditionalStatementPart(PyConditionalStatementPart node) {
            super.visitPyConditionalStatementPart(node);
            PyExpression condition = node.getCondition();
            if (condition != null) {
                condition.accept(new PyBinaryExpressionVisitor(this.getHolder(), this.getSession(), this.myIgnoreComparisonToZero));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection$Visitor", "<init>"));
        }
    }
}

