/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.regexp.PythonVerboseRegexpLanguage;
import com.jetbrains.python.lexer.PythonHighlightingLexer;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringLiteralExpressionImpl
extends PyElementImpl
implements PyStringLiteralExpression,
RegExpLanguageHost,
PsiLiteralValue {
    private static final Logger LOG = Logger.getInstance(PyStringLiteralExpressionImpl.class);
    public static final Pattern PATTERN_ESCAPE = Pattern.compile("\\\\(\n|\\\\|'|\"|a|b|f|n|r|t|v|([0-7]{1,3})|x([0-9a-fA-F]{1,2})|N(\\{.*?\\})|u([0-9a-fA-F]{4})|U([0-9a-fA-F]{8}))");
    private static final Map<String, String> escapeMap = PyStringLiteralExpressionImpl.initializeEscapeMap();
    @Nullable
    private volatile String myStringValue;
    @Nullable
    private volatile List<TextRange> myValueTextRanges;
    @Nullable
    private volatile List<Pair<TextRange, String>> myDecodedFragments;
    private final DefaultRegExpPropertiesProvider myPropertiesProvider = DefaultRegExpPropertiesProvider.getInstance();

    @NotNull
    private static Map<String, String> initializeEscapeMap() {
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("\n", "\n");
        map2.put("\\", "\\");
        map2.put("'", "'");
        map2.put("\"", "\"");
        map2.put("a", "\u0001");
        map2.put("b", "\b");
        map2.put("f", "\f");
        map2.put("n", "\n");
        map2.put("r", "\r");
        map2.put("t", "\t");
        map2.put("v", "\u000b");
        HashMap<String, String> hashMap = map2;
        if (hashMap == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    public PyStringLiteralExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyStringLiteralExpression(this);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myStringValue = null;
        this.myValueTextRanges = null;
        this.myDecodedFragments = null;
    }

    @Override
    @NotNull
    public List<TextRange> getStringValueTextRanges() {
        List<Object> result2 = this.myValueTextRanges;
        if (result2 == null) {
            int elStart = this.getTextRange().getStartOffset();
            ArrayList<TextRange> ranges = new ArrayList<TextRange>();
            for (ASTNode node : this.getStringNodes()) {
                TextRange range2 = PyStringLiteralExpressionImpl.getNodeTextRange(node.getText());
                int nodeOffset = node.getStartOffset() - elStart;
                ranges.add(TextRange.from((int)(nodeOffset + range2.getStartOffset()), (int)range2.getLength()));
            }
            this.myValueTextRanges = result2 = Collections.unmodifiableList(ranges);
        }
        List<TextRange> list2 = result2;
        if (list2 == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public static TextRange getNodeTextRange(String text2) {
        LOG.assertTrue(PyStringLiteralUtil.isStringLiteralToken(text2), (Object)("Text of a single string literal node expected: " + text2));
        int startOffset = PyStringLiteralExpressionImpl.getPrefixLength(text2);
        int delimiterLength = 1;
        String afterPrefix = text2.substring(startOffset);
        if (afterPrefix.startsWith("\"\"\"") || afterPrefix.startsWith("'''")) {
            delimiterLength = 3;
        }
        String delimiter = text2.substring(startOffset, startOffset + delimiterLength);
        int endOffset = text2.length();
        if (text2.substring(startOffset += delimiterLength).endsWith(delimiter)) {
            endOffset -= delimiterLength;
        }
        return new TextRange(startOffset, endOffset);
    }

    public static int getPrefixLength(String text2) {
        return PyStringLiteralUtil.getPrefixEndOffset(text2, 0);
    }

    private boolean isUnicodeByDefault() {
        if (!LanguageLevel.forElement(this).isPython2()) {
            return true;
        }
        PsiFile file2 = this.getContainingFile();
        if (file2 instanceof PyFile) {
            PyFile pyFile = (PyFile)file2;
            return pyFile.hasImportFromFuture(FutureFeature.UNICODE_LITERALS);
        }
        return false;
    }

    @Override
    @NotNull
    public List<Pair<TextRange, String>> getDecodedFragments() {
        List<Pair<TextRange, String>> result2 = this.myDecodedFragments;
        if (result2 == null) {
            result2 = new ArrayList<Pair<TextRange, String>>();
            int elementStart = this.getTextRange().getStartOffset();
            boolean unicodeByDefault = this.isUnicodeByDefault();
            for (ASTNode node : this.getStringNodes()) {
                String text2 = node.getText();
                TextRange textRange = PyStringLiteralExpressionImpl.getNodeTextRange(text2);
                int offset = node.getTextRange().getStartOffset() - elementStart + textRange.getStartOffset();
                String encoded = textRange.substring(text2);
                boolean hasRawPrefix = PyStringLiteralUtil.isRawPrefix(PyStringLiteralUtil.getPrefix(text2));
                boolean hasUnicodePrefix = PyStringLiteralUtil.isUnicodePrefix(PyStringLiteralUtil.getPrefix(text2));
                result2.addAll(PyStringLiteralExpressionImpl.getDecodedFragments(encoded, offset, hasRawPrefix, unicodeByDefault || hasUnicodePrefix));
            }
            this.myDecodedFragments = result2;
        }
        List<Pair<TextRange, String>> list2 = result2;
        if (list2 == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    public boolean isDocString() {
        List<ASTNode> stringNodes = this.getStringNodes();
        return stringNodes.size() == 1 && stringNodes.get(0).getElementType() == PyTokenTypes.DOCSTRING;
    }

    @NotNull
    private static List<Pair<TextRange, String>> getDecodedFragments(@NotNull String encoded, int offset, boolean raw, boolean unicode) {
        TextRange range2;
        if (encoded == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        ArrayList<Pair<TextRange, String>> result2 = new ArrayList<Pair<TextRange, String>>();
        Matcher escMatcher = PATTERN_ESCAPE.matcher(encoded);
        int index = 0;
        while (escMatcher.find(index)) {
            String str;
            boolean escapedUnicode;
            if (index < escMatcher.start()) {
                range2 = TextRange.create((int)index, (int)escMatcher.start());
                TextRange offsetRange = range2.shiftRight(offset);
                result2.add(Pair.create((Object)offsetRange, (Object)range2.substring(encoded)));
            }
            String octal = PyStringLiteralExpressionImpl.escapeRegexGroup(escMatcher, EscapeRegexGroup.OCTAL);
            String hex = PyStringLiteralExpressionImpl.escapeRegexGroup(escMatcher, EscapeRegexGroup.HEXADECIMAL);
            String unicode16 = PyStringLiteralExpressionImpl.escapeRegexGroup(escMatcher, EscapeRegexGroup.UNICODE_16BIT);
            String unicode32 = PyStringLiteralExpressionImpl.escapeRegexGroup(escMatcher, EscapeRegexGroup.UNICODE_32BIT);
            String wholeMatch = PyStringLiteralExpressionImpl.escapeRegexGroup(escMatcher, EscapeRegexGroup.WHOLE_MATCH);
            boolean bl = escapedUnicode = raw && unicode || !raw;
            if (!raw && octal != null) {
                str = new String(new char[]{(char)Integer.parseInt(octal, 8)});
            } else if (!raw && hex != null) {
                str = new String(new char[]{(char)Integer.parseInt(hex, 16)});
            } else if (escapedUnicode && unicode16 != null) {
                str = unicode ? new String(new char[]{(char)Integer.parseInt(unicode16, 16)}) : wholeMatch;
            } else if (escapedUnicode && unicode32 != null) {
                String s = wholeMatch;
                if (unicode) {
                    try {
                        s = new String(Character.toChars((int)Long.parseLong(unicode32, 16)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                str = s;
            } else if (raw) {
                str = wholeMatch;
            } else {
                String toReplace = PyStringLiteralExpressionImpl.escapeRegexGroup(escMatcher, EscapeRegexGroup.ESCAPED_SUBSTRING);
                str = escapeMap.get(toReplace);
            }
            if (str != null) {
                TextRange wholeMatchRange = TextRange.create((int)escMatcher.start(), (int)escMatcher.end());
                result2.add((Pair<TextRange, String>)Pair.create((Object)wholeMatchRange.shiftRight(offset), (Object)str));
            }
            index = escMatcher.end();
        }
        range2 = TextRange.create((int)index, (int)encoded.length());
        TextRange offRange = range2.shiftRight(offset);
        result2.add(Pair.create((Object)offRange, (Object)range2.substring(encoded)));
        ArrayList<Pair<TextRange, String>> arrayList = result2;
        if (arrayList == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    private static String escapeRegexGroup(@NotNull Matcher matcher, EscapeRegexGroup group) {
        if (matcher == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        return matcher.group(group.ordinal());
    }

    @Override
    @NotNull
    public List<ASTNode> getStringNodes() {
        List<ASTNode> list2 = Arrays.asList(this.getNode().getChildren(PyTokenTypes.STRING_NODES));
        if (list2 == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public String getStringValue() {
        String result2 = this.myStringValue;
        if (result2 == null) {
            StringBuilder out = new StringBuilder();
            for (Pair<TextRange, String> fragment : this.getDecodedFragments()) {
                out.append((String)fragment.getSecond());
            }
            this.myStringValue = result2 = out.toString();
        }
        String string = result2;
        if (string == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public Object getValue() {
        return this.getStringValue();
    }

    @Override
    public TextRange getStringValueTextRange() {
        List<TextRange> allRanges = this.getStringValueTextRanges();
        if (allRanges.size() == 1) {
            return allRanges.get(0);
        }
        if (allRanges.size() > 1) {
            return allRanges.get(0).union(allRanges.get(allRanges.size() - 1));
        }
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getStringValue();
    }

    public boolean isValidHost() {
        return true;
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        List<ASTNode> nodes;
        if (context == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(8);
        }
        if (key == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(9);
        }
        if ((nodes = this.getStringNodes()).size() > 0) {
            IElementType type;
            String text2 = this.getStringNodes().get(0).getText();
            PyFile file2 = (PyFile)PsiTreeUtil.getParentOfType((PsiElement)this, PyFile.class);
            if (file2 != null && PyTokenTypes.UNICODE_NODES.contains(type = PythonHighlightingLexer.convertStringType(this.getStringNodes().get(0).getElementType(), text2, LanguageLevel.forElement(this), file2.hasImportFromFuture(FutureFeature.UNICODE_LITERALS)))) {
                return PyBuiltinCache.getInstance(this).getUnicodeType(LanguageLevel.forElement(this));
            }
        }
        return PyBuiltinCache.getInstance(this).getBytesType(LanguageLevel.forElement(this));
    }

    @Override
    @NotNull
    public final PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)ReferenceProvidersRegistry.getReferencesFromProviders(this, PsiReferenceService.Hints.NO_HINTS), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (psiReferenceArray == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(10);
        }
        return psiReferenceArray;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return PyStringLiteralExpressionImpl.this.getStringValue();
            }

            @Nullable
            public String getLocationString() {
                String packageForFile = PyElementPresentation.getPackageForFile(PyStringLiteralExpressionImpl.this.getContainingFile());
                return packageForFile != null ? String.format("(%s)", packageForFile) : null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return AllIcons.Nodes.Variable;
            }
        };
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        if (text2 == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(11);
        }
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text2);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        StringLiteralTextEscaper stringLiteralTextEscaper = new StringLiteralTextEscaper(this);
        if (stringLiteralTextEscaper == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(12);
        }
        return stringLiteralTextEscaper;
    }

    @Override
    public int valueOffsetToTextOffset(int valueOffset) {
        return this.createLiteralTextEscaper().getOffsetInHost(valueOffset, this.getStringValueTextRange());
    }

    @Override
    public boolean characterNeedsEscaping(char c) {
        if (c == '#') {
            return this.isVerboseInjection();
        }
        return c == ']' || c == '}' || c == '\"' || c == '\'';
    }

    private boolean isVerboseInjection() {
        List files2 = InjectedLanguageManager.getInstance((Project)this.getProject()).getInjectedPsiFiles((PsiElement)this);
        if (files2 != null) {
            for (Pair file2 : files2) {
                Language language = ((PsiElement)file2.getFirst()).getLanguage();
                if (language != PythonVerboseRegexpLanguage.INSTANCE) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsPerl5EmbeddedComments() {
        return true;
    }

    @Override
    public boolean supportsPossessiveQuantifiers() {
        return false;
    }

    @Override
    public boolean supportsPythonConditionalRefs() {
        return true;
    }

    @Override
    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        return group.getType() == RegExpGroup.Type.PYTHON_NAMED_GROUP;
    }

    @Override
    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        return ref.isPythonNamedGroupRef();
    }

    @Override
    @NotNull
    public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        EnumSet<RegExpGroup.Type> enumSet = EnumSet.of(RegExpGroup.Type.PYTHON_NAMED_GROUP);
        if (enumSet == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(13);
        }
        return enumSet;
    }

    @Override
    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return false;
    }

    @Override
    public RegExpLanguageHost.Lookbehind supportsLookbehind(@NotNull RegExpGroup lookbehindGroup) {
        if (lookbehindGroup == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(14);
        }
        return RegExpLanguageHost.Lookbehind.FIXED_LENGTH_ALTERNATION;
    }

    @Override
    public Long getQuantifierValue(@NotNull RegExpNumber number) {
        if (number == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(15);
        }
        try {
            long result2 = Long.parseLong(number.getText());
            if (result2 >= 0xFFFFFFFFL) {
                return null;
            }
            return result2;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(16);
        }
        return this.myPropertiesProvider.isValidCategory(category);
    }

    @Override
    @NotNull
    public String[][] getAllKnownProperties() {
        String[][] stringArray = this.myPropertiesProvider.getAllKnownProperties();
        if (stringArray == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(17);
        }
        return stringArray;
    }

    @Override
    @Nullable
    public String getPropertyDescription(@Nullable String name) {
        return this.myPropertiesProvider.getPropertyDescription(name);
    }

    @Override
    @NotNull
    public String[][] getKnownCharacterClasses() {
        String[][] stringArray = this.myPropertiesProvider.getKnownCharacterClasses();
        if (stringArray == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(18);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoded";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookbehindGroup";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeEscapeMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValueTextRanges";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecodedFragments";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringNodes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralTextEscaper";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedNamedGroupTypes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKnownProperties";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownCharacterClasses";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDecodedFragments";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "escapeRegexGroup";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "supportsLookbehind";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getQuantifierValue";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isValidCategory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StringLiteralTextEscaper
    extends LiteralTextEscaper<PyStringLiteralExpression> {
        private final PyStringLiteralExpressionImpl myHost;

        protected StringLiteralTextEscaper(@NotNull PyStringLiteralExpressionImpl host) {
            if (host == null) {
                StringLiteralTextEscaper.$$$reportNull$$$0(0);
            }
            super((PsiLanguageInjectionHost)host);
            this.myHost = host;
        }

        public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
            if (rangeInsideHost == null) {
                StringLiteralTextEscaper.$$$reportNull$$$0(1);
            }
            if (outChars == null) {
                StringLiteralTextEscaper.$$$reportNull$$$0(2);
            }
            for (Pair<TextRange, String> fragment : this.myHost.getDecodedFragments()) {
                String intersectedValue;
                TextRange encodedTextRange = (TextRange)fragment.getFirst();
                TextRange intersection = encodedTextRange.intersection(rangeInsideHost);
                if (intersection == null || intersection.isEmpty()) continue;
                String value = (String)fragment.getSecond();
                if (value.codePointCount(0, value.length()) == 1 || value.length() == intersection.getLength()) {
                    intersectedValue = value;
                } else {
                    int start = Math.max(0, rangeInsideHost.getStartOffset() - encodedTextRange.getStartOffset());
                    int end = Math.min(value.length(), start + intersection.getLength());
                    intersectedValue = value.substring(start, end);
                }
                outChars.append(intersectedValue);
            }
            return true;
        }

        public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
            if (rangeInsideHost == null) {
                StringLiteralTextEscaper.$$$reportNull$$$0(3);
            }
            int offset = 0;
            int endOffset = -1;
            for (Pair<TextRange, String> fragment : this.myHost.getDecodedFragments()) {
                TextRange encodedTextRange = (TextRange)fragment.getFirst();
                TextRange intersection = encodedTextRange.intersection(rangeInsideHost);
                if (intersection == null || intersection.isEmpty()) continue;
                String value = (String)fragment.getSecond();
                int valueLength = value.length();
                int intersectionLength = intersection.getLength();
                if (valueLength == 0) {
                    return -1;
                }
                if (value.codePointCount(0, valueLength) == 1) {
                    if (offset == offsetInDecoded) {
                        return intersection.getStartOffset();
                    }
                    offset += valueLength;
                } else {
                    if (offset + intersectionLength >= offsetInDecoded) {
                        int delta = offsetInDecoded - offset;
                        return intersection.getStartOffset() + delta;
                    }
                    offset += intersectionLength;
                }
                endOffset = intersection.getEndOffset();
            }
            if (offset == offsetInDecoded) {
                return endOffset;
            }
            return -1;
        }

        public boolean isOneLine() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInsideHost";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outChars";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl$StringLiteralTextEscaper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "decode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOffsetInHost";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum EscapeRegexGroup {
        WHOLE_MATCH,
        ESCAPED_SUBSTRING,
        OCTAL,
        HEXADECIMAL,
        UNICODE_NAMED,
        UNICODE_16BIT,
        UNICODE_32BIT;

    }
}

