/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.rename.naming.NameSuggester;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyContainingFileRenamerFactory
implements AutomaticRenamerFactory {
    @Override
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            PyContainingFileRenamerFactory.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PyClass)) {
            return false;
        }
        ScopeOwner scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)element, ScopeOwner.class);
        if (scopeOwner instanceof PyFile) {
            String className = ((PyClass)element).getName();
            String fileName = FileUtil.getNameWithoutExtension((String)scopeOwner.getName());
            return fileName.equalsIgnoreCase(className);
        }
        return false;
    }

    @Override
    public String getOptionName() {
        return "Rename containing file";
    }

    @Override
    public boolean isEnabled() {
        return PyCodeInsightSettings.getInstance().RENAME_CLASS_CONTAINING_FILE;
    }

    @Override
    public void setEnabled(boolean enabled) {
        PyCodeInsightSettings.getInstance().RENAME_CLASS_CONTAINING_FILE = enabled;
    }

    @Override
    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        PyContainingFileRenamer pyContainingFileRenamer = new PyContainingFileRenamer((PyClass)element, newName);
        if (pyContainingFileRenamer == null) {
            PyContainingFileRenamerFactory.$$$reportNull$$$0(1);
        }
        return pyContainingFileRenamer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/rename/PyContainingFileRenamerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/rename/PyContainingFileRenamerFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PyContainingFileRenamer
    extends AutomaticRenamer {
        private final PyClass myClass;

        public PyContainingFileRenamer(PyClass element, String newName) {
            this.myClass = element;
            this.myElements.add(element.getContainingFile());
            this.suggestAllNames(element.getName(), newName);
        }

        @Override
        public String getDialogTitle() {
            return "Rename Containing File";
        }

        @Override
        public String getDialogDescription() {
            return "Rename containing file with the following name to: ";
        }

        @Override
        public String entityName() {
            return "Containing File";
        }

        @Override
        protected String nameToCanonicalName(@NonNls String name, PsiNamedElement element) {
            return FileUtil.getNameWithoutExtension((String)name);
        }

        @Override
        protected String canonicalNameToName(@NonNls String canonicalName, PsiNamedElement element) {
            return canonicalName + "." + FileUtilRt.getExtension((String)this.myClass.getContainingFile().getName());
        }

        @Override
        public boolean isSelectedByDefault() {
            return true;
        }

        @Override
        protected String suggestNameForElement(PsiNamedElement element, NameSuggester suggester, String newClassName, String oldClassName) {
            if (element instanceof PyFile && element.getName().equals(oldClassName.toLowerCase() + ".py")) {
                return newClassName.toLowerCase() + ".py";
            }
            return super.suggestNameForElement(element, suggester, newClassName, oldClassName);
        }
    }
}

