/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Output;
import com.intellij.execution.OutputListener;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NotNullFunction;
import com.jetbrains.python.HelperPackage;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.run.PyRemoteProcessStarter;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonTask {
    private static final long TIME_TO_WAIT_PROCESS_STOP = 2000L;
    private static final int TIMEOUT_TO_WAIT_FOR_TASK = 30000;
    protected final Module myModule;
    private final Sdk mySdk;
    private String myWorkingDirectory;
    private String myRunnerScript;
    private HelperPackage myHelper = null;
    private List<String> myParameters = new ArrayList<String>();
    private final String myRunTabTitle;
    private String myHelpId;
    private Runnable myAfterCompletion;

    public PythonTask(Module module2, String runTabTitle) throws ExecutionException {
        this(module2, runTabTitle, PythonSdkType.findPythonSdk(module2));
    }

    @NotNull
    public static PythonTask create(@NotNull Module module2, @NotNull String runTabTitle, @NotNull Sdk sdk) {
        PythonTask pythonTask;
        block5: {
            if (module2 == null) {
                PythonTask.$$$reportNull$$$0(0);
            }
            if (runTabTitle == null) {
                PythonTask.$$$reportNull$$$0(1);
            }
            if (sdk == null) {
                PythonTask.$$$reportNull$$$0(2);
            }
            try {
                pythonTask = new PythonTask(module2, runTabTitle, sdk);
                if (pythonTask != null) break block5;
            }
            catch (ExecutionException ignored) {
                throw new AssertionError((Object)"Exception thrown file should not be");
            }
            PythonTask.$$$reportNull$$$0(3);
        }
        return pythonTask;
    }

    public PythonTask(Module module2, String runTabTitle, @Nullable Sdk sdk) throws ExecutionException {
        this.myModule = module2;
        this.myRunTabTitle = runTabTitle;
        this.mySdk = sdk;
        if (this.mySdk == null) {
            throw new ExecutionException("Cannot find Python interpreter for selected module");
        }
    }

    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    public void setRunnerScript(String script) {
        this.myRunnerScript = script;
    }

    public void setHelper(HelperPackage helper) {
        this.myHelper = helper;
    }

    public void setParameters(List<String> parameters2) {
        this.myParameters = parameters2;
    }

    public void setHelpId(String helpId) {
        this.myHelpId = helpId;
    }

    public void setAfterCompletion(Runnable afterCompletion) {
        this.myAfterCompletion = afterCompletion;
    }

    public ProcessHandler createProcess(@Nullable Map<String, String> env) throws ExecutionException {
        ProcessHandler handler2;
        GeneralCommandLine commandLine = this.createCommandLine();
        if (env != null) {
            commandLine.getEnvironment().putAll(env);
        }
        PydevConsoleRunner.setCorrectStdOutEncoding(commandLine, this.myModule.getProject());
        if (PySdkUtil.isRemote(this.mySdk)) {
            assert (this.mySdk != null);
            handler2 = new PyRemoteProcessStarter().startRemoteProcess(this.mySdk, commandLine, this.myModule.getProject(), null);
        } else {
            EncodingEnvironmentUtil.setLocaleEnvironmentIfMac((GeneralCommandLine)commandLine);
            handler2 = PythonProcessRunner.createProcessHandlingCtrlC(commandLine);
            ProcessTerminatedListener.attach((ProcessHandler)handler2);
        }
        return handler2;
    }

    public void run(@Nullable ConsoleView consoleView) throws ExecutionException {
        this.run(this.createCommandLine().getEnvironment(), consoleView);
    }

    public GeneralCommandLine createCommandLine() {
        String homePath;
        GeneralCommandLine cmd = new GeneralCommandLine();
        if (this.myWorkingDirectory != null) {
            cmd.setWorkDirectory(this.myWorkingDirectory);
        }
        if ((homePath = this.mySdk.getHomePath()) != null) {
            homePath = FileUtil.toSystemDependentName((String)homePath);
        }
        PythonCommandLineState.createStandardGroups(cmd);
        ParamsGroup scriptParams = cmd.getParametersList().getParamsGroup("Script");
        assert (scriptParams != null);
        Map env = cmd.getEnvironment();
        if (!SystemInfo.isWindows && !PySdkUtil.isRemote(this.mySdk)) {
            StringBuilder paramString;
            cmd.setExePath("bash");
            ParamsGroup bashParams = cmd.getParametersList().addParamsGroupAt(0, "Bash");
            bashParams.addParameter("-cl");
            NotNullFunction escaperFunction = StringUtil.escaper((boolean)false, (String)"|>$\"'& ");
            if (this.myHelper != null) {
                paramString = new StringBuilder((String)escaperFunction.fun((Object)homePath) + " " + (String)escaperFunction.fun((Object)this.myHelper.asParamString()));
                this.myHelper.addToPythonPath(cmd.getEnvironment());
            } else {
                paramString = new StringBuilder((String)escaperFunction.fun((Object)homePath) + " " + (String)escaperFunction.fun((Object)this.myRunnerScript));
            }
            for (String p : this.myParameters) {
                paramString.append(" ").append(p);
            }
            bashParams.addParameter(paramString.toString());
        } else {
            cmd.setExePath(homePath);
            if (this.myHelper != null) {
                this.myHelper.addToGroup(scriptParams, cmd);
            } else {
                scriptParams.addParameter(this.myRunnerScript);
            }
            scriptParams.addParameters(this.myParameters.stream().filter(o -> o != null).collect(Collectors.toList()));
        }
        PythonEnvUtil.setPythonUnbuffered(env);
        if (homePath != null) {
            PythonEnvUtil.resetHomePathChanges(homePath, env);
        }
        List<String> pythonPath = this.setupPythonPath();
        PythonCommandLineState.initPythonPath(cmd, true, pythonPath, homePath);
        BuildoutFacet facet = BuildoutFacet.getInstance(this.myModule);
        if (facet != null) {
            facet.patchCommandLineForBuildout(cmd);
        }
        return cmd;
    }

    protected List<String> setupPythonPath() {
        return this.setupPythonPath(true, true);
    }

    protected List<String> setupPythonPath(boolean addContent, boolean addSource) {
        ArrayList pythonPath = Lists.newArrayList(PythonCommandLineState.getAddedPaths(this.mySdk));
        pythonPath.addAll(PythonCommandLineState.collectPythonPath(this.myModule, addContent, addSource));
        return pythonPath;
    }

    public void run(@Nullable Map<String, String> env, @Nullable ConsoleView consoleView) throws ExecutionException {
        ProcessHandler process2 = this.createProcess(env);
        this.stopProcessWhenAppClosed(process2);
        Project project = this.myModule.getProject();
        new RunContentExecutor(project, process2).withFilter(new PythonTracebackFilter(project)).withConsole(consoleView).withTitle(this.myRunTabTitle).withRerun(() -> {
            try {
                process2.destroyProcess();
                if (process2.waitFor(2000L)) {
                    this.run(env, consoleView);
                } else {
                    Messages.showErrorDialog((String)PyBundle.message("unable.to.stop", new Object[0]), (String)this.myRunTabTitle);
                }
            }
            catch (ExecutionException e) {
                Messages.showErrorDialog((String)e.getMessage(), (String)this.myRunTabTitle);
            }
        }).withStop(() -> process2.destroyProcess(), (Computable<Boolean>)((Computable)() -> !process2.isProcessTerminated())).withAfterCompletion(this.myAfterCompletion).withHelpId(this.myHelpId).run();
    }

    private void stopProcessWhenAppClosed(final @NotNull ProcessHandler process2) {
        if (process2 == null) {
            PythonTask.$$$reportNull$$$0(4);
        }
        ApplicationAdapter processStopper = new ApplicationAdapter(){

            public void applicationExiting() {
                super.applicationExiting();
                process2.destroyProcess();
            }
        };
        final Application app = ApplicationManager.getApplication();
        process2.addProcessListener((ProcessListener)new ProcessAdapter((ApplicationListener)processStopper){
            final /* synthetic */ ApplicationListener val$processStopper;
            {
                this.val$processStopper = applicationListener;
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.processTerminated(event);
                app.removeApplicationListener(this.val$processStopper);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/run/PythonTask$2", "processTerminated"));
            }
        }, (Disposable)this.myModule);
        app.addApplicationListener((ApplicationListener)processStopper);
    }

    @NotNull
    public final String runNoConsole() throws ExecutionException {
        ProcessHandler process2 = this.createProcess(new HashMap<String, String>());
        OutputListener listener2 = new OutputListener();
        process2.addProcessListener((ProcessListener)listener2);
        process2.startNotify();
        process2.waitFor(30000L);
        Output output = listener2.getOutput();
        int exitCode = output.getExitCode();
        if (exitCode == 0) {
            String string = output.getStdout();
            if (string == null) {
                PythonTask.$$$reportNull$$$0(5);
            }
            return string;
        }
        throw new ExecutionException(String.format("Error on python side. Exit code: %s, err: %s out: %s", exitCode, output.getStderr(), output.getStdout()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runTabTitle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/PythonTask";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/PythonTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "runNoConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "stopProcessWhenAppClosed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

