/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.suggestionList;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.PlatformIcons;
import com.jetbrains.python.suggestionList.Suggestion;
import com.jetbrains.python.suggestionList.SuggestionsBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuggestionList {
    @Nullable
    private final JBPopupListener myListener;
    @Nullable
    private JBPopup myListPopUp;
    private final DefaultListModel myListModel;
    private final JList myList;

    public SuggestionList() {
        this.myListModel = new DefaultListModel();
        this.myList = new JList(this.myListModel);
        this.myListener = null;
    }

    public SuggestionList(@NotNull JBPopupListener listener2) {
        if (listener2 == null) {
            SuggestionList.$$$reportNull$$$0(0);
        }
        this.myListModel = new DefaultListModel();
        this.myList = new JList(this.myListModel);
        this.myListener = listener2;
    }

    public void showSuggestions(@NotNull SuggestionsBuilder values, @NotNull RelativePoint displayPoint, @Nullable String elementToSelect) {
        if (values == null) {
            SuggestionList.$$$reportNull$$$0(1);
        }
        if (displayPoint == null) {
            SuggestionList.$$$reportNull$$$0(2);
        }
        this.showSuggestions(values.getList(), displayPoint, elementToSelect);
    }

    public void showSuggestions(@NotNull List<List<Suggestion>> values, @NotNull RelativePoint displayPoint, @Nullable String elementToSelect) {
        if (values == null) {
            SuggestionList.$$$reportNull$$$0(3);
        }
        if (displayPoint == null) {
            SuggestionList.$$$reportNull$$$0(4);
        }
        this.close();
        this.myList.setCellRenderer(new MyCellRenderer());
        this.myListModel.clear();
        if (values.isEmpty()) {
            return;
        }
        int record = 0;
        for (int groupId = 0; groupId < values.size(); ++groupId) {
            List<Suggestion> suggestions = values.get(groupId);
            for (int suggestionId = 0; suggestionId < suggestions.size(); ++suggestionId) {
                Suggestion suggestion = suggestions.get(suggestionId);
                this.myListModel.addElement(new SuggestionListElement(groupId % 2 == 0, suggestion));
                if (suggestion.getText().equals(elementToSelect)) {
                    this.myList.setSelectedIndex(record);
                }
                ++record;
            }
        }
        if (this.myList.getSelectedIndex() == -1 && !this.myListModel.isEmpty()) {
            this.myList.setSelectedIndex(0);
        }
        JScrollPane content = new JScrollPane(this.myList, 20, 32);
        this.myListPopUp = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)content, null).createPopup();
        if (this.myListener != null) {
            this.myListPopUp.addListener(this.myListener);
        }
        this.myListPopUp.show(displayPoint);
        this.myList.ensureIndexIsVisible(this.myList.getSelectedIndex());
    }

    public void close() {
        if (this.myListPopUp != null) {
            this.myListPopUp.cancel();
        }
    }

    public void moveSelection(boolean directionUp) {
        if (this.myListModel.isEmpty()) {
            return;
        }
        int newIndex = this.myList.getSelectedIndex() + (directionUp ? -1 : 1);
        if (newIndex < 0) {
            newIndex = 0;
        }
        if (newIndex >= this.myListModel.size()) {
            newIndex = this.myListModel.size() - 1;
        }
        this.myList.setSelectedIndex(newIndex);
        this.myList.scrollRectToVisible(this.myList.getCellBounds(newIndex, newIndex));
    }

    @Nullable
    public String getValue() {
        if (this.myListPopUp == null || !this.myListPopUp.isVisible()) {
            return null;
        }
        Object value = this.myList.getSelectedValue();
        return value == null ? null : SuggestionList.getElement(value).mySuggestion.getText();
    }

    public final synchronized boolean isClosed() {
        return this.myListPopUp == null || this.myListPopUp.isDisposed();
    }

    @NotNull
    private static SuggestionListElement getElement(Object value) {
        assert (value instanceof SuggestionListElement) : "Value is not valid element: " + value;
        SuggestionListElement suggestionListElement = (SuggestionListElement)value;
        if (suggestionListElement == null) {
            SuggestionList.$$$reportNull$$$0(5);
        }
        return suggestionListElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayPoint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/suggestionList/SuggestionList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/suggestionList/SuggestionList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showSuggestions";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCellRenderer
    extends DefaultListCellRenderer {
        @NotNull
        private static final Color ODD_GROUP_SELECTED_BACKGROUND_COLOR = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.SELECTED_TEARLINE_COLOR);
        @NotNull
        private static final Color ODD_GROUP_BACKGROUND_COLOR = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.TEARLINE_COLOR);

        private MyCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SuggestionListElement element = SuggestionList.getElement(value);
            Component component = super.getListCellRendererComponent((JList<?>)list2, element.mySuggestion.getText(), index, isSelected, cellHasFocus);
            if (element.myOddGroup) {
                component.setBackground(isSelected ? ODD_GROUP_SELECTED_BACKGROUND_COLOR : ODD_GROUP_BACKGROUND_COLOR);
                Font oldFont = component.getFont();
                component.setFont(new Font(oldFont.getName(), 2, oldFont.getSize()));
            }
            if (!(component instanceof JLabel)) {
                return component;
            }
            JLabel label2 = (JLabel)component;
            if (element.mySuggestion.isStrong()) {
                label2.setIcon(PlatformIcons.FOLDER_ICON);
            }
            return component;
        }
    }

    private static final class SuggestionListElement {
        private final boolean myOddGroup;
        @NotNull
        private final Suggestion mySuggestion;

        private SuggestionListElement(boolean oddGroup, @NotNull Suggestion suggestion) {
            if (suggestion == null) {
                SuggestionListElement.$$$reportNull$$$0(0);
            }
            this.myOddGroup = oddGroup;
            this.mySuggestion = suggestion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestion", "com/jetbrains/python/suggestionList/SuggestionList$SuggestionListElement", "<init>"));
        }
    }
}

