/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import com.jetbrains.python.validation.PyAnnotator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StringLiteralQuotesAnnotator
extends PyAnnotator {
    private static final String TRIPLE_QUOTES = "\"\"\"";
    private static final String TRIPLE_APOS = "'''";

    @Override
    public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
        int index;
        ASTNode stringNode;
        String nodeText;
        String unprefixed;
        boolean foundError;
        List<ASTNode> stringNodes = node.getStringNodes();
        Iterator<ASTNode> iterator = stringNodes.iterator();
        while (iterator.hasNext() && !(foundError = StringUtil.startsWith((CharSequence)(unprefixed = (nodeText = PyPsiUtils.getElementTextWithoutHostEscaping((stringNode = iterator.next()).getPsi())).substring(index = PyStringLiteralExpressionImpl.getPrefixLength(nodeText))), (CharSequence)TRIPLE_QUOTES) ? this.checkTripleQuotedString(stringNode, unprefixed, TRIPLE_QUOTES) : (StringUtil.startsWith((CharSequence)unprefixed, (CharSequence)TRIPLE_APOS) ? this.checkTripleQuotedString(stringNode, unprefixed, TRIPLE_APOS) : this.checkQuotedString(stringNode, unprefixed)))) {
        }
    }

    private boolean checkQuotedString(@NotNull ASTNode stringNode, @NotNull String nodeText) {
        if (stringNode == null) {
            StringLiteralQuotesAnnotator.$$$reportNull$$$0(0);
        }
        if (nodeText == null) {
            StringLiteralQuotesAnnotator.$$$reportNull$$$0(1);
        }
        char firstQuote = nodeText.charAt(0);
        char lastChar = nodeText.charAt(nodeText.length() - 1);
        int precedingBackslashCount = 0;
        for (int i = nodeText.length() - 2; i >= 0 && nodeText.charAt(i) == '\\'; --i) {
            ++precedingBackslashCount;
        }
        if (nodeText.length() == 1 || lastChar != firstQuote || precedingBackslashCount % 2 != 0) {
            this.getHolder().createErrorAnnotation(stringNode, PyBundle.message("ANN.missing.closing.quote", Character.valueOf(firstQuote)));
            return true;
        }
        return false;
    }

    private boolean checkTripleQuotedString(@NotNull ASTNode stringNode, @NotNull String text2, @NotNull String quotes) {
        if (stringNode == null) {
            StringLiteralQuotesAnnotator.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            StringLiteralQuotesAnnotator.$$$reportNull$$$0(3);
        }
        if (quotes == null) {
            StringLiteralQuotesAnnotator.$$$reportNull$$$0(4);
        }
        if (text2.length() < 6 || !text2.endsWith(quotes)) {
            int startOffset = StringUtil.trimTrailing((String)stringNode.getText()).lastIndexOf(10);
            startOffset = startOffset < 0 ? stringNode.getTextRange().getStartOffset() : stringNode.getTextRange().getStartOffset() + startOffset + 1;
            TextRange highlightRange = new TextRange(startOffset, stringNode.getTextRange().getEndOffset());
            this.getHolder().createErrorAnnotation(highlightRange, PyBundle.message("ANN.missing.closing.triple.quotes", new Object[0]));
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotes";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/StringLiteralQuotesAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkQuotedString";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTripleQuotedString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

