/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.sun.jna.TypeMapper;
import com.sun.jna.platform.FileUtils;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jpountz.lz4.LZ4Factory;
import org.apache.log4j.Appender;
import org.apache.oro.text.regex.PatternMatcher;
import org.intellij.lang.annotations.Flow;
import org.jdom.Document;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathManager {
    public static final String PROPERTIES_FILE = "idea.properties.file";
    public static final String PROPERTIES_FILE_NAME = "idea.properties";
    public static final String PROPERTY_HOME_PATH = "idea.home.path";
    public static final String PROPERTY_CONFIG_PATH = "idea.config.path";
    public static final String PROPERTY_SYSTEM_PATH = "idea.system.path";
    public static final String PROPERTY_SCRATCH_PATH = "idea.scratch.path";
    public static final String PROPERTY_PLUGINS_PATH = "idea.plugins.path";
    public static final String PROPERTY_LOG_PATH = "idea.log.path";
    public static final String PROPERTY_PATHS_SELECTOR = "idea.paths.selector";
    public static final String DEFAULT_OPTIONS_FILE_NAME = "other";
    private static final String PROPERTY_HOME = "idea.home";
    private static final String LIB_FOLDER = "lib";
    private static final String PLUGINS_FOLDER = "plugins";
    private static final String BIN_FOLDER = "bin";
    private static final String LOG_DIRECTORY = "log";
    private static final String CONFIG_FOLDER = "config";
    private static final String OPTIONS_FOLDER = "options";
    private static final String SYSTEM_FOLDER = "system";
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static final Pattern PROPERTY_REF = Pattern.compile("\\$\\{(.+?)}");
    private static String ourHomePath;
    private static String[] ourBinDirectories;
    private static String ourConfigPath;
    private static String ourSystemPath;
    private static String ourScratchPath;
    private static String ourPluginsPath;
    private static String ourLogPath;

    @NotNull
    public static String getHomePath() {
        String string = PathManager.getHomePath(true);
        if (string == null) {
            PathManager.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        if (ourHomePath != null) {
            return ourHomePath;
        }
        String fromProperty = System.getProperty(PROPERTY_HOME_PATH, System.getProperty(PROPERTY_HOME));
        if (fromProperty != null) {
            ourHomePath = PathManager.getAbsolutePath(fromProperty);
            if (!new File(ourHomePath).isDirectory()) {
                throw new RuntimeException("Invalid home path '" + ourHomePath + "'");
            }
        } else if (insideIde && (ourHomePath = PathManager.getHomePathFor(PathManager.class)) == null) {
            String advice = SystemInfo.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
            throw new RuntimeException("Could not find installation home path. Please " + advice);
        }
        if (ourHomePath != null && SystemInfo.isWindows) {
            ourHomePath = PathManager.canonicalPath(ourHomePath);
        }
        ourBinDirectories = ourHomePath != null ? PathManager.getBinDirectories(new File(ourHomePath)) : ArrayUtil.EMPTY_STRING_ARRAY;
        return ourHomePath;
    }

    public static boolean isUnderHomeDirectory(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(1);
        }
        return FileUtil.isAncestor(PathManager.canonicalPath(PathManager.getHomePath()), PathManager.canonicalPath(path), true);
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class aClass) {
        String rootPath;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(2);
        }
        if ((rootPath = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class")) == null) {
            return null;
        }
        File root = new File(rootPath).getAbsoluteFile();
        while ((root = root.getParentFile()) != null && !PathManager.isIdeaHome(root)) {
        }
        return root != null ? root.getPath() : null;
    }

    private static boolean isIdeaHome(File root) {
        for (String binDir : PathManager.getBinDirectories(root)) {
            if (!new File(binDir, PROPERTIES_FILE_NAME).isFile()) continue;
            return true;
        }
        return false;
    }

    public static boolean isSnap() {
        return SystemInfo.isLinux && PathManager.getHomePath().startsWith("/snap/");
    }

    private static String[] getBinDirectories(File root) {
        List<String> binDirs = ContainerUtil.newSmartList();
        String[] subDirs = new String[]{BIN_FOLDER, "community/bin", "ultimate/community/bin"};
        String osSuffix = SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "mac" : "linux");
        for (String subDir : subDirs) {
            File dir = new File(root, subDir);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
            dir = new File(dir, osSuffix);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
        }
        return ArrayUtil.toStringArray(binDirs);
    }

    @NotNull
    public static String getBinPath() {
        String string = PathManager.getHomePath() + File.separator + BIN_FOLDER;
        if (string == null) {
            PathManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static File findBinFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(4);
        }
        PathManager.getHomePath();
        for (String binDir : ourBinDirectories) {
            File file = new File(binDir, fileName);
            if (!file.isFile()) continue;
            return file;
        }
        return null;
    }

    @NotNull
    public static File findBinFileWithException(@NotNull String fileName) throws FileNotFoundException {
        File file;
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(5);
        }
        if ((file = PathManager.findBinFile(fileName)) != null) {
            File file2 = file;
            if (file2 == null) {
                PathManager.$$$reportNull$$$0(6);
            }
            return file2;
        }
        String paths = StringUtil.join(ourBinDirectories, "\n");
        throw new FileNotFoundException(String.format("'%s' not found in directories:\n%s", fileName, paths));
    }

    @NotNull
    public static String getLibPath() {
        String string = PathManager.getHomePath() + File.separator + LIB_FOLDER;
        if (string == null) {
            PathManager.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        String string = PathManager.getHomePath() + File.separatorChar + PLUGINS_FOLDER;
        if (string == null) {
            PathManager.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public static String getPathsSelector() {
        return PATHS_SELECTOR;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string = ourConfigPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(9);
            }
            return string;
        }
        ourConfigPath = System.getProperty(PROPERTY_CONFIG_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_CONFIG_PATH))) : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + File.separator + CONFIG_FOLDER);
        String string = ourConfigPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String getScratchPath() {
        if (ourScratchPath != null) {
            String string = ourScratchPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(11);
            }
            return string;
        }
        ourScratchPath = System.getProperty(PROPERTY_SCRATCH_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_SCRATCH_PATH))) : PathManager.getConfigPath();
        String string = ourScratchPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(13);
        }
        String string = PathManager.platformPath(selector, "Library/Preferences", CONFIG_FOLDER);
        if (string == null) {
            PathManager.$$$reportNull$$$0(14);
        }
        return string;
    }

    public static void ensureConfigFolderExists() {
        FileUtil.createDirectory(new File(PathManager.getConfigPath()));
    }

    @NotNull
    public static String getOptionsPath() {
        String string = PathManager.getConfigPath() + File.separator + OPTIONS_FOLDER;
        if (string == null) {
            PathManager.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static File getOptionsFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(16);
        }
        File file = new File(PathManager.getOptionsPath(), fileName + ".xml");
        if (file == null) {
            PathManager.$$$reportNull$$$0(17);
        }
        return file;
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginsPath != null) {
            String string = ourPluginsPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(18);
            }
            return string;
        }
        ourPluginsPath = System.getProperty(PROPERTY_PLUGINS_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_PLUGINS_PATH))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? PathManager.platformPath(PATHS_SELECTOR, "Library/Application Support", "") : PathManager.getConfigPath() + File.separatorChar + PLUGINS_FOLDER);
        String string = ourPluginsPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static String getDefaultPluginPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(20);
        }
        if (SystemInfo.isMac) {
            String string = PathManager.platformPath(selector, "Library/Application Support", "");
            if (string == null) {
                PathManager.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = PathManager.getDefaultConfigPathFor(selector) + File.separatorChar + PLUGINS_FOLDER;
        if (string == null) {
            PathManager.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    public static String getCustomOptionsDirectory() {
        return PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : null;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string = ourSystemPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(23);
            }
            return string;
        }
        ourSystemPath = System.getProperty(PROPERTY_SYSTEM_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_SYSTEM_PATH))) : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + File.separator + SYSTEM_FOLDER);
        FileUtil.createDirectory(new File(ourSystemPath));
        String string = ourSystemPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(25);
        }
        String string = PathManager.platformPath(selector, "Library/Caches", SYSTEM_FOLDER);
        if (string == null) {
            PathManager.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String getTempPath() {
        String string = PathManager.getSystemPath() + File.separator + "tmp";
        if (string == null) {
            PathManager.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static File getIndexRoot() {
        File indexRoot = new File(System.getProperty("index_root_path", PathManager.getSystemPath() + "/index"));
        FileUtil.createDirectory(indexRoot);
        File file = indexRoot;
        if (file == null) {
            PathManager.$$$reportNull$$$0(28);
        }
        return file;
    }

    @NotNull
    public static String getLogPath() {
        if (ourLogPath != null) {
            String string = ourLogPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(29);
            }
            return string;
        }
        ourLogPath = System.getProperty(PROPERTY_LOG_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_LOG_PATH))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? SystemProperties.getUserHome() + File.separator + "Library/Logs" + File.separator + PATHS_SELECTOR : PathManager.getSystemPath() + File.separatorChar + LOG_DIRECTORY);
        String string = ourLogPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public static String getPluginTempPath() {
        String string = PathManager.getSystemPath() + File.separator + PLUGINS_FOLDER;
        if (string == null) {
            PathManager.$$$reportNull$$$0(31);
        }
        return string;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class context, String path) {
        URL url;
        if (context == null) {
            PathManager.$$$reportNull$$$0(32);
        }
        if ((url = context.getResource(path)) == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path) : null;
    }

    @Nullable
    public static String getResourceRoot(@NotNull ClassLoader cl, String resourcePath) {
        URL url;
        if (cl == null) {
            PathManager.$$$reportNull$$$0(33);
        }
        return (url = cl.getResource(resourcePath)) != null ? PathManager.extractRoot(url, resourcePath) : null;
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        if (!StringUtil.startsWithChar(resourcePath, '/') && !StringUtil.startsWithChar(resourcePath, '\\')) {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path = URLUtil.urlToFile(resourceURL).getPath();
            String testPath = path.replace('\\', '/');
            if (StringUtil.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            Pair<String, String> paths = URLUtil.splitJarUrl(resourceURL.getFile());
            if (paths != null && paths.first != null) {
                resultPath = FileUtil.toSystemDependentName((String)paths.first);
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return StringUtil.trimEnd(resultPath, File.separator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties() {
        PathManager.getHomePath();
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        paths.add(System.getProperty(PROPERTIES_FILE));
        paths.add(PathManager.getCustomPropertiesFile());
        paths.add(SystemProperties.getUserHome() + '/' + PROPERTIES_FILE_NAME);
        for (String binDir : ourBinDirectories) {
            paths.add(binDir + '/' + PROPERTIES_FILE_NAME);
        }
        Properties sysProperties = System.getProperties();
        for (String path : paths) {
            if (path == null || !new File(path).exists()) continue;
            try {
                BufferedReader fis = new BufferedReader(new FileReader(path));
                try {
                    Map<String, String> properties = FileUtil.loadProperties(fis);
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        String key = entry.getKey();
                        if (PROPERTY_HOME_PATH.equals(key) || PROPERTY_HOME.equals(key)) {
                            PathManager.log(path + ": '" + key + "' cannot be redefined");
                            continue;
                        }
                        if (sysProperties.containsKey(key)) continue;
                        sysProperties.setProperty(key, PathManager.substituteVars(entry.getValue()));
                    }
                }
                finally {
                    ((Reader)fis).close();
                }
            }
            catch (IOException e) {
                PathManager.log("Can't read property file '" + path + "': " + e.getMessage());
            }
        }
    }

    private static String getCustomPropertiesFile() {
        String configPath = PathManager.getCustomOptionsDirectory();
        return configPath != null ? configPath + File.separator + PROPERTIES_FILE_NAME : null;
    }

    @Contract(value="null -> null")
    public static String substituteVars(String s) {
        return PathManager.substituteVars(s, PathManager.getHomePath());
    }

    @Contract(value="null, _ -> null")
    public static String substituteVars(String s, String ideaHomePath) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("..")) {
            s = ideaHomePath + File.separatorChar + BIN_FOLDER + File.separatorChar + s;
        }
        Matcher m = PROPERTY_REF.matcher(s);
        while (m.find()) {
            String key = m.group(1);
            String value = System.getProperty(key);
            if (value == null) {
                if (PROPERTY_HOME_PATH.equals(key) || PROPERTY_HOME.equals(key)) {
                    value = ideaHomePath;
                } else if (PROPERTY_CONFIG_PATH.equals(key)) {
                    value = PathManager.getConfigPath();
                } else if (PROPERTY_SYSTEM_PATH.equals(key)) {
                    value = PathManager.getSystemPath();
                }
            }
            if (value == null) {
                PathManager.log("Unknown property: " + key);
                value = "";
            }
            s = StringUtil.replace(s, m.group(), value);
            m = PROPERTY_REF.matcher(s);
        }
        return s;
    }

    @NotNull
    public static File findFileInLibDirectory(@NotNull String relativePath) {
        File file;
        if (relativePath == null) {
            PathManager.$$$reportNull$$$0(34);
        }
        File file2 = (file = new File(PathManager.getLibPath() + File.separator + relativePath)).exists() ? file : new File(PathManager.getHomePath(), "community" + File.separator + LIB_FOLDER + File.separator + relativePath);
        if (file2 == null) {
            PathManager.$$$reportNull$$$0(35);
        }
        return file2;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class aClass) {
        String resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(36);
        }
        return (resourceRoot = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class")) != null ? new File(resourceRoot).getAbsolutePath() : null;
    }

    @NotNull
    public static Collection<String> getUtilClassPath() {
        Class[] classes = new Class[]{PathManager.class, Flow.class, SystemInfoRt.class, Document.class, Appender.class, THashSet.class, TypeMapper.class, FileUtils.class, PatternMatcher.class, LZ4Factory.class};
        HashSet<String> classPath = new HashSet<String>();
        for (Class aClass : classes) {
            String path = PathManager.getJarPathForClass(aClass);
            if (path == null) continue;
            classPath.add(path);
        }
        String resourceRoot = PathManager.getResourceRoot(PathManager.class, "/messages/CommonBundle.properties");
        if (resourceRoot != null) {
            classPath.add(new File(resourceRoot).getAbsolutePath());
        }
        Collection<String> collection = Collections.unmodifiableCollection(classPath);
        if (collection == null) {
            PathManager.$$$reportNull$$$0(37);
        }
        return collection;
    }

    private static void log(String x) {
        System.err.println(x);
    }

    public static String getAbsolutePath(String path) {
        path = FileUtil.expandUserHome(path);
        return FileUtil.toCanonicalPath(new File(path).getAbsolutePath());
    }

    private static String trimPathQuotes(String path) {
        if (path != null && path.length() >= 3 && StringUtil.startsWithChar(path, '\"') && StringUtil.endsWithChar(path, '\"')) {
            path = path.substring(1, path.length() - 1);
        }
        return path;
    }

    private static String platformPath(@NotNull String selector, @Nullable String macPart, @NotNull String fallback) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(38);
        }
        if (fallback == null) {
            PathManager.$$$reportNull$$$0(39);
        }
        return PathManager.platformPath(selector, macPart, null, null, null, fallback);
    }

    private static String platformPath(@NotNull String selector, @Nullable String macPart, @Nullable String winVar, @Nullable String xdgVar, @Nullable String xdgDir, @NotNull String fallback) {
        String dir;
        if (selector == null) {
            PathManager.$$$reportNull$$$0(40);
        }
        if (fallback == null) {
            PathManager.$$$reportNull$$$0(41);
        }
        String userHome = SystemProperties.getUserHome();
        if (macPart != null && SystemInfo.isMac) {
            return userHome + File.separator + macPart + File.separator + selector;
        }
        if (winVar != null && SystemInfo.isWindows && (dir = System.getenv(winVar)) != null) {
            return dir + File.separator + selector;
        }
        if (xdgVar != null && xdgDir != null && SystemInfo.hasXdgOpen()) {
            dir = System.getenv(xdgVar);
            if (dir == null) {
                dir = userHome + File.separator + xdgDir;
            }
            return dir + File.separator + selector;
        }
        return userHome + File.separator + "." + selector + (!fallback.isEmpty() ? File.separator + fallback : "");
    }

    private static String canonicalPath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            return path;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 13: 
            case 16: 
            case 20: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 13: 
            case 16: 
            case 20: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 13: 
            case 20: 
            case 25: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 13: 
            case 16: 
            case 20: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinFileWithException";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstalledPluginsPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigPathFor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPluginPathFor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemPathFor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogPath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginTempPath";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileInLibDirectory";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtilClassPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnderHomeDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHomePathFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBinFileWithException";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPathFor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPluginPathFor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSystemPathFor";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoot";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLibDirectory";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "platformPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 13: 
            case 16: 
            case 20: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

