/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.ConfigureBranchesAction;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.jetbrains.idea.svn.history.LogHierarchyNode;
import org.jetbrains.idea.svn.history.MergeInfoUpdatesListener;
import org.jetbrains.idea.svn.history.MergeSourceHierarchyBuilder;
import org.jetbrains.idea.svn.history.RootsAndBranches;
import org.jetbrains.idea.svn.history.ShowHideMergePanelAction;
import org.jetbrains.idea.svn.history.SingleCommittedListProvider;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedListsZipper;
import org.jetbrains.idea.svn.history.SvnMergeSourceTracker;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.history.SvnVersionFilterComponent;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.StatusType;

public class SvnCommittedChangesProvider
implements CachingCommittedChangesProvider<SvnChangeList, ChangeBrowserSettings> {
    private static final Logger LOG = Logger.getInstance(SvnCommittedChangesProvider.class);
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final MessageBusConnection myConnection;
    private MergeInfoUpdatesListener myMergeInfoUpdatesListener;
    @NotNull
    private final SvnCommittedListsZipper myZipper;
    public static final int VERSION_WITH_COPY_PATHS_ADDED = 2;
    public static final int VERSION_WITH_REPLACED_PATHS = 3;

    public SvnCommittedChangesProvider(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
        this.myZipper = new SvnCommittedListsZipper(this.myVcs);
        this.myConnection = this.myVcs.getProject().getMessageBus().connect();
        this.myConnection.subscribe(VcsConfigurationChangeListener.BRANCHES_CHANGED_RESPONSE, (project, vcsRoot, cachedList) -> ApplicationManager.getApplication().invokeLater(() -> cachedList.stream().filter(SvnChangeList.class::isInstance).map(SvnChangeList.class::cast).filter(list -> vcsRoot == null || vcsRoot.equals(list.getVcsRoot())).forEach(SvnChangeList::forceReloadCachedInfo), project.getDisposed()));
    }

    @NotNull
    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        SvnVersionFilterComponent svnVersionFilterComponent = new SvnVersionFilterComponent(showDateFilter);
        if (svnVersionFilterComponent == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(1);
        }
        return svnVersionFilterComponent;
    }

    @Nullable
    public RepositoryLocation getLocationFor(@NotNull FilePath root) {
        Info info;
        if (root == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(2);
        }
        return (info = this.myVcs.getInfo(root.getIOFile())) != null && info.getURL() != null ? new SvnRepositoryLocation(info.getURL(), info.getRepositoryRootURL(), root) : null;
    }

    @NotNull
    public VcsCommittedListsZipper getZipper() {
        SvnCommittedListsZipper svnCommittedListsZipper = this.myZipper;
        if (svnCommittedListsZipper == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(3);
        }
        return svnCommittedListsZipper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCommittedChanges(@NotNull ChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount, @NotNull AsynchConsumer<CommittedChangeList> consumer) throws VcsException {
        if (settings == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(4);
        }
        if (location == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(6);
        }
        try {
            SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
            Url repositoryRoot = this.getRepositoryRoot(svnLocation);
            ChangeBrowserSettings.Filter filter = settings.createFilter();
            ThrowableConsumer resultConsumer = logEntry -> {
                SvnChangeList list;
                if (consumer == null) {
                    SvnCommittedChangesProvider.$$$reportNull$$$0(44);
                }
                if (filter.accepts((CommittedChangeList)(list = new SvnChangeList(this.myVcs, svnLocation, (LogEntry)logEntry, repositoryRoot)))) {
                    consumer.consume((Object)list);
                }
            };
            Target target = Target.on(svnLocation.toSvnUrl(), SvnCommittedChangesProvider.createBeforeRevision(settings));
            this.getCommittedChangesImpl(settings, target, maxCount, (ThrowableConsumer<LogEntry, SvnBindException>)resultConsumer, false, true);
        }
        finally {
            consumer.finished();
        }
    }

    @NotNull
    public List<SvnChangeList> getCommittedChanges(@NotNull ChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount) throws VcsException {
        if (settings == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(7);
        }
        if (location == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(8);
        }
        SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
        ArrayList result = ContainerUtil.newArrayList();
        Url repositoryRoot = this.getRepositoryRoot(svnLocation);
        ThrowableConsumer resultConsumer = logEntry -> result.add(new SvnChangeList(this.myVcs, svnLocation, (LogEntry)logEntry, repositoryRoot));
        Target target = Target.on(svnLocation.toSvnUrl(), SvnCommittedChangesProvider.createBeforeRevision(settings));
        this.getCommittedChangesImpl(settings, target, maxCount, (ThrowableConsumer<LogEntry, SvnBindException>)resultConsumer, false, true);
        settings.filterChanges((List)result);
        ArrayList arrayList = result;
        if (arrayList == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public void getCommittedChangesWithMergedRevisons(@NotNull ChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount, @NotNull PairConsumer<SvnChangeList, LogHierarchyNode> finalConsumer) throws VcsException {
        if (settings == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(10);
        }
        if (location == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(11);
        }
        if (finalConsumer == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(12);
        }
        SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
        Url repositoryRoot = this.getRepositoryRoot(svnLocation);
        MergeSourceHierarchyBuilder builder = new MergeSourceHierarchyBuilder((Consumer<LogHierarchyNode>)((Consumer)node -> {
            if (finalConsumer == null) {
                SvnCommittedChangesProvider.$$$reportNull$$$0(43);
            }
            finalConsumer.consume((Object)new SvnChangeList(this.myVcs, svnLocation, node.getMe(), repositoryRoot), node);
        }));
        SvnMergeSourceTracker mergeSourceTracker = new SvnMergeSourceTracker(builder);
        this.getCommittedChangesImpl(settings, Target.on(svnLocation.toSvnUrl()), maxCount, mergeSourceTracker, true, false);
        builder.finish();
    }

    @NotNull
    private Url getRepositoryRoot(@NotNull SvnRepositoryLocation svnLocation) throws VcsException {
        Url rootUrl;
        if (svnLocation == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(13);
        }
        if ((rootUrl = SvnUtil.getRepositoryRoot(this.myVcs, svnLocation.toSvnUrl())) == null) {
            throw new SvnBindException("Could not resolve repository root url for " + svnLocation);
        }
        Url url = rootUrl;
        if (url == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(14);
        }
        return url;
    }

    private void getCommittedChangesImpl(@NotNull ChangeBrowserSettings settings, @NotNull Target target, int maxCount, @NotNull ThrowableConsumer<LogEntry, SvnBindException> resultConsumer, boolean includeMergedRevisions, boolean filterOutByDate) throws VcsException {
        if (settings == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(15);
        }
        if (target == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(16);
        }
        if (resultConsumer == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(17);
        }
        ProgressManager.progress((String)SvnBundle.message("progress.text.changes.collecting.changes", new Object[0]), (String)SvnBundle.message("progress.text2.changes.establishing.connection", target.getPath()));
        String author = settings.getUserFilter();
        Revision revisionBefore = SvnCommittedChangesProvider.createBeforeRevision(settings);
        Revision revisionAfter = SvnCommittedChangesProvider.createAfterRevision(settings);
        this.myVcs.getFactory(target).createHistoryClient().doLog(target, revisionBefore, revisionAfter, settings.STOP_ON_COPY, true, includeMergedRevisions, maxCount, null, this.createLogHandler(resultConsumer, filterOutByDate, author));
    }

    @NotNull
    private static Revision createBeforeRevision(@NotNull ChangeBrowserSettings settings) {
        if (settings == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(18);
        }
        Revision revision = SvnCommittedChangesProvider.createRevision(settings.getDateBeforeFilter(), settings.getChangeBeforeFilter(), Revision.HEAD);
        if (revision == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(19);
        }
        return revision;
    }

    @NotNull
    private static Revision createAfterRevision(@NotNull ChangeBrowserSettings settings) {
        if (settings == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(20);
        }
        Revision revision = SvnCommittedChangesProvider.createRevision(settings.getDateAfterFilter(), settings.getChangeAfterFilter(), Revision.of(1L));
        if (revision == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(21);
        }
        return revision;
    }

    @NotNull
    private static Revision createRevision(@Nullable Date date, @Nullable Long change, @NotNull Revision defaultValue) {
        if (defaultValue == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(22);
        }
        Revision result = date != null ? Revision.of(date) : (change != null ? Revision.of(change) : defaultValue);
        Revision revision = result;
        if (revision == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(23);
        }
        return revision;
    }

    @NotNull
    private LogEntryConsumer createLogHandler(@NotNull ThrowableConsumer<LogEntry, SvnBindException> resultConsumer, boolean filterOutByDate, @Nullable String author) {
        if (resultConsumer == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(24);
        }
        LogEntryConsumer logEntryConsumer = logEntry -> {
            if (resultConsumer == null) {
                SvnCommittedChangesProvider.$$$reportNull$$$0(42);
            }
            if (this.myVcs.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (logEntry != LogEntry.EMPTY) {
                ProgressManager.progress2((String)SvnBundle.message("progress.text2.processing.revision", logEntry.getRevision()));
            }
            if (filterOutByDate && logEntry.getDate() == null) {
                return;
            }
            if (author == null || author.equalsIgnoreCase(logEntry.getAuthor())) {
                resultConsumer.consume(logEntry);
            }
        };
        if (logEntryConsumer == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(25);
        }
        return logEntryConsumer;
    }

    @NotNull
    public ChangeListColumn[] getColumns() {
        ChangeListColumn[] changeListColumnArray = new ChangeListColumn[]{new ChangeListColumn.ChangeListNumberColumn(SvnBundle.message("revision.title", new Object[0])), ChangeListColumn.NAME, ChangeListColumn.DATE, ChangeListColumn.DESCRIPTION};
        if (changeListColumnArray == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(26);
        }
        return changeListColumnArray;
    }

    private void refreshMergeInfo(@NotNull RootsAndBranches action) {
        if (action == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(27);
        }
        if (this.myMergeInfoUpdatesListener == null) {
            this.myMergeInfoUpdatesListener = new MergeInfoUpdatesListener(this.myVcs.getProject(), this.myConnection);
        }
        this.myMergeInfoUpdatesListener.addPanel(action);
    }

    @NotNull
    public VcsCommittedViewAuxiliary createActions(@NotNull DecoratorManager manager, @Nullable RepositoryLocation location) {
        if (manager == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(28);
        }
        RootsAndBranches rootsAndBranches = new RootsAndBranches(this.myVcs, manager, location);
        this.refreshMergeInfo(rootsAndBranches);
        DefaultActionGroup popup = new DefaultActionGroup(this.myVcs.getDisplayName(), true);
        popup.add((AnAction)rootsAndBranches.getIntegrateAction());
        popup.add((AnAction)rootsAndBranches.getUndoIntegrateAction());
        popup.add((AnAction)new ConfigureBranchesAction());
        ShowHideMergePanelAction action = new ShowHideMergePanelAction(manager, rootsAndBranches.getStrategy());
        VcsCommittedViewAuxiliary vcsCommittedViewAuxiliary = new VcsCommittedViewAuxiliary(Collections.singletonList(popup), () -> {
            if (this.myMergeInfoUpdatesListener != null) {
                this.myMergeInfoUpdatesListener.removePanel(rootsAndBranches);
                rootsAndBranches.dispose();
            }
        }, Collections.singletonList(action));
        if (vcsCommittedViewAuxiliary == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(29);
        }
        return vcsCommittedViewAuxiliary;
    }

    public int getUnlimitedCountValue() {
        return 0;
    }

    @Nullable
    public Pair<SvnChangeList, FilePath> getOneList(@NotNull VirtualFile file, @NotNull VcsRevisionNumber number) throws VcsException {
        if (file == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(30);
        }
        if (number == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(31);
        }
        return new SingleCommittedListProvider(this.myVcs, file, number).run();
    }

    @NotNull
    public RepositoryLocation getForNonLocal(@NotNull VirtualFile file) {
        if (file == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(32);
        }
        SvnRepositoryLocation svnRepositoryLocation = new SvnRepositoryLocation(FileUtil.toSystemIndependentName((String)file.getPresentableUrl()));
        if (svnRepositoryLocation == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(33);
        }
        return svnRepositoryLocation;
    }

    public boolean supportsIncomingChanges() {
        return true;
    }

    public int getFormatVersion() {
        return 3;
    }

    public void writeChangeList(@NotNull DataOutput dataStream, @NotNull SvnChangeList list) throws IOException {
        if (dataStream == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(34);
        }
        if (list == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(35);
        }
        list.writeToStream(dataStream);
    }

    @NotNull
    public SvnChangeList readChangeList(@NotNull RepositoryLocation location, @NotNull DataInput stream) throws IOException {
        if (location == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(36);
        }
        if (stream == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(37);
        }
        int version = this.getFormatVersion();
        SvnChangeList svnChangeList = new SvnChangeList(this.myVcs, (SvnRepositoryLocation)location, stream, 2 <= version, 3 <= version);
        if (svnChangeList == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(38);
        }
        return svnChangeList;
    }

    public boolean isMaxCountSupported() {
        return true;
    }

    @Nullable
    public Collection<FilePath> getIncomingFiles(@NotNull RepositoryLocation location) throws VcsException {
        if (location == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(39);
        }
        FilePath root = null;
        if (Registry.is((String)"svn.use.incoming.optimization") && (root = ((SvnRepositoryLocation)location).getRoot()) == null) {
            LOG.info("Working copy root is not provided for repository location " + location);
        }
        return root != null ? this.getIncomingFiles(root) : null;
    }

    @NotNull
    private Collection<FilePath> getIncomingFiles(@NotNull FilePath root) throws SvnBindException {
        if (root == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(40);
        }
        HashSet result = ContainerUtil.newHashSet();
        File rootFile = root.getIOFile();
        this.myVcs.getFactory(rootFile).createStatusClient().doStatus(rootFile, Revision.UNDEFINED, Depth.INFINITY, true, false, false, false, status -> {
            boolean changedOnServer;
            File file = status.getFile();
            boolean bl = changedOnServer = SvnCommittedChangesProvider.isNotNone(status.getRemoteContentsStatus()) || SvnCommittedChangesProvider.isNotNone(status.getRemoteNodeStatus()) || SvnCommittedChangesProvider.isNotNone(status.getRemotePropertiesStatus());
            if (file != null && changedOnServer) {
                result.add(VcsUtil.getFilePath((File)file));
            }
        });
        HashSet hashSet = result;
        if (hashSet == null) {
            SvnCommittedChangesProvider.$$$reportNull$$$0(41);
        }
        return hashSet;
    }

    private static boolean isNotNone(@Nullable StatusType status) {
        return status != null && !StatusType.STATUS_NONE.equals((Object)status);
    }

    public boolean refreshCacheByNumber() {
        return true;
    }

    public String getChangelistTitle() {
        return SvnBundle.message("changes.browser.revision.term", new Object[0]);
    }

    public boolean isChangeLocallyAvailable(FilePath filePath, @Nullable VcsRevisionNumber localRevision, VcsRevisionNumber changeRevision, SvnChangeList changeList) {
        return localRevision != null && localRevision.compareTo((Object)changeRevision) >= 0;
    }

    public boolean refreshIncomingWithCommitted() {
        return true;
    }

    public void deactivate() {
        this.myConnection.disconnect();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 33: 
            case 38: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 33: 
            case 38: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 33: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider";
                break;
            }
            case 2: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 6: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalConsumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svnLocation";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 17: 
            case 24: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultConsumer";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/SvnCommittedChangesProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilterUI";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getZipper";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommittedChanges";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryRoot";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createBeforeRevision";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createAfterRevision";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createRevision";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogHandler";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getForNonLocal";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "readChangeList";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncomingFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 33: 
            case 38: 
            case 41: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLocationFor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadCommittedChanges";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCommittedChanges";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommittedChangesWithMergedRevisons";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryRoot";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCommittedChangesImpl";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createBeforeRevision";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createAfterRevision";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createRevision";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createLogHandler";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "refreshMergeInfo";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createActions";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getOneList";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getForNonLocal";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "writeChangeList";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "readChangeList";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getIncomingFiles";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createLogHandler$6";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCommittedChangesWithMergedRevisons$5";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadCommittedChanges$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 33: 
            case 38: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

