/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathEnvironmentVariableUtil {
    private static final String PATH = "PATH";

    private PathEnvironmentVariableUtil() {
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName) {
        if (fileBaseName == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(0);
        }
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, null);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(1);
        }
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, EnvironmentUtil.getValue((String)PATH), filter);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, @Nullable String pathVariableValue, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(2);
        }
        List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(true, filter, pathVariableValue, fileBaseName);
        return (File)ContainerUtil.getFirstItem(exeFiles);
    }

    private static File findInOriginalPath(@NotNull String fileBaseName) {
        if (fileBaseName == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(3);
        }
        List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(true, null, System.getenv(PATH), fileBaseName);
        return (File)ContainerUtil.getFirstItem(exeFiles);
    }

    @NotNull
    public static List<File> findAllExeFilesInPath(@NotNull String fileBaseName) {
        if (fileBaseName == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(4);
        }
        List<File> list = PathEnvironmentVariableUtil.findAllExeFilesInPath(fileBaseName, null);
        if (list == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static List<File> findAllExeFilesInPath(@NotNull String fileBaseName, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(6);
        }
        List<File> list = PathEnvironmentVariableUtil.findExeFilesInPath(false, filter, EnvironmentUtil.getValue((String)PATH), fileBaseName);
        if (list == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static List<File> findExeFilesInPath(boolean stopAfterFirstMatch, @Nullable FileFilter filter, @Nullable String pathEnvVarValue, String ... fileBaseNames) {
        if (fileBaseNames == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(8);
        }
        if (pathEnvVarValue == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                PathEnvironmentVariableUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        SmartList result2 = new SmartList();
        List<String> dirPaths = PathEnvironmentVariableUtil.getPathDirs(pathEnvVarValue);
        for (String dirPath : dirPaths) {
            File dir = new File(dirPath);
            if (!dir.isAbsolute() || !dir.isDirectory()) continue;
            for (String fileBaseName : fileBaseNames) {
                File exeFile = new File(dir, fileBaseName);
                if (!exeFile.isFile() || !exeFile.canExecute() || filter != null && !filter.accept(exeFile)) continue;
                result2.add(exeFile);
                if (!stopAfterFirstMatch) continue;
                SmartList smartList = result2;
                if (smartList == null) {
                    PathEnvironmentVariableUtil.$$$reportNull$$$0(10);
                }
                return smartList;
            }
        }
        SmartList smartList = result2;
        if (smartList == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    @NotNull
    public static List<String> getPathDirs(@NotNull String pathEnvVarValue) {
        if (pathEnvVarValue == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(12);
        }
        List list = StringUtil.split((String)pathEnvVarValue, (String)File.pathSeparator, (boolean)true, (boolean)true);
        if (list == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public static String toLocatableExePath(@NotNull String exePath) {
        File resolvedExeFile;
        File originalResolvedExeFile;
        if (exePath == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(14);
        }
        if (SystemInfo.isMac && !StringUtil.containsChar((String)exePath, (char)'/') && !StringUtil.containsChar((String)exePath, (char)'\\') && (originalResolvedExeFile = PathEnvironmentVariableUtil.findInOriginalPath(exePath)) == null && (resolvedExeFile = PathEnvironmentVariableUtil.findInPath(exePath)) != null) {
            exePath = resolvedExeFile.getAbsolutePath();
        }
        String string = exePath;
        if (string == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static List<String> getWindowsExecutableFileExtensions() {
        String allExtensions;
        if (SystemInfo.isWindows && (allExtensions = System.getenv("PATHEXT")) != null) {
            List extensions = StringUtil.split((String)allExtensions, (String)";", (boolean)true, (boolean)true);
            extensions = ContainerUtil.filter((Collection)extensions, s -> !StringUtil.isEmpty((String)s) && s.startsWith("."));
            List list = ContainerUtil.map2List((Collection)extensions, s -> StringUtil.toLowerCase((String)s));
            if (list == null) {
                PathEnvironmentVariableUtil.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(17);
        }
        return list;
    }

    public static String findExecutableInWindowsPath(@NotNull String exePath) {
        if (exePath == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(18);
        }
        if (SystemInfo.isWindows && !StringUtil.containsChar((String)exePath, (char)'/') && !StringUtil.containsChar((String)exePath, (char)'\\')) {
            List<String> executableFileExtensions = PathEnvironmentVariableUtil.getWindowsExecutableFileExtensions();
            String[] baseNames = (String[])ContainerUtil.map2Array(executableFileExtensions, String.class, s -> {
                if (exePath == null) {
                    PathEnvironmentVariableUtil.$$$reportNull$$$0(19);
                }
                return exePath + s;
            });
            List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(true, null, EnvironmentUtil.getValue((String)PATH), baseNames);
            File foundFile = (File)ContainerUtil.getFirstItem(exeFiles);
            if (foundFile != null) {
                return foundFile.getAbsolutePath();
            }
        }
        return exePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBaseName";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/PathEnvironmentVariableUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBaseNames";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathEnvVarValue";
                break;
            }
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/PathEnvironmentVariableUtil";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllExeFilesInPath";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findExeFilesInPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathDirs";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toLocatableExePath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowsExecutableFileExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findInOriginalPath";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAllExeFilesInPath";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findExeFilesInPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPathDirs";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toLocatableExePath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findExecutableInWindowsPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findExecutableInWindowsPath$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

