/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeFoldingBuilder
extends FoldingBuilderEx
implements PossiblyDumbAware {
    public static final Key<FoldingBuilder> FOLDING_BUILDER = new Key("FOLDING_BUILDER");
    private final List<FoldingBuilder> myBuilders;

    CompositeFoldingBuilder(List<FoldingBuilder> builders) {
        this.myBuilders = builders;
    }

    @Override
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(1);
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        HashSet rangesCoveredByDescriptors = ContainerUtil.newHashSet();
        for (FoldingBuilder builder : DumbService.getInstance(root.getProject()).filterByDumbAwareness(this.myBuilders)) {
            for (FoldingDescriptor descriptor : LanguageFolding.buildFoldingDescriptors(builder, root, document, quick)) {
                if (!rangesCoveredByDescriptors.add(descriptor.getRange())) continue;
                descriptor.getElement().putUserData(FOLDING_BUILDER, builder);
                descriptors.add(descriptor);
            }
        }
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY);
        if (foldingDescriptorArray == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    @Override
    public String getPlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        FoldingBuilder builder;
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (range == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(4);
        }
        return !CompositeFoldingBuilder.mayUseBuilder(node, builder = (FoldingBuilder)node.getUserData(FOLDING_BUILDER)) ? node.getText() : (builder instanceof FoldingBuilderEx ? ((FoldingBuilderEx)builder).getPlaceholderText(node, range) : builder.getPlaceholderText(node));
    }

    @Override
    public String getPlaceholderText(@NotNull ASTNode node) {
        FoldingBuilder builder;
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(5);
        }
        return !CompositeFoldingBuilder.mayUseBuilder(node, builder = (FoldingBuilder)node.getUserData(FOLDING_BUILDER)) ? node.getText() : builder.getPlaceholderText(node);
    }

    @Override
    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        FoldingBuilder builder;
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(6);
        }
        return CompositeFoldingBuilder.mayUseBuilder(node, builder = (FoldingBuilder)node.getUserData(FOLDING_BUILDER)) && builder.isCollapsedByDefault(node);
    }

    private static boolean mayUseBuilder(@NotNull ASTNode node, @Nullable FoldingBuilder builder) {
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            return false;
        }
        if (DumbService.isDumbAware(builder)) {
            return true;
        }
        Project project = CompositeFoldingBuilder.getProjectByNode(node);
        return project == null || !DumbService.isDumb(project);
    }

    @Nullable
    private static Project getProjectByNode(@NotNull ASTNode node) {
        PsiElement psi;
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(8);
        }
        if ((psi = node.getPsi()) == null) {
            ASTNode parent = node.getTreeParent();
            psi = parent == null ? null : parent.getPsi();
        }
        return psi == null ? null : psi.getProject();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.myBuilders;
    }

    @Override
    public boolean isDumbAware() {
        for (FoldingBuilder builder : this.myBuilders) {
            if (!DumbService.isDumbAware(builder)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/folding/CompositeFoldingBuilder";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/folding/CompositeFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mayUseBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProjectByNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

