/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.customizeActions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class DissociateResourceBundleAction
extends AnAction {
    private static final String SINGLE_RB_PRESENTATION_TEXT_TEMPLATE = "Dissociate Resource Bundle '%s'";
    private static final String MULTIPLE_RB_PRESENTATION_TEXT_TEMPLATE = "Dissociate %s Resource Bundles";

    public DissociateResourceBundleAction() {
        super(null, null, AllIcons.FileTypes.Properties);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Collection<ResourceBundle> resourceBundles = DissociateResourceBundleAction.extractResourceBundles(e);
        assert (resourceBundles.size() > 0);
        DissociateResourceBundleAction.dissociate(resourceBundles, project);
    }

    public void update(AnActionEvent e) {
        Collection<ResourceBundle> resourceBundles = DissociateResourceBundleAction.extractResourceBundles(e);
        if (!resourceBundles.isEmpty()) {
            String actionText = resourceBundles.size() == 1 ? String.format(SINGLE_RB_PRESENTATION_TEXT_TEMPLATE, ((ResourceBundle)ContainerUtil.getFirstItem(resourceBundles)).getBaseName()) : String.format(MULTIPLE_RB_PRESENTATION_TEXT_TEMPLATE, resourceBundles.size());
            e.getPresentation().setText(actionText, false);
            e.getPresentation().setVisible(true);
        } else {
            e.getPresentation().setVisible(false);
        }
    }

    public static void dissociate(Collection<ResourceBundle> resourceBundles, Project project) {
        HashSet<PsiDirectory> toUpdateInProjectView = new HashSet<PsiDirectory>();
        for (ResourceBundle resourceBundle : resourceBundles) {
            for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
                PsiDirectory containingDirectory = propertiesFile.getContainingFile().getContainingDirectory();
                if (containingDirectory == null) continue;
                toUpdateInProjectView.add(containingDirectory);
            }
            ResourceBundleManager.getInstance(project).dissociateResourceBundle(resourceBundle);
        }
        AbstractProjectViewPane currentProjectViewPane = ProjectView.getInstance((Project)project).getCurrentProjectViewPane();
        if (currentProjectViewPane != null) {
            for (PsiFileSystemItem psiFileSystemItem : toUpdateInProjectView) {
                currentProjectViewPane.updateFrom((Object)psiFileSystemItem, false, true);
            }
        }
    }

    @NotNull
    private static Collection<ResourceBundle> extractResourceBundles(AnActionEvent event) {
        PsiElement[] psiElements;
        HashSet<ResourceBundle> targetResourceBundles = new HashSet<ResourceBundle>();
        ResourceBundle[] chosenResourceBundles = (ResourceBundle[])event.getData(ResourceBundle.ARRAY_DATA_KEY);
        if (chosenResourceBundles != null) {
            for (ResourceBundle resourceBundle : chosenResourceBundles) {
                if (resourceBundle.getPropertiesFiles().size() <= 1) continue;
                targetResourceBundles.add(resourceBundle);
            }
        }
        if ((psiElements = (PsiElement[])event.getData(LangDataKeys.PSI_ELEMENT_ARRAY)) != null) {
            for (PsiElement element : psiElements) {
                ResourceBundle bundle;
                PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(element);
                if (propertiesFile == null || (bundle = propertiesFile.getResourceBundle()).getPropertiesFiles().size() <= 1) continue;
                targetResourceBundles.add(bundle);
            }
        }
        HashSet<ResourceBundle> hashSet = targetResourceBundles;
        if (hashSet == null) {
            DissociateResourceBundleAction.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/customizeActions/DissociateResourceBundleAction", "extractResourceBundles"));
    }
}

