/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import net.sourceforge.plantuml.DirWatcher2;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.swing.AboutWindow;
import net.sourceforge.plantuml.swing.ImageWindow2;
import net.sourceforge.plantuml.swing.SimpleLine2;
import net.sourceforge.plantuml.swing.SpriteWindow;
import net.sourceforge.plantuml.version.PSystemVersion;

public class MainWindow2
extends JFrame {
    private static final Preferences prefs = Preferences.userNodeForPackage(MainWindow2.class);
    private static final String KEY_DIR = "cur";
    private static final String KEY_PATTERN = "pat";
    private final JList jList1 = new JList();
    private final JScrollPane scrollPane;
    private final JButton changeDirButton = new JButton("Change Directory");
    private final JTextField extensions = new JTextField();
    private final int period = 300;
    private final List<SimpleLine2> currentDirectoryListing2 = new ArrayList<SimpleLine2>();
    private final Set<ImageWindow2> openWindows2 = new HashSet<ImageWindow2>();
    private final Option option;
    private DirWatcher2 dirWatcher;

    private String getExtensions() {
        return prefs.get(KEY_PATTERN, this.getDefaultFileExtensions());
    }

    private String getDefaultFileExtensions() {
        return "txt, tex, java, htm, html, c, h, cpp, apt, pu, puml";
    }

    private void changeExtensions(String ext) {
        if (ext.equals(this.getExtensions())) {
            return;
        }
        Pattern p = Pattern.compile("\\w+");
        Matcher m = p.matcher(ext);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            String value = m.group();
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(value);
        }
        ext = sb.toString();
        if (ext.length() == 0) {
            ext = this.getDefaultFileExtensions();
        }
        this.extensions.setText(ext);
        prefs.put(KEY_PATTERN, ext);
        this.changeDir(this.dirWatcher.getDir());
    }

    private String getRegexpPattern(String ext) {
        Pattern p = Pattern.compile("\\w+");
        Matcher m = p.matcher(ext);
        StringBuilder filePattern = new StringBuilder("(?i)^.*\\.(");
        while (m.find()) {
            String value = m.group();
            if (!filePattern.toString().endsWith("(")) {
                filePattern.append("|");
            }
            filePattern.append(value);
        }
        if (!filePattern.toString().endsWith("(")) {
            filePattern.append(")$");
            return filePattern.toString();
        }
        return Option.getPattern();
    }

    public MainWindow2(Option option, File arg) {
        super(MainWindow2.getDirectory(arg).getAbsolutePath());
        File dir = MainWindow2.getDirectory(arg);
        this.setIconImage(PSystemVersion.getPlantumlSmallIcon2());
        this.option = option;
        this.dirWatcher = new DirWatcher2(dir, option, this.getRegexpPattern(this.getExtensions()));
        Log.info("Showing MainWindow");
        this.scrollPane = new JScrollPane(this.jList1);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel south = new JPanel(new BorderLayout());
        JLabel labelFileExtensions = new JLabel("File extensions: ");
        this.extensions.setText(this.getExtensions());
        labelFileExtensions.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createEtchedBorder());
        border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        south.setBorder(border);
        south.add((Component)labelFileExtensions, "West");
        south.add((Component)this.extensions, "Center");
        south.add((Component)this.changeDirButton, "South");
        this.getContentPane().add((Component)south, "South");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (e.getClickCount() == 2) {
                        int index = MainWindow2.this.jList1.locationToIndex(e.getPoint());
                        MainWindow2.this.doubleClick((SimpleLine2)MainWindow2.this.jList1.getModel().getElementAt(index), MainWindow2.this.jList1.getModel(), index);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.jList1.addMouseListener(mouseListener);
        this.changeDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.err.println("Opening Directory Window");
                MainWindow2.this.displayDialogChangeDir();
            }
        });
        this.jList1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    int index = MainWindow2.this.jList1.getSelectedIndex();
                    MainWindow2.this.doubleClick((SimpleLine2)MainWindow2.this.jList1.getModel().getElementAt(index), MainWindow2.this.jList1.getModel(), index);
                }
            }
        });
        this.extensions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow2.this.changeExtensions(MainWindow2.this.extensions.getText());
            }
        });
        this.extensions.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                MainWindow2.this.changeExtensions(MainWindow2.this.extensions.getText());
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu mFile = new JMenu("File");
        menuBar.add(mFile);
        this.setJMenuBar(menuBar);
        JMenuItem sprite = new JMenuItem("Open Sprite Window");
        mFile.add(sprite);
        sprite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SpriteWindow();
            }
        });
        JMenuItem about = new JMenuItem("About");
        mFile.add(about);
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutWindow();
            }
        });
        JMenuItem exit = new JMenuItem("Exit");
        mFile.add(exit);
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.setSize(640, 400);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
        this.startTimer();
    }

    private static File getDirectory(File arg) {
        if (arg != null && arg.exists() && arg.isDirectory()) {
            return arg;
        }
        return new File(prefs.get(KEY_DIR, "."));
    }

    private void startTimer() {
        Log.info("Init done");
        Timer timer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow2.this.tick();
            }
        });
        timer.setInitialDelay(0);
        timer.start();
        Log.info("Timer started");
    }

    private void displayDialogChangeDir() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(2);
        chooser.setDialogTitle("Directory to watch:");
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        String currentPath = prefs.get(KEY_DIR, ".");
        chooser.setCurrentDirectory(new File(currentPath));
        Log.info("Showing OpenDialog");
        int returnVal = chooser.showOpenDialog(this);
        Log.info("Closing OpenDialog");
        if (returnVal == 0) {
            File dir = chooser.getSelectedFile();
            this.changeDir(dir);
        }
    }

    private void changeDir(File dir) {
        prefs.put(KEY_DIR, dir.getAbsolutePath());
        this.dirWatcher.cancel();
        this.dirWatcher = new DirWatcher2(dir, this.option, this.getRegexpPattern(this.getExtensions()));
        this.setTitle(dir.getAbsolutePath());
        Log.info("Creating DirWatcher");
        this.currentDirectoryListing2.clear();
        this.jList1.setListData(new Vector<SimpleLine2>(this.currentDirectoryListing2));
        this.jList1.setVisible(true);
    }

    private void doubleClick(SimpleLine2 simpleLine, ListModel listModel, int index) {
        for (ImageWindow2 win : this.openWindows2) {
            if (!win.getSimpleLine().equals(simpleLine)) continue;
            win.setVisible(true);
            win.setExtendedState(0);
            return;
        }
        if (simpleLine.getGeneratedImage() != null) {
            this.openWindows2.add(new ImageWindow2(simpleLine, this, listModel, index));
        }
    }

    private void tick() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean changed = MainWindow2.this.refreshDir();
                    if (changed) {
                        MainWindow2.this.jList1.setListData(new Vector(MainWindow2.this.currentDirectoryListing2));
                        MainWindow2.this.jList1.setVisible(true);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private boolean refreshDir() throws IOException, InterruptedException, ExecutionException {
        Map<File, Future<List<GeneratedImage>>> createdFiles2 = this.dirWatcher.buildCreatedFiles();
        boolean changed = false;
        for (Map.Entry<File, Future<List<GeneratedImage>>> ent : createdFiles2.entrySet()) {
            File file = ent.getKey();
            this.removeAllThatUseThisFile(file);
            Future<List<GeneratedImage>> future = ent.getValue();
            SimpleLine2 simpleLine = SimpleLine2.fromFuture(file, future);
            this.currentDirectoryListing2.add(simpleLine);
            changed = true;
        }
        for (SimpleLine2 line : new ArrayList<SimpleLine2>(this.currentDirectoryListing2)) {
            if (!line.pendingAndFinished()) continue;
            this.currentDirectoryListing2.remove(line);
            changed = true;
            Future<List<GeneratedImage>> future = line.getFuture();
            for (GeneratedImage im : future.get()) {
                this.mayRefreshImageWindow(im.getPngFile());
                SimpleLine2 simpleLine = SimpleLine2.fromGeneratedImage(line.getFile(), im);
                this.currentDirectoryListing2.add(simpleLine);
            }
        }
        Collections.sort(this.currentDirectoryListing2);
        return changed;
    }

    private void removeAllThatUseThisFile(File file) {
        Iterator<SimpleLine2> it = this.currentDirectoryListing2.iterator();
        while (it.hasNext()) {
            SimpleLine2 line = it.next();
            if (!line.getFile().equals(file)) continue;
            it.remove();
        }
    }

    private void mayRefreshImageWindow(File pngFile) {
        for (ImageWindow2 win : this.openWindows2) {
            if (win.getSimpleLine().getGeneratedImage() == null || !pngFile.equals(win.getSimpleLine().getGeneratedImage().getPngFile())) continue;
            win.refreshImage(true);
        }
    }

    public void closing(ImageWindow2 imageWindow) {
        boolean ok = this.openWindows2.remove(imageWindow);
        if (!ok) {
            throw new IllegalStateException();
        }
    }

    public List<SimpleLine2> getCurrentDirectoryListing2() {
        return Collections.unmodifiableList(this.currentDirectoryListing2);
    }
}

