/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.sprite;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.sprite.Sprite;

public class SpriteMonochrome
implements Sprite {
    private final int width;
    private final int height;
    private final int grayLevel;
    private final int[][] pixels;

    SpriteMonochrome(int width, int height, int grayLevel) {
        if (grayLevel != 2 && grayLevel != 4 && grayLevel != 8 && grayLevel != 16) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
        this.grayLevel = grayLevel;
        this.pixels = new int[height][width];
    }

    void setPixel(int x, int y, int level) {
        if (x < 0 || x >= this.width) {
            return;
        }
        if (y < 0 || y >= this.height) {
            return;
        }
        if (level < 0 || level >= this.grayLevel) {
            throw new IllegalArgumentException("level=" + level + " grayLevel=" + this.grayLevel);
        }
        this.pixels[y][x] = level;
    }

    public int getHeight() {
        return this.height;
    }

    int getWidth() {
        return this.width;
    }

    public UImage toUImage(ColorMapper colorMapper, HtmlColor backcolor, HtmlColor color) {
        BufferedImage im = new BufferedImage(this.width, this.height, 1);
        if (backcolor == null) {
            backcolor = HtmlColorUtils.WHITE;
        }
        if (color == null) {
            color = HtmlColorUtils.BLACK;
        }
        HtmlColorGradient gradient = new HtmlColorGradient(backcolor, color, '\u0000');
        for (int col = 0; col < this.width; ++col) {
            for (int line = 0; line < this.height; ++line) {
                double coef = 1.0 * (double)this.pixels[line][col] / (double)(this.grayLevel - 1);
                Color c = gradient.getColor(colorMapper, coef);
                im.setRGB(col, line, c.getRGB());
            }
        }
        return new UImage(im);
    }

    @Override
    public TextBlock asTextBlock(final HtmlColor color, final double scale) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                UImage image = SpriteMonochrome.this.toUImage(ug.getColorMapper(), ug.getParam().getBackcolor(), color);
                ug.draw(image.scale(scale));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble((double)SpriteMonochrome.this.getWidth() * scale, (double)SpriteMonochrome.this.getHeight() * scale);
            }
        };
    }
}

