/*
 * Decompiled with CFR 0.152.
 */
package git4idea.status;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.status.GitChangesCollector;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

class GitOldChangesCollector
extends GitChangesCollector {
    private final List<VirtualFile> myUnversioned;
    private final Set<String> myUnmergedNames;
    private final List<Change> myChanges;

    @NotNull
    static GitOldChangesCollector collect(@NotNull Project project, @NotNull ChangeListManager changeListManager, @NotNull ProjectLevelVcsManager vcsManager, @NotNull AbstractVcs vcs, @NotNull VcsDirtyScope dirtyScope, @NotNull VirtualFile vcsRoot) throws VcsException {
        if (project == null) {
            GitOldChangesCollector.$$$reportNull$$$0(0);
        }
        if (changeListManager == null) {
            GitOldChangesCollector.$$$reportNull$$$0(1);
        }
        if (vcsManager == null) {
            GitOldChangesCollector.$$$reportNull$$$0(2);
        }
        if (vcs == null) {
            GitOldChangesCollector.$$$reportNull$$$0(3);
        }
        if (dirtyScope == null) {
            GitOldChangesCollector.$$$reportNull$$$0(4);
        }
        if (vcsRoot == null) {
            GitOldChangesCollector.$$$reportNull$$$0(5);
        }
        GitOldChangesCollector gitOldChangesCollector = new GitOldChangesCollector(project, changeListManager, vcsManager, vcs, dirtyScope, vcsRoot);
        if (gitOldChangesCollector == null) {
            GitOldChangesCollector.$$$reportNull$$$0(6);
        }
        return gitOldChangesCollector;
    }

    @Override
    @NotNull
    Collection<VirtualFile> getUnversionedFiles() {
        List<VirtualFile> list = this.myUnversioned;
        if (list == null) {
            GitOldChangesCollector.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    Collection<Change> getChanges() {
        List<Change> list = this.myChanges;
        if (list == null) {
            GitOldChangesCollector.$$$reportNull$$$0(8);
        }
        return list;
    }

    private GitOldChangesCollector(@NotNull Project project, @NotNull ChangeListManager changeListManager, @NotNull ProjectLevelVcsManager vcsManager, @NotNull AbstractVcs vcs, @NotNull VcsDirtyScope dirtyScope, @NotNull VirtualFile vcsRoot) throws VcsException {
        if (project == null) {
            GitOldChangesCollector.$$$reportNull$$$0(9);
        }
        if (changeListManager == null) {
            GitOldChangesCollector.$$$reportNull$$$0(10);
        }
        if (vcsManager == null) {
            GitOldChangesCollector.$$$reportNull$$$0(11);
        }
        if (vcs == null) {
            GitOldChangesCollector.$$$reportNull$$$0(12);
        }
        if (dirtyScope == null) {
            GitOldChangesCollector.$$$reportNull$$$0(13);
        }
        if (vcsRoot == null) {
            GitOldChangesCollector.$$$reportNull$$$0(14);
        }
        super(project, changeListManager, vcsManager, vcs, dirtyScope, vcsRoot);
        this.myUnversioned = new ArrayList<VirtualFile>();
        this.myUnmergedNames = new HashSet<String>();
        this.myChanges = new ArrayList<Change>();
        this.updateIndex();
        this.collectUnmergedAndUnversioned();
        this.collectDiffChanges();
    }

    private void updateIndex() throws VcsException {
        GitLineHandler handler = new GitLineHandler(this.myProject, this.myVcsRoot, GitCommand.UPDATE_INDEX);
        handler.addParameters("--refresh", "--ignore-missing");
        handler.setSilent(true);
        handler.setStdoutSuppressed(true);
        Git.getInstance().runCommand(handler).getOutputOrThrow(1);
    }

    private void collectDiffChanges() throws VcsException {
        block5: {
            Collection<FilePath> dirtyPaths = this.dirtyPaths(true);
            if (dirtyPaths.isEmpty()) {
                return;
            }
            try {
                String output = GitChangeUtils.getDiffOutput(this.myProject, this.myVcsRoot, "HEAD", dirtyPaths);
                GitChangeUtils.parseChanges(this.myProject, this.myVcsRoot, null, GitChangeUtils.resolveReference(this.myProject, this.myVcsRoot, "HEAD"), output, this.myChanges, this.myUnmergedNames);
            }
            catch (VcsException ex) {
                if (!GitChangeUtils.isHeadMissing(ex)) {
                    throw ex;
                }
                GitLineHandler handler = new GitLineHandler(this.myProject, this.myVcsRoot, GitCommand.LS_FILES);
                handler.addParameters("--cached");
                handler.setSilent(true);
                handler.setStdoutSuppressed(true);
                String output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
                if (output.length() <= 0) break block5;
                StringTokenizer tokenizer = new StringTokenizer(output, "\n\r");
                while (tokenizer.hasMoreTokens()) {
                    String s = tokenizer.nextToken();
                    Change ch = new Change(null, GitContentRevision.createRevision(this.myVcsRoot, s, null, this.myProject, true), FileStatus.ADDED);
                    this.myChanges.add(ch);
                }
            }
        }
    }

    private void collectUnmergedAndUnversioned() throws VcsException {
        Collection<FilePath> dirtyPaths = this.dirtyPaths(false);
        if (dirtyPaths.isEmpty()) {
            return;
        }
        GitLineHandler handler = new GitLineHandler(this.myProject, this.myVcsRoot, GitCommand.LS_FILES);
        handler.addParameters("-v", "--unmerged");
        handler.setSilent(true);
        handler.setStdoutSuppressed(true);
        this.parseFiles(Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]));
        handler = new GitLineHandler(this.myProject, this.myVcsRoot, GitCommand.LS_FILES);
        handler.addParameters("-v", "--others", "--exclude-standard");
        handler.setSilent(true);
        handler.setStdoutSuppressed(true);
        handler.endOptions();
        handler.addRelativePaths(dirtyPaths);
        if (handler.isLargeCommandLine()) {
            handler = new GitLineHandler(this.myProject, this.myVcsRoot, GitCommand.LS_FILES);
            handler.addParameters("-v", "--others", "--exclude-standard");
            handler.setSilent(true);
            handler.setStdoutSuppressed(true);
            handler.endOptions();
        }
        this.parseFiles(Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]));
    }

    private void parseFiles(String list) throws VcsException {
        StringScanner sc = new StringScanner(list);
        while (sc.hasMoreData()) {
            Object file;
            if (sc.isEol()) {
                sc.nextLine();
                continue;
            }
            char status = sc.peek();
            sc.skipChars(2);
            if ('?' == status) {
                file = this.myVcsRoot.findFileByRelativePath(GitUtil.unescapePath(sc.line()));
                if (!Comparing.equal((Object)GitUtil.gitRootOrNull(file), (Object)this.myVcsRoot)) continue;
                this.myUnversioned.add((VirtualFile)file);
                continue;
            }
            if ('M' == status) {
                sc.boundedToken('\t');
                file = GitUtil.unescapePath(sc.line());
                VirtualFile vFile = this.myVcsRoot.findFileByRelativePath((String)file);
                if (!Comparing.equal((Object)GitUtil.gitRootOrNull(vFile), (Object)this.myVcsRoot) || !this.myUnmergedNames.add((String)file)) continue;
                ContentRevision before = GitContentRevision.createRevision(this.myVcsRoot, (String)file, (VcsRevisionNumber)new GitRevisionNumber("orig_head"), this.myProject, true);
                ContentRevision after = GitContentRevision.createRevision(this.myVcsRoot, (String)file, null, this.myProject, true);
                this.myChanges.add(new Change(before, after, FileStatus.MERGED_WITH_CONFLICTS));
                continue;
            }
            throw new VcsException("Unsupported type of the merge conflict detected: " + status);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScope";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/status/GitOldChangesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/status/GitOldChangesCollector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

