/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.impl.LocalChangesUnderRoots;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.config.UpdateMethod;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMergeCommittingConflictResolver;
import git4idea.merge.GitMerger;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.update.GitFetcher;
import git4idea.update.GitMergeUpdater;
import git4idea.update.GitRebaseOverMergeProblem;
import git4idea.update.GitRebaseUpdater;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import git4idea.util.GitPreservingProcess;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUpdateProcess {
    private static final Logger LOG = Logger.getInstance(GitUpdateProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final List<GitRepository> myRepositories;
    private final boolean myCheckRebaseOverMergeProblem;
    private final boolean myCheckForTrackedBranchExistence;
    private final UpdatedFiles myUpdatedFiles;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @NotNull
    private final GitMerger myMerger;
    @NotNull
    private final Map<GitRepository, String> mySkippedRoots;

    public GitUpdateProcess(@NotNull Project project, @Nullable ProgressIndicator progressIndicator, @NotNull Collection<GitRepository> repositories, @NotNull UpdatedFiles updatedFiles, boolean checkRebaseOverMergeProblem, boolean checkForTrackedBranchExistence) {
        if (project == null) {
            GitUpdateProcess.$$$reportNull$$$0(0);
        }
        if (repositories == null) {
            GitUpdateProcess.$$$reportNull$$$0(1);
        }
        if (updatedFiles == null) {
            GitUpdateProcess.$$$reportNull$$$0(2);
        }
        this.mySkippedRoots = new LinkedHashMap<GitRepository, String>();
        this.myProject = project;
        this.myCheckRebaseOverMergeProblem = checkRebaseOverMergeProblem;
        this.myCheckForTrackedBranchExistence = checkForTrackedBranchExistence;
        this.myGit = Git.getInstance();
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myUpdatedFiles = updatedFiles;
        this.myRepositories = GitUtil.getRepositoryManager(project).sortByDependency(repositories);
        this.myProgressIndicator = progressIndicator == null ? new EmptyProgressIndicator() : progressIndicator;
        this.myMerger = new GitMerger(this.myProject);
    }

    @NotNull
    public GitUpdateResult update(UpdateMethod updateMethod) {
        GitUpdateResult result2;
        LOG.info("update started|" + (Object)((Object)updateMethod));
        String oldText = this.myProgressIndicator.getText();
        this.myProgressIndicator.setText("Updating...");
        for (GitRepository repository : this.myRepositories) {
            repository.update();
        }
        if (this.checkRebaseInProgress() || this.isMergeInProgress() || this.areUnmergedFiles()) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOT_READY;
            if (gitUpdateResult == null) {
                GitUpdateProcess.$$$reportNull$$$0(3);
            }
            return gitUpdateResult;
        }
        Map<GitRepository, GitBranchPair> trackedBranches = this.checkTrackedBranchesConfiguration();
        if (ContainerUtil.isEmpty(trackedBranches)) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOT_READY;
            if (gitUpdateResult == null) {
                GitUpdateProcess.$$$reportNull$$$0(4);
            }
            return gitUpdateResult;
        }
        if (!this.fetchAndNotify(trackedBranches.keySet())) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOT_READY;
            if (gitUpdateResult == null) {
                GitUpdateProcess.$$$reportNull$$$0(5);
            }
            return gitUpdateResult;
        }
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)"VCS Update");){
            result2 = this.updateImpl(updateMethod);
        }
        this.myProgressIndicator.setText(oldText);
        GitUpdateResult gitUpdateResult = result2;
        if (gitUpdateResult == null) {
            GitUpdateProcess.$$$reportNull$$$0(6);
        }
        return gitUpdateResult;
    }

    @NotNull
    private GitUpdateResult updateImpl(@NotNull UpdateMethod updateMethod) {
        Collection<GitRepository> problematicRoots;
        Map<GitRepository, GitUpdater> updaters;
        Map<GitRepository, GitBranchPair> trackedBranches;
        if (updateMethod == null) {
            GitUpdateProcess.$$$reportNull$$$0(7);
        }
        if ((trackedBranches = this.checkTrackedBranchesConfiguration()) == null) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOT_READY;
            if (gitUpdateResult == null) {
                GitUpdateProcess.$$$reportNull$$$0(8);
            }
            return gitUpdateResult;
        }
        try {
            updaters = this.defineUpdaters(updateMethod, trackedBranches);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            GitUIUtil.notifyError(this.myProject, "Git update failed", e.getMessage(), true, (Exception)((Object)e));
            GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
            if (gitUpdateResult == null) {
                GitUpdateProcess.$$$reportNull$$$0(9);
            }
            return gitUpdateResult;
        }
        if (updaters.isEmpty()) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOTHING_TO_UPDATE;
            if (gitUpdateResult == null) {
                GitUpdateProcess.$$$reportNull$$$0(10);
            }
            return gitUpdateResult;
        }
        if ((updaters = this.tryFastForwardMergeForRebaseUpdaters(updaters)).isEmpty()) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.SUCCESS;
            if (gitUpdateResult == null) {
                GitUpdateProcess.$$$reportNull$$$0(11);
            }
            return gitUpdateResult;
        }
        if (this.myCheckRebaseOverMergeProblem && !(problematicRoots = this.findRootsRebasingOverMerge(updaters)).isEmpty()) {
            Object decision = GitRebaseOverMergeProblem.showDialog();
            if (decision == GitRebaseOverMergeProblem.Decision.MERGE_INSTEAD) {
                for (GitRepository repo : problematicRoots) {
                    GitBranchPair branchAndTracked = trackedBranches.get(repo);
                    if (branchAndTracked == null) {
                        LOG.error("No tracked branch information for root " + repo.getRoot());
                        continue;
                    }
                    updaters.put(repo, new GitMergeUpdater(this.myProject, this.myGit, repo, branchAndTracked, this.myProgressIndicator, this.myUpdatedFiles));
                }
            } else if (decision == GitRebaseOverMergeProblem.Decision.CANCEL_OPERATION) {
                GitUpdateResult gitUpdateResult = GitUpdateResult.CANCEL;
                if (gitUpdateResult == null) {
                    GitUpdateProcess.$$$reportNull$$$0(12);
                }
                return gitUpdateResult;
            }
        }
        ArrayList myRootsToSave = ContainerUtil.newArrayList();
        LOG.info("updateImpl: identifying if save is needed...");
        for (Map.Entry entry : updaters.entrySet()) {
            GitRepository repo;
            repo = (GitRepository)entry.getKey();
            GitUpdater updater = (GitUpdater)entry.getValue();
            if (!updater.isSaveNeeded()) continue;
            myRootsToSave.add(repo.getRoot());
            LOG.info("update| root " + repo + " needs save");
        }
        LOG.info("updateImpl: saving local changes...");
        Ref incomplete = Ref.create((Object)false);
        Ref ref = Ref.create();
        Map<GitRepository, GitUpdater> finalUpdaters = updaters;
        new GitPreservingProcess(this.myProject, this.myGit, myRootsToSave, "Update", "Remote", GitVcsSettings.getInstance(this.myProject).updateChangesPolicy(), this.myProgressIndicator, () -> {
            LOG.info("updateImpl: updating...");
            GitRepository currentlyUpdatedRoot = null;
            try {
                for (GitRepository repo : this.myRepositories) {
                    GitUpdater updater = (GitUpdater)finalUpdaters.get(repo);
                    if (updater == null) continue;
                    currentlyUpdatedRoot = repo;
                    GitUpdateResult res = updater.update();
                    LOG.info("updating root " + currentlyUpdatedRoot + " finished: " + (Object)((Object)res));
                    if (res == GitUpdateResult.INCOMPLETE) {
                        incomplete.set((Object)true);
                    }
                    compoundResult.set((Object)GitUpdateProcess.joinResults((GitUpdateResult)((Object)((Object)((Object)compoundResult.get()))), res));
                }
            }
            catch (VcsException e) {
                String rootName = currentlyUpdatedRoot == null ? "" : DvcsUtil.getShortRepositoryName(currentlyUpdatedRoot);
                LOG.info("Error updating changes for root " + currentlyUpdatedRoot, (Throwable)e);
                GitUIUtil.notifyImportantError(this.myProject, "Error updating " + rootName, "Updating " + rootName + " failed with an error: " + e.getLocalizedMessage());
            }
        }).execute((Computable<Boolean>)((Computable)() -> (Boolean)incomplete.get() == false && !compoundResult.isNull() && ((GitUpdateResult)((Object)((Object)((Object)compoundResult.get())))).isSuccess()));
        GitUpdateResult gitUpdateResult = (GitUpdateResult)((Object)ObjectUtils.notNull((Object)ref.get(), (Object)((Object)GitUpdateResult.ERROR)));
        if (gitUpdateResult == null) {
            GitUpdateProcess.$$$reportNull$$$0(13);
        }
        return gitUpdateResult;
    }

    @NotNull
    private Collection<GitRepository> findRootsRebasingOverMerge(@NotNull Map<GitRepository, GitUpdater> updaters) {
        if (updaters == null) {
            GitUpdateProcess.$$$reportNull$$$0(14);
        }
        List list = ContainerUtil.mapNotNull(updaters.keySet(), repo -> {
            GitUpdater updater;
            if (updaters == null) {
                GitUpdateProcess.$$$reportNull$$$0(36);
            }
            if ((updater = (GitUpdater)updaters.get(repo)) instanceof GitRebaseUpdater) {
                String currentRef = updater.getSourceAndTarget().getBranch().getFullName();
                String baseRef = ((GitRemoteBranch)ObjectUtils.assertNotNull((Object)updater.getSourceAndTarget().getDest())).getFullName();
                return GitRebaseOverMergeProblem.hasProblem(this.myProject, repo.getRoot(), baseRef, currentRef) ? repo : null;
            }
            return null;
        });
        if (list == null) {
            GitUpdateProcess.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    private Map<GitRepository, GitUpdater> tryFastForwardMergeForRebaseUpdaters(@NotNull Map<GitRepository, GitUpdater> updaters) {
        if (updaters == null) {
            GitUpdateProcess.$$$reportNull$$$0(16);
        }
        HashMap<GitRepository, GitUpdater> modifiedUpdaters = new HashMap<GitRepository, GitUpdater>();
        Map changesUnderRoots = new LocalChangesUnderRoots(this.myChangeListManager, this.myVcsManager).getChangesUnderRoots(GitUtil.getRootsFromRepositories(updaters.keySet()));
        for (GitRepository repository : this.myRepositories) {
            GitRebaseUpdater rebaseUpdater;
            GitUpdater updater = updaters.get(repository);
            if (updater == null) continue;
            Collection changes = (Collection)changesUnderRoots.get(repository.getRoot());
            LOG.debug("Changes under root '" + DvcsUtil.getShortRepositoryName((Repository)repository) + "': " + changes);
            if (updater instanceof GitRebaseUpdater && changes != null && !changes.isEmpty() && (rebaseUpdater = (GitRebaseUpdater)updater).fastForwardMerge()) continue;
            modifiedUpdaters.put(repository, updater);
        }
        HashMap<GitRepository, GitUpdater> hashMap = modifiedUpdaters;
        if (hashMap == null) {
            GitUpdateProcess.$$$reportNull$$$0(17);
        }
        return hashMap;
    }

    @NotNull
    private Map<GitRepository, GitUpdater> defineUpdaters(@NotNull UpdateMethod updateMethod, @NotNull Map<GitRepository, GitBranchPair> trackedBranches) throws VcsException {
        if (updateMethod == null) {
            GitUpdateProcess.$$$reportNull$$$0(18);
        }
        if (trackedBranches == null) {
            GitUpdateProcess.$$$reportNull$$$0(19);
        }
        HashMap<GitRepository, GitUpdater> updaters = new HashMap<GitRepository, GitUpdater>();
        LOG.info("updateImpl: defining updaters...");
        for (GitRepository repository : this.myRepositories) {
            GitBranchPair branchAndTracked = trackedBranches.get(repository);
            if (branchAndTracked == null) continue;
            GitUpdater updater = GitUpdater.getUpdater(this.myProject, this.myGit, branchAndTracked, repository, this.myProgressIndicator, this.myUpdatedFiles, updateMethod);
            if (updater.isUpdateNeeded()) {
                updaters.put(repository, updater);
            }
            LOG.info("update| root=" + repository.getRoot() + " ,updater=" + updater);
        }
        HashMap<GitRepository, GitUpdater> hashMap = updaters;
        if (hashMap == null) {
            GitUpdateProcess.$$$reportNull$$$0(20);
        }
        return hashMap;
    }

    @NotNull
    Map<GitRepository, String> getSkippedRoots() {
        Map<GitRepository, String> map2 = this.mySkippedRoots;
        if (map2 == null) {
            GitUpdateProcess.$$$reportNull$$$0(21);
        }
        return map2;
    }

    @NotNull
    private static GitUpdateResult joinResults(@Nullable GitUpdateResult compoundResult, GitUpdateResult result2) {
        if (compoundResult == null) {
            GitUpdateResult gitUpdateResult = result2;
            if (gitUpdateResult == null) {
                GitUpdateProcess.$$$reportNull$$$0(22);
            }
            return gitUpdateResult;
        }
        GitUpdateResult gitUpdateResult = compoundResult.join(result2);
        if (gitUpdateResult == null) {
            GitUpdateProcess.$$$reportNull$$$0(23);
        }
        return gitUpdateResult;
    }

    private boolean fetchAndNotify(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitUpdateProcess.$$$reportNull$$$0(24);
        }
        return new GitFetcher(this.myProject, this.myProgressIndicator, false).fetchRootsAndNotify(repositories, "Update failed", false);
    }

    @Nullable
    private Map<GitRepository, GitBranchPair> checkTrackedBranchesConfiguration() {
        LOG.info("checking tracked branch configuration...");
        LinkedHashMap currentBranches = ContainerUtil.newLinkedHashMap();
        ArrayList detachedHeads = ContainerUtil.newArrayList();
        for (GitRepository repository : this.myRepositories) {
            GitLocalBranch branch = repository.getCurrentBranch();
            if (branch != null) {
                currentBranches.put(repository, branch);
                continue;
            }
            detachedHeads.add(repository);
            LOG.info("checkTrackedBranchesConfigured: current branch is null in " + repository);
        }
        if (currentBranches.isEmpty() || this.isSyncControl() && currentBranches.size() < this.myRepositories.size()) {
            GitUpdateProcess.notifyDetachedHeadError((GitRepository)detachedHeads.get(0));
            return null;
        }
        for (GitRepository repo : detachedHeads) {
            this.mySkippedRoots.put(repo, "detached HEAD");
        }
        LinkedHashMap trackedBranches = ContainerUtil.newLinkedHashMap();
        ArrayList noTrackedBranch = ContainerUtil.newArrayList();
        for (GitRepository repository : currentBranches.keySet()) {
            GitLocalBranch branch;
            GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, branch = (GitLocalBranch)currentBranches.get(repository));
            if (trackInfo != null) {
                trackedBranches.put(repository, new GitBranchPair(branch, trackInfo.getRemoteBranch()));
                continue;
            }
            noTrackedBranch.add(repository);
            LOG.info(String.format("checkTrackedBranchesConfiguration: no track info for current branch %s in %s", branch, repository));
        }
        if (this.myCheckForTrackedBranchExistence && (trackedBranches.isEmpty() || this.isSyncControl() && trackedBranches.size() < this.myRepositories.size())) {
            GitRepository repo = (GitRepository)noTrackedBranch.get(0);
            GitUpdateProcess.notifyNoTrackedBranchError(repo, (GitLocalBranch)currentBranches.get(repo));
            return null;
        }
        for (GitRepository repo : noTrackedBranch) {
            this.mySkippedRoots.put(repo, "no tracked branch");
        }
        return trackedBranches;
    }

    private static void notifyNoTrackedBranchError(@NotNull GitRepository repository, @NotNull GitLocalBranch currentBranch) {
        if (repository == null) {
            GitUpdateProcess.$$$reportNull$$$0(25);
        }
        if (currentBranch == null) {
            GitUpdateProcess.$$$reportNull$$$0(26);
        }
        GitUIUtil.notifyImportantError(repository.getProject(), "Can't Update", GitUpdateProcess.getNoTrackedBranchError(repository, currentBranch.getName()));
    }

    private static void notifyDetachedHeadError(@NotNull GitRepository repository) {
        if (repository == null) {
            GitUpdateProcess.$$$reportNull$$$0(27);
        }
        GitUIUtil.notifyImportantError(repository.getProject(), "Can't Update: No Current Branch", GitUpdateProcess.getDetachedHeadErrorNotificationContent(repository));
    }

    @VisibleForTesting
    @NotNull
    static String getDetachedHeadErrorNotificationContent(@NotNull GitRepository repository) {
        if (repository == null) {
            GitUpdateProcess.$$$reportNull$$$0(28);
        }
        String string = "You are in 'detached HEAD' state, which means that you're not on any branch" + GitUtil.mention(repository) + "<br/>Checkout a branch to make update possible.";
        if (string == null) {
            GitUpdateProcess.$$$reportNull$$$0(29);
        }
        return string;
    }

    private boolean isSyncControl() {
        return GitVcsSettings.getInstance(this.myProject).getSyncSetting() == DvcsSyncSettings.Value.SYNC;
    }

    @VisibleForTesting
    @NotNull
    static String getNoTrackedBranchError(@NotNull GitRepository repository, @NotNull String branchName) {
        if (repository == null) {
            GitUpdateProcess.$$$reportNull$$$0(30);
        }
        if (branchName == null) {
            GitUpdateProcess.$$$reportNull$$$0(31);
        }
        String recommendedCommand = GitUpdateProcess.recommendSetupTrackingCommand(repository, branchName);
        String string = "No tracked branch configured for branch " + GitUIUtil.code(branchName) + GitUtil.mention(repository) + " or the branch doesn't exist.<br/>To make your branch track a remote branch call, for example,<br/><code>" + recommendedCommand + "</code>";
        if (string == null) {
            GitUpdateProcess.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    private static String recommendSetupTrackingCommand(@NotNull GitRepository repository, @NotNull String branchName) {
        if (repository == null) {
            GitUpdateProcess.$$$reportNull$$$0(33);
        }
        if (branchName == null) {
            GitUpdateProcess.$$$reportNull$$$0(34);
        }
        String string = String.format(GitVersionSpecialty.KNOWS_SET_UPSTREAM_TO.existsIn(repository) ? "git branch --set-upstream-to=origin/%1$s %1$s" : "git branch --set-upstream %1$s origin/%1$s", branchName);
        if (string == null) {
            GitUpdateProcess.$$$reportNull$$$0(35);
        }
        return string;
    }

    private boolean isMergeInProgress() {
        LOG.info("isMergeInProgress: checking if there is an unfinished merge process...");
        Collection<VirtualFile> mergingRoots = this.myMerger.getMergingRoots();
        if (mergingRoots.isEmpty()) {
            return false;
        }
        LOG.info("isMergeInProgress: roots with unfinished merge: " + mergingRoots);
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject);
        params.setErrorNotificationTitle("Can't update");
        params.setMergeDescription("You have unfinished merge. These conflicts must be resolved before update.");
        return !new GitMergeCommittingConflictResolver(this.myProject, this.myGit, this.myMerger, mergingRoots, params, false).merge();
    }

    private boolean areUnmergedFiles() {
        LOG.info("areUnmergedFiles: checking if there are unmerged files...");
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject);
        params.setErrorNotificationTitle("Update was not started");
        params.setMergeDescription("Unmerged files detected. These conflicts must be resolved before update.");
        return !new GitMergeCommittingConflictResolver(this.myProject, this.myGit, this.myMerger, GitUtil.getRootsFromRepositories(this.myRepositories), params, false).merge();
    }

    private boolean checkRebaseInProgress() {
        LOG.info("checkRebaseInProgress: checking if there is an unfinished rebase process...");
        final GitRebaser rebaser = new GitRebaser(this.myProject, this.myGit, this.myProgressIndicator);
        final Collection<VirtualFile> rebasingRoots = rebaser.getRebasingRoots();
        if (rebasingRoots.isEmpty()) {
            return false;
        }
        LOG.info("checkRebaseInProgress: roots with unfinished rebase: " + rebasingRoots);
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject);
        params.setErrorNotificationTitle("Can't update");
        params.setMergeDescription("You have unfinished rebase process. These conflicts must be resolved before update.");
        params.setErrorNotificationAdditionalDescription("Then you may <b>continue rebase</b>. <br/> You also may <b>abort rebase</b> to restore the original branch and stop rebasing.");
        params.setReverse(true);
        return !new GitConflictResolver(this.myProject, this.myGit, rebasingRoots, params){

            @Override
            protected boolean proceedIfNothingToMerge() {
                return rebaser.continueRebase(rebasingRoots);
            }

            @Override
            protected boolean proceedAfterAllMerged() {
                return rebaser.continueRebase(rebasingRoots);
            }
        }.merge();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 32: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 32: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedFiles";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/update/GitUpdateProcess";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateMethod";
                break;
            }
            case 14: 
            case 16: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updaters";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackedBranches";
                break;
            }
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBranch";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/update/GitUpdateProcess";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "updateImpl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findRootsRebasingOverMerge";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "tryFastForwardMergeForRebaseUpdaters";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "defineUpdaters";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkippedRoots";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "joinResults";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetachedHeadErrorNotificationContent";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoTrackedBranchError";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "recommendSetupTrackingCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 32: 
            case 35: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateImpl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findRootsRebasingOverMerge";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tryFastForwardMergeForRebaseUpdaters";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "defineUpdaters";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fetchAndNotify";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "notifyNoTrackedBranchError";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "notifyDetachedHeadError";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDetachedHeadErrorNotificationContent";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getNoTrackedBranchError";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "recommendSetupTrackingCommand";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findRootsRebasingOverMerge$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 32: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

