/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import org.carrot2.text.analysis.TokenTypeUtils;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.util.CharArrayUtils;
import org.carrot2.util.attribute.Bindable;

@Bindable
public class LabelFormatter {
    public String format(PreprocessingContext context, int featureIndex) {
        char[][] wordsImage = context.allWords.image;
        int[][] phrasesWordIndices = context.allPhrases.wordIndices;
        int wordCount = wordsImage.length;
        StringBuilder label = new StringBuilder();
        if (featureIndex < wordCount) {
            char[] image = wordsImage[featureIndex];
            LabelFormatter.appendFormatted(label, image, true, false);
        } else {
            boolean insertSpace = context.language.getLanguageCode().usesSpaceDelimiters();
            int[] wordIndices = phrasesWordIndices[featureIndex - wordCount];
            short[] termTypes = context.allWords.type;
            for (int i = 0; i < wordIndices.length; ++i) {
                if (insertSpace && i > 0) {
                    label.append(' ');
                }
                int wordIndex = wordIndices[i];
                LabelFormatter.appendFormatted(label, wordsImage[wordIndex], i == 0, TokenTypeUtils.isCommon(termTypes[wordIndex]));
            }
        }
        return label.toString();
    }

    public static String format(char[][] image, boolean[] stopWord, boolean joinWithSpace) {
        StringBuilder label = new StringBuilder();
        if (image.length == 1) {
            LabelFormatter.appendFormatted(label, image[0], true, stopWord[0]);
        } else {
            for (int i = 0; i < image.length; ++i) {
                LabelFormatter.appendFormatted(label, image[i], i == 0, stopWord[i]);
                if (!joinWithSpace || i >= image.length - 1) continue;
                label.append(' ');
            }
        }
        return label.toString();
    }

    private static void appendFormatted(StringBuilder label, char[] image, boolean isFirst, boolean isCommon) {
        if (CharArrayUtils.hasCapitalizedLetters(image)) {
            label.append(image);
        } else if (isFirst) {
            label.append(CharArrayUtils.toCapitalizedCopy(image));
        } else if (isCommon) {
            label.append(CharArrayUtils.toLowerCaseCopy(image));
        } else {
            label.append(CharArrayUtils.toCapitalizedCopy(image));
        }
    }
}

