/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherBlipRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.extractor.OldExcelExtractor;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.record.FooterRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.HeaderRecord;
import org.apache.poi.hssf.record.HyperlinkRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.record.chart.SeriesTextRecord;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.parser.microsoft.Cell;
import org.apache.tika.parser.microsoft.LinkedCell;
import org.apache.tika.parser.microsoft.NumberCell;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.parser.microsoft.OldExcelParser;
import org.apache.tika.parser.microsoft.TextCell;
import org.apache.tika.parser.microsoft.TikaExcelDataFormatter;
import org.apache.tika.parser.microsoft.TikaExcelGeneralFormat;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

public class ExcelExtractor
extends AbstractPOIFSExtractor {
    private static final String WORKBOOK_ENTRY = "Workbook";
    private static final String BOOK_ENTRY = "Book";
    private boolean listenForAllRecords = false;

    public ExcelExtractor(ParseContext context, Metadata metadata) {
        super(context, metadata);
    }

    public boolean isListenForAllRecords() {
        return this.listenForAllRecords;
    }

    public void setListenForAllRecords(boolean listenForAllRecords) {
        this.listenForAllRecords = listenForAllRecords;
    }

    protected void parse(NPOIFSFileSystem filesystem, XHTMLContentHandler xhtml, Locale locale) throws IOException, SAXException, TikaException {
        this.parse(filesystem.getRoot(), xhtml, locale);
    }

    protected void parse(DirectoryNode root, XHTMLContentHandler xhtml, Locale locale) throws IOException, SAXException, TikaException {
        if (!root.hasEntry(WORKBOOK_ENTRY)) {
            if (root.hasEntry(BOOK_ENTRY)) {
                OldExcelExtractor extractor = new OldExcelExtractor(root);
                OldExcelParser.parse(extractor, xhtml);
                return;
            }
            return;
        }
        Biff8EncryptionKey.setCurrentUserPassword((String)this.getPassword());
        TikaHSSFListener listener = new TikaHSSFListener(xhtml, locale, this, this.officeParserConfig);
        listener.processFile(root, this.isListenForAllRecords());
        listener.throwStoredException();
        for (Entry entry : root) {
            if (!entry.getName().startsWith("MBD") || !(entry instanceof DirectoryEntry)) continue;
            try {
                this.handleEmbeddedOfficeDoc((DirectoryEntry)entry, xhtml);
            }
            catch (TikaException tikaException) {}
        }
    }

    private static class PointComparator
    implements Comparator<Point> {
        private PointComparator() {
        }

        @Override
        public int compare(Point a, Point b) {
            int diff = a.y - b.y;
            if (diff == 0) {
                diff = a.x - b.x;
            }
            return diff;
        }
    }

    private static class TikaHSSFListener
    implements HSSFListener {
        private final XHTMLContentHandler handler;
        private final AbstractPOIFSExtractor extractor;
        private final NumberFormat format;
        private final OfficeParserConfig officeParserConfig;
        private Exception exception = null;
        private SSTRecord sstRecord;
        private FormulaRecord stringFormulaRecord;
        private short previousSid;
        private FormatTrackingHSSFListener formatListener;
        private final TikaExcelDataFormatter tikaExcelDataFormatter;
        private List<String> sheetNames = new ArrayList<String>();
        private short currentSheetIndex;
        private SortedMap<Point, Cell> currentSheet = null;
        private List<Cell> extraTextCells = new ArrayList<Cell>();
        private List<DrawingGroupRecord> drawingGroups = new ArrayList<DrawingGroupRecord>();

        private TikaHSSFListener(XHTMLContentHandler handler, Locale locale, AbstractPOIFSExtractor extractor, OfficeParserConfig officeParserConfig) {
            this.handler = handler;
            this.extractor = extractor;
            this.format = NumberFormat.getInstance(locale);
            this.formatListener = new TikaFormatTrackingHSSFListener(this, locale);
            this.tikaExcelDataFormatter = new TikaExcelDataFormatter(locale);
            this.officeParserConfig = officeParserConfig;
        }

        public void processFile(NPOIFSFileSystem filesystem, boolean listenForAllRecords) throws IOException, SAXException, TikaException {
            this.processFile(filesystem.getRoot(), listenForAllRecords);
        }

        public void processFile(DirectoryNode root, boolean listenForAllRecords) throws IOException, SAXException, TikaException {
            HSSFRequest hssfRequest = new HSSFRequest();
            if (listenForAllRecords) {
                hssfRequest.addListenerForAllRecords((HSSFListener)this.formatListener);
            } else {
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)2057);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)10);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)34);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)140);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)133);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)252);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)6);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)516);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)253);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)515);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)638);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)519);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)440);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)438);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)4109);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)1054);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)224);
                hssfRequest.addListener((HSSFListener)this.formatListener, (short)235);
                if (this.extractor.officeParserConfig.getIncludeHeadersAndFooters()) {
                    hssfRequest.addListener((HSSFListener)this.formatListener, (short)20);
                    hssfRequest.addListener((HSSFListener)this.formatListener, (short)21);
                }
            }
            DocumentInputStream documentInputStream = root.createDocumentInputStream(ExcelExtractor.WORKBOOK_ENTRY);
            HSSFEventFactory eventFactory = new HSSFEventFactory();
            try {
                eventFactory.processEvents(hssfRequest, (InputStream)documentInputStream);
            }
            catch (EncryptedDocumentException e) {
                throw new org.apache.tika.exception.EncryptedDocumentException((Throwable)e);
            }
            this.processExtraText();
            for (DrawingGroupRecord dgr : this.drawingGroups) {
                dgr.decode();
                this.findPictures(dgr.getEscherRecords());
            }
        }

        public void processRecord(Record record) {
            if (this.exception == null) {
                try {
                    this.internalProcessRecord(record);
                }
                catch (TikaException te) {
                    this.exception = te;
                }
                catch (IOException ie) {
                    this.exception = ie;
                }
                catch (SAXException se) {
                    this.exception = se;
                }
            }
        }

        public void throwStoredException() throws TikaException, SAXException, IOException {
            if (this.exception != null) {
                if (this.exception instanceof IOException) {
                    throw (IOException)this.exception;
                }
                if (this.exception instanceof SAXException) {
                    throw (SAXException)this.exception;
                }
                if (this.exception instanceof TikaException) {
                    throw (TikaException)((Object)this.exception);
                }
                throw new TikaException(this.exception.getMessage());
            }
        }

        private void internalProcessRecord(Record record) throws SAXException, TikaException, IOException {
            switch (record.getSid()) {
                case 2057: {
                    BOFRecord bof = (BOFRecord)record;
                    if (bof.getType() == 5) {
                        this.currentSheetIndex = (short)-1;
                        break;
                    }
                    if (bof.getType() == 32) {
                        if (this.previousSid == 10) {
                            this.newSheet();
                            break;
                        }
                        if (this.currentSheet == null) break;
                        this.processSheet();
                        this.currentSheetIndex = (short)(this.currentSheetIndex - 1);
                        this.newSheet();
                        break;
                    }
                    if (bof.getType() != 16) break;
                    this.newSheet();
                    break;
                }
                case 10: {
                    if (this.currentSheet != null) {
                        this.processSheet();
                    }
                    this.currentSheet = null;
                    break;
                }
                case 133: {
                    BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
                    this.sheetNames.add(boundSheetRecord.getSheetname());
                    break;
                }
                case 252: {
                    this.sstRecord = (SSTRecord)record;
                    break;
                }
                case 6: {
                    FormulaRecord formula = (FormulaRecord)record;
                    if (formula.hasCachedResultString()) {
                        this.stringFormulaRecord = formula;
                        break;
                    }
                    this.addTextCell(record, this.formatListener.formatNumberDateCell((CellValueRecordInterface)formula));
                    break;
                }
                case 519: {
                    if (this.previousSid != 6) break;
                    StringRecord sr = (StringRecord)record;
                    this.addTextCell((Record)this.stringFormulaRecord, sr.getString());
                    break;
                }
                case 516: {
                    LabelRecord label = (LabelRecord)record;
                    this.addTextCell(record, label.getValue());
                    break;
                }
                case 253: {
                    LabelSSTRecord sst = (LabelSSTRecord)record;
                    UnicodeString unicode = this.sstRecord.getString(sst.getSSTIndex());
                    String cellString = null;
                    if (this.officeParserConfig.getConcatenatePhoneticRuns()) {
                        String phonetic = unicode != null && unicode.getExtendedRst() != null && unicode.getExtendedRst().getPhoneticText() != null && unicode.getExtendedRst().getPhoneticText().trim().length() > 0 ? unicode.getExtendedRst().getPhoneticText() : "";
                        cellString = unicode.getString() + " " + phonetic;
                    } else {
                        cellString = unicode.getString();
                    }
                    this.addTextCell(record, cellString);
                    break;
                }
                case 515: {
                    NumberRecord number = (NumberRecord)record;
                    this.addTextCell(record, this.formatListener.formatNumberDateCell((CellValueRecordInterface)number));
                    break;
                }
                case 638: {
                    RKRecord rk = (RKRecord)record;
                    this.addCell(record, new NumberCell(rk.getRKNumber(), this.format));
                    break;
                }
                case 440: {
                    HyperlinkRecord link;
                    Point point;
                    Cell cell;
                    if (this.currentSheet == null || (cell = (Cell)this.currentSheet.get(point = new Point((link = (HyperlinkRecord)record).getFirstColumn(), link.getFirstRow()))) == null) break;
                    String address = link.getAddress();
                    if (address != null) {
                        this.addCell(record, new LinkedCell(cell, address));
                        break;
                    }
                    this.addCell(record, cell);
                    break;
                }
                case 438: {
                    if (!this.extractor.officeParserConfig.getIncludeShapeBasedContent()) break;
                    TextObjectRecord tor = (TextObjectRecord)record;
                    this.addTextCell(record, tor.getStr().getString());
                    break;
                }
                case 4109: {
                    SeriesTextRecord str = (SeriesTextRecord)record;
                    this.addTextCell(record, str.getText());
                    break;
                }
                case 235: {
                    this.drawingGroups.add((DrawingGroupRecord)record);
                    break;
                }
                case 20: {
                    if (!this.extractor.officeParserConfig.getIncludeHeadersAndFooters()) break;
                    HeaderRecord headerRecord = (HeaderRecord)record;
                    this.addTextCell(record, headerRecord.getText());
                    break;
                }
                case 21: {
                    if (!this.extractor.officeParserConfig.getIncludeHeadersAndFooters()) break;
                    FooterRecord footerRecord = (FooterRecord)record;
                    this.addTextCell(record, footerRecord.getText());
                }
            }
            this.previousSid = record.getSid();
            if (this.stringFormulaRecord != record) {
                this.stringFormulaRecord = null;
            }
        }

        private void processExtraText() throws SAXException {
            if (this.extraTextCells.size() > 0) {
                for (Cell cell : this.extraTextCells) {
                    this.handler.startElement("div", "class", "outside");
                    cell.render(this.handler);
                    this.handler.endElement("div");
                }
                this.extraTextCells.clear();
            }
        }

        private void addCell(Record record, Cell cell) throws SAXException {
            if (cell != null) {
                if (this.currentSheet != null && record instanceof CellValueRecordInterface) {
                    CellValueRecordInterface value = (CellValueRecordInterface)record;
                    Point point = new Point(value.getColumn(), value.getRow());
                    if (this.currentSheet.containsKey(point)) {
                        this.extraTextCells.add(cell);
                    } else {
                        this.currentSheet.put(point, cell);
                    }
                } else {
                    this.extraTextCells.add(cell);
                }
            }
        }

        private void addTextCell(Record record, String text) throws SAXException {
            if (text != null && (text = text.trim()).length() > 0) {
                this.addCell(record, new TextCell(text));
            }
        }

        private void newSheet() {
            this.currentSheetIndex = (short)(this.currentSheetIndex + 1);
            this.currentSheet = new TreeMap<Point, Cell>(new PointComparator());
        }

        private void processSheet() throws SAXException {
            this.handler.startElement("div", "class", "page");
            if (this.currentSheetIndex < this.sheetNames.size()) {
                this.handler.element("h1", this.sheetNames.get(this.currentSheetIndex));
            }
            this.handler.startElement("table");
            this.handler.startElement("tbody");
            int currentRow = 0;
            int currentColumn = 0;
            this.handler.startElement("tr");
            this.handler.startElement("td");
            for (Map.Entry<Point, Cell> entry : this.currentSheet.entrySet()) {
                while (currentRow < entry.getKey().y) {
                    this.handler.endElement("td");
                    this.handler.endElement("tr");
                    this.handler.startElement("tr");
                    this.handler.startElement("td");
                    ++currentRow;
                    currentColumn = 0;
                }
                while (currentColumn < entry.getKey().x) {
                    this.handler.endElement("td");
                    this.handler.startElement("td");
                    ++currentColumn;
                }
                entry.getValue().render(this.handler);
            }
            this.handler.endElement("td");
            this.handler.endElement("tr");
            this.handler.endElement("tbody");
            this.handler.endElement("table");
            this.processExtraText();
            this.handler.endElement("div");
        }

        private void findPictures(List<EscherRecord> records) throws IOException, SAXException, TikaException {
            for (EscherRecord escherRecord : records) {
                EscherBlipRecord blip;
                if (escherRecord instanceof EscherBSERecord && (blip = ((EscherBSERecord)escherRecord).getBlipRecord()) != null) {
                    HSSFPictureData picture = new HSSFPictureData(blip);
                    String mimeType = picture.getMimeType();
                    TikaInputStream stream = TikaInputStream.get((byte[])picture.getData());
                    this.extractor.handleEmbeddedResource(stream, null, null, mimeType, this.handler, true);
                }
                this.findPictures(escherRecord.getChildRecords());
            }
        }

        private class TikaFormatTrackingHSSFListener
        extends FormatTrackingHSSFListener {
            final TikaExcelGeneralFormat generalFormat;

            public TikaFormatTrackingHSSFListener(HSSFListener childListener, Locale locale) {
                super(childListener, locale);
                this.generalFormat = new TikaExcelGeneralFormat(locale);
            }

            public void processRecord(Record record) {
                super.processRecord(record);
            }

            public String formatNumberDateCell(CellValueRecordInterface cell) {
                double value;
                String formatString = this.getFormatString(cell);
                if (formatString != null && !formatString.equals("General")) {
                    return super.formatNumberDateCell(cell);
                }
                if (cell instanceof NumberRecord) {
                    value = ((NumberRecord)cell).getValue();
                } else {
                    if (!(cell instanceof FormulaRecord)) {
                        throw new IllegalArgumentException("Unsupported CellValue Record passed in " + cell);
                    }
                    value = ((FormulaRecord)cell).getValue();
                }
                return this.generalFormat.format(value);
            }
        }
    }
}

