/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.cloud.autoscaling.AutoScaling;
import org.apache.solr.cloud.autoscaling.TriggerBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.cloud.autoscaling.TriggerUtils;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.DateMathParser;
import org.apache.solr.util.TimeZoneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledTrigger
extends TriggerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DEFAULT_GRACE_DURATION = "+15MINUTES";
    private static final String LAST_RUN_AT = "lastRunAt";
    static final String ACTUAL_EVENT_TIME = "actualEventTime";
    private String everyStr;
    private String graceDurationStr;
    private String preferredOp;
    private TimeZone timeZone;
    private Instant lastRunAt;

    public ScheduledTrigger(String name) {
        super(TriggerEventType.SCHEDULED, name);
        TriggerUtils.requiredProperties(this.requiredProperties, this.validProperties, "startTime");
        TriggerUtils.validProperties(this.validProperties, "timeZone", "every", "graceDuration", "preferredOperation");
    }

    @Override
    public void configure(SolrResourceLoader loader, SolrCloudManager cloudManager, Map<String, Object> properties) throws TriggerValidationException {
        super.configure(loader, cloudManager, properties);
        String timeZoneStr = (String)properties.get("timeZone");
        this.timeZone = TimeZoneUtils.parseTimezone(timeZoneStr);
        String startTimeStr = (String)properties.get("startTime");
        this.everyStr = (String)properties.get("every");
        this.graceDurationStr = (String)properties.getOrDefault("graceDuration", DEFAULT_GRACE_DURATION);
        this.preferredOp = (String)properties.get("preferredOperation");
        Date now = new Date(TimeUnit.NANOSECONDS.toMillis(cloudManager.getTimeSource().getEpochTimeNs()));
        Instant startTime = this.parseStartTime(now, startTimeStr, timeZoneStr);
        DateMathParser.parseMath(now, startTime + this.everyStr, this.timeZone);
        DateMathParser.parseMath(now, startTime + this.graceDurationStr, this.timeZone);
        this.lastRunAt = startTime;
    }

    private Instant parseStartTime(Date now, String startTimeStr, String timeZoneStr) throws TriggerValidationException {
        try {
            return DateMathParser.parseMath(now, startTimeStr).toInstant();
        }
        catch (SolrException e) {
            if (e.code() != SolrException.ErrorCode.BAD_REQUEST.code) {
                throw new TriggerValidationException("startTime", "error parsing value '" + startTimeStr + "': " + e.toString());
            }
            if (timeZoneStr == null) {
                throw new TriggerValidationException("timeZone", "Either 'startTime' should be an ISO-8601 date time string or 'timeZone' must be not be null");
            }
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneStr);
            DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendPattern("['T'[HH[:mm[:ss]]]]").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter(Locale.ROOT).withZone(timeZone.toZoneId());
            try {
                return Instant.from(dateTimeFormatter.parse(startTimeStr));
            }
            catch (Exception e2) {
                throw new TriggerValidationException("startTime", "error parsing startTime '" + startTimeStr + "': " + e2.toString());
            }
        }
    }

    @Override
    protected Map<String, Object> getState() {
        return Collections.singletonMap(LAST_RUN_AT, this.lastRunAt.toEpochMilli());
    }

    @Override
    protected void setState(Map<String, Object> state) {
        if (state.containsKey(LAST_RUN_AT)) {
            this.lastRunAt = Instant.ofEpochMilli((Long)state.get(LAST_RUN_AT));
        }
    }

    @Override
    public void restoreState(AutoScaling.Trigger old) {
        assert (old.isClosed());
        if (!(old instanceof ScheduledTrigger)) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Unable to restore state from an unknown type of trigger");
        }
        ScheduledTrigger scheduledTrigger = (ScheduledTrigger)old;
        this.lastRunAt = scheduledTrigger.lastRunAt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Instant nextRunTime;
        Instant nextPlusGrace;
        ScheduledTrigger scheduledTrigger = this;
        synchronized (scheduledTrigger) {
            if (this.isClosed) {
                log.warn("ScheduledTrigger ran but was already closed");
                throw new RuntimeException("Trigger has been closed");
            }
        }
        TimeSource timeSource = this.cloudManager.getTimeSource();
        DateMathParser dateMathParser = new DateMathParser(this.timeZone);
        dateMathParser.setNow(new Date(this.lastRunAt.toEpochMilli()));
        try {
            Date next = dateMathParser.parseMath(this.everyStr);
            dateMathParser.setNow(next);
            nextPlusGrace = dateMathParser.parseMath(this.graceDurationStr).toInstant();
            nextRunTime = next.toInstant();
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to calculate next run time. lastRan: " + this.lastRunAt.toString() + " and date math string: " + this.everyStr, (Throwable)e);
        }
        Instant now = Instant.ofEpochMilli(TimeUnit.NANOSECONDS.toMillis(timeSource.getEpochTimeNs()));
        AutoScaling.TriggerEventProcessor processor = (AutoScaling.TriggerEventProcessor)this.processorRef.get();
        if (now.isBefore(nextRunTime)) {
            return;
        }
        if (now.isAfter(nextPlusGrace)) {
            if (log.isWarnEnabled()) {
                log.warn("ScheduledTrigger was not able to run event at scheduled time: {}. Now: {}", (Object)nextRunTime, (Object)now);
            }
            if (processor != null && processor.process(new ScheduledEvent(this.getEventType(), this.getName(), timeSource.getTimeNs(), this.preferredOp, now.toEpochMilli(), true))) {
                this.lastRunAt = nextRunTime;
                return;
            }
        }
        if (processor != null) {
            if (log.isDebugEnabled()) {
                log.debug("ScheduledTrigger {} firing registered processor for scheduled time {}, now={}", new Object[]{this.name, nextRunTime, now});
            }
            if (processor.process(new ScheduledEvent(this.getEventType(), this.getName(), timeSource.getTimeNs(), this.preferredOp, now.toEpochMilli()))) {
                this.lastRunAt = nextRunTime;
            }
        } else {
            this.lastRunAt = nextRunTime;
        }
    }

    public static class ScheduledEvent
    extends TriggerEvent {
        public ScheduledEvent(TriggerEventType eventType, String source, long eventTime, String preferredOp, long actualEventTime) {
            this(eventType, source, eventTime, preferredOp, actualEventTime, false);
        }

        public ScheduledEvent(TriggerEventType eventType, String source, long eventTime, String preferredOp, long actualEventTime, boolean ignored) {
            super(eventType, source, eventTime, null, ignored);
            if (preferredOp != null) {
                this.properties.put("preferredOperation", preferredOp);
            }
            this.properties.put(ScheduledTrigger.ACTUAL_EVENT_TIME, actualEventTime);
        }
    }
}

