/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import org.apache.lucene.search.Query;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.ResultContext;
import org.apache.solr.search.DocList;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;

public class BasicResultContext
extends ResultContext {
    private DocList docList;
    private ReturnFields returnFields;
    private SolrIndexSearcher searcher;
    private Query query;
    private SolrQueryRequest req;

    public BasicResultContext(DocList docList, ReturnFields returnFields, SolrIndexSearcher searcher, Query query, SolrQueryRequest req) {
        this.docList = docList;
        this.returnFields = returnFields;
        this.searcher = searcher;
        this.query = query;
        this.req = req;
    }

    public BasicResultContext(ResponseBuilder rb) {
        this(rb.getResults().docList, rb.rsp.getReturnFields(), null, rb.getQuery(), rb.req);
    }

    public BasicResultContext(ResponseBuilder rb, DocList docList) {
        this(docList, rb.rsp.getReturnFields(), null, rb.getQuery(), rb.req);
    }

    @Override
    public DocList getDocList() {
        return this.docList;
    }

    @Override
    public ReturnFields getReturnFields() {
        return this.returnFields;
    }

    @Override
    public SolrIndexSearcher getSearcher() {
        if (this.searcher != null) {
            return this.searcher;
        }
        if (this.req != null) {
            return this.req.getSearcher();
        }
        return null;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public SolrQueryRequest getRequest() {
        return this.req;
    }
}

