/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.function.mapping.ComparisonFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.DateValue;

class CompareDateValueFunction
extends BooleanValue.AbstractBooleanValue {
    private final DateValue exprA;
    private final DateValue exprB;
    private final ComparisonFunction.CompResultFunction comp;
    private final String name;
    private final String funcStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    private boolean exists = false;

    public CompareDateValueFunction(String name, DateValue exprA, DateValue exprB, ComparisonFunction.CompResultFunction comp) {
        this.name = name;
        this.exprA = exprA;
        this.exprB = exprB;
        this.comp = comp;
        this.funcStr = AnalyticsValueStream.createExpressionString(name, exprA, exprB);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, exprA, exprB);
    }

    @Override
    public boolean getBoolean() {
        long valueA = this.exprA.getLong();
        long valueB = this.exprB.getLong();
        this.exists = this.exprA.exists() && this.exprB.exists();
        return this.exists ? this.comp.apply(Long.compare(valueA, valueB)) : false;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.funcStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

