/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PowerEvaluator
extends RecursiveNumericEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public PowerEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (null == first || null == second) {
            return null;
        }
        if (first instanceof Number) {
            Number value = (Number)first;
            Number exponent = (Number)second;
            return Math.pow(value.doubleValue(), exponent.doubleValue());
        }
        List values = (List)first;
        Number exponent = (Number)second;
        ArrayList<Double> out = new ArrayList<Double>(values.size());
        for (Number value : values) {
            out.add(Math.pow(value.doubleValue(), exponent.doubleValue()));
        }
        return out;
    }
}

