/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.runtime;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;

class HelperClassLoader
extends URLClassLoader {
    HelperClassLoader() {
        super(new URL[0]);
    }

    HelperClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    final void addDirectoriesFromProperty(String propName) {
        StringTokenizer st = new StringTokenizer(System.getProperty(propName, ""), File.pathSeparator);
        try {
            while (st.hasMoreElements()) {
                String dirname = st.nextToken();
                File dir = new File(dirname);
                if (!dir.exists()) continue;
                if (!dirname.endsWith(File.separator)) {
                    dirname = String.valueOf(dirname) + File.separator;
                }
                String[] files = dir.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar") || name.endsWith(".zip");
                    }
                });
                int i = files.length - 1;
                while (i >= 0) {
                    this.addURL(new URL("file", "", -1, String.valueOf(dirname) + files[i]));
                    --i;
                }
            }
        }
        catch (MalformedURLException x) {
            throw new RuntimeException(x);
        }
    }
}

