/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.lang.CPStringBuilder;
import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;

final class RETokenChar
extends REToken {
    private char[] ch;
    private boolean insens;
    private int matchedLength;

    RETokenChar(int subIndex, char c, boolean ins) {
        super(subIndex);
        this.insens = ins;
        this.ch = new char[1];
        this.ch[0] = c;
    }

    int getMinimumLength() {
        return this.ch.length;
    }

    int getMaximumLength() {
        return this.ch.length;
    }

    REMatch matchThis(CharIndexed input, REMatch mymatch) {
        if (this.matchOneString(input, mymatch.index)) {
            mymatch.index += this.matchedLength;
            return mymatch;
        }
        mymatch.index += this.matchedLength;
        input.setHitEnd(mymatch);
        return null;
    }

    private boolean matchOneString(CharIndexed input, int index) {
        this.matchedLength = 0;
        int z = this.ch.length;
        int i = 0;
        while (i < z) {
            char c = input.charAt(index + i);
            if (!this.charEquals(c, this.ch[i])) {
                return false;
            }
            ++this.matchedLength;
            ++i;
        }
        return true;
    }

    private boolean charEquals(char c1, char c2) {
        if (c1 == c2) {
            return true;
        }
        if (!this.insens) {
            return false;
        }
        if (RETokenChar.toLowerCase(c1, this.unicodeAware) == c2) {
            return true;
        }
        return RETokenChar.toUpperCase(c1, this.unicodeAware) == c2;
    }

    boolean returnsFixedLengthMatches() {
        return true;
    }

    int findFixedLengthMatches(CharIndexed input, REMatch mymatch, int max) {
        int numRepeats;
        int index = mymatch.index;
        int z = this.ch.length;
        for (numRepeats = 0; numRepeats < max && this.matchOneString(input, index); ++numRepeats) {
            index += z;
        }
        return numRepeats;
    }

    boolean chain(REToken next) {
        if (next instanceof RETokenChar && ((RETokenChar)next).insens == this.insens) {
            RETokenChar cnext = (RETokenChar)next;
            int newsize = this.ch.length + cnext.ch.length;
            char[] chTemp = new char[newsize];
            System.arraycopy(this.ch, 0, chTemp, 0, this.ch.length);
            System.arraycopy(cnext.ch, 0, chTemp, this.ch.length, cnext.ch.length);
            this.ch = chTemp;
            if (cnext.next == null) {
                return false;
            }
            return this.chain(cnext.next);
        }
        return super.chain(next);
    }

    void dump(CPStringBuilder os) {
        os.append(this.ch);
    }
}

