/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class BorderLayout
implements LayoutManager2,
Serializable {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    public static final String BEFORE_FIRST_LINE = "First";
    public static final String AFTER_LAST_LINE = "Last";
    public static final String BEFORE_LINE_BEGINS = "Before";
    public static final String AFTER_LINE_ENDS = "After";
    public static final String PAGE_START = "First";
    public static final String PAGE_END = "Last";
    public static final String LINE_START = "Before";
    public static final String LINE_END = "After";
    private static final long serialVersionUID = -8658291919501921765L;
    private Component north;
    private Component south;
    private Component east;
    private Component west;
    private Component center;
    private Component firstLine;
    private Component lastLine;
    private Component firstItem;
    private Component lastItem;
    private int hgap;
    private int vgap;
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int PREF = 2;

    public BorderLayout() {
        this(0, 0);
    }

    public BorderLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints != null && !(constraints instanceof String)) {
            throw new IllegalArgumentException("Constraint must be a string");
        }
        this.addLayoutComponent((String)constraints, component);
    }

    public void addLayoutComponent(String constraints, Component component) {
        String str = constraints;
        if (str == null || str.equals(CENTER)) {
            this.center = component;
        } else if (str.equals(NORTH)) {
            this.north = component;
        } else if (str.equals(SOUTH)) {
            this.south = component;
        } else if (str.equals(EAST)) {
            this.east = component;
        } else if (str.equals(WEST)) {
            this.west = component;
        } else if (str.equals("First")) {
            this.firstLine = component;
        } else if (str.equals("Last")) {
            this.lastLine = component;
        } else if (str.equals("Before")) {
            this.firstItem = component;
        } else if (str.equals("After")) {
            this.lastItem = component;
        } else {
            throw new IllegalArgumentException("Constraint value not valid: " + str);
        }
    }

    public void removeLayoutComponent(Component component) {
        if (this.north == component) {
            this.north = null;
        }
        if (this.south == component) {
            this.south = null;
        }
        if (this.east == component) {
            this.east = null;
        }
        if (this.west == component) {
            this.west = null;
        }
        if (this.center == component) {
            this.center = null;
        }
        if (this.firstItem == component) {
            this.firstItem = null;
        }
        if (this.lastItem == component) {
            this.lastItem = null;
        }
        if (this.firstLine == component) {
            this.firstLine = null;
        }
        if (this.lastLine == component) {
            this.lastLine = null;
        }
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.calcSize(target, 0);
    }

    public Dimension preferredLayoutSize(Container target) {
        return this.calcSize(target, 2);
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container parent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets i = target.getInsets();
            int top = i.top;
            int bottom = target.height - i.bottom;
            int left = i.left;
            int right = target.width - i.right;
            boolean left_to_right = target.getComponentOrientation().isLeftToRight();
            Component my_north = this.north;
            Component my_east = this.east;
            Component my_south = this.south;
            Component my_west = this.west;
            if (this.firstLine != null) {
                my_north = this.firstLine;
            }
            if (this.lastLine != null) {
                my_south = this.lastLine;
            }
            if (this.firstItem != null) {
                if (left_to_right) {
                    my_west = this.firstItem;
                } else {
                    my_east = this.firstItem;
                }
            }
            if (this.lastItem != null) {
                if (left_to_right) {
                    my_east = this.lastItem;
                } else {
                    my_west = this.lastItem;
                }
            }
            if (my_north != null) {
                Dimension n = this.calcCompSize(my_north, 2);
                my_north.setBounds(left, top, right - left, n.height);
                top += n.height + this.vgap;
            }
            if (my_south != null) {
                Dimension s = this.calcCompSize(my_south, 2);
                my_south.setBounds(left, bottom - s.height, right - left, s.height);
                bottom -= s.height + this.vgap;
            }
            if (my_east != null) {
                Dimension e = this.calcCompSize(my_east, 2);
                my_east.setBounds(right - e.width, top, e.width, bottom - top);
                right -= e.width + this.hgap;
            }
            if (my_west != null) {
                Dimension w = this.calcCompSize(my_west, 2);
                my_west.setBounds(left, top, w.width, bottom - top);
                left += w.width + this.hgap;
            }
            if (this.center != null) {
                this.center.setBounds(left, top, right - left, bottom - top);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    private Dimension calcCompSize(Component comp, int what) {
        if (comp == null || !comp.isVisible()) {
            return new Dimension(0, 0);
        }
        if (what == 0) {
            return comp.getMinimumSize();
        }
        if (what == 1) {
            return comp.getMaximumSize();
        }
        return comp.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension calcSize(Container target, int what) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int addedHeight;
            Insets ins = target.getInsets();
            ComponentOrientation orient = target.getComponentOrientation();
            boolean left_to_right = orient.isLeftToRight();
            Component my_north = this.north;
            Component my_east = this.east;
            Component my_south = this.south;
            Component my_west = this.west;
            if (this.firstLine != null) {
                my_north = this.firstLine;
            }
            if (this.lastLine != null) {
                my_south = this.lastLine;
            }
            if (this.firstItem != null) {
                if (left_to_right) {
                    my_west = this.firstItem;
                } else {
                    my_east = this.firstItem;
                }
            }
            if (this.lastItem != null) {
                if (left_to_right) {
                    my_east = this.lastItem;
                } else {
                    my_west = this.lastItem;
                }
            }
            Dimension ndim = this.calcCompSize(my_north, what);
            Dimension sdim = this.calcCompSize(my_south, what);
            Dimension edim = this.calcCompSize(my_east, what);
            Dimension wdim = this.calcCompSize(my_west, what);
            Dimension cdim = this.calcCompSize(this.center, what);
            int width = edim.width + cdim.width + wdim.width + this.hgap * 2;
            if (width < edim.width || width < cdim.width || width < cdim.width) {
                width = Integer.MAX_VALUE;
            }
            if (ndim.width > width) {
                width = ndim.width;
            }
            if (sdim.width > width) {
                width = sdim.width;
            }
            width += ins.left + ins.right;
            int height = edim.height;
            if (cdim.height > height) {
                height = cdim.height;
            }
            if (wdim.height > height) {
                height = wdim.height;
            }
            height = (addedHeight = height + (ndim.height + sdim.height + this.vgap * 2 + ins.top + ins.bottom)) < height ? Integer.MAX_VALUE : addedHeight;
            return new Dimension(width, height);
        }
    }

    public Component getLayoutComponent(Object constraints) {
        if (constraints == CENTER) {
            return this.center;
        }
        if (constraints == NORTH) {
            return this.north;
        }
        if (constraints == EAST) {
            return this.east;
        }
        if (constraints == SOUTH) {
            return this.south;
        }
        if (constraints == WEST) {
            return this.west;
        }
        if (constraints == "First") {
            return this.firstLine;
        }
        if (constraints == "Last") {
            return this.lastLine;
        }
        if (constraints == "Before") {
            return this.firstItem;
        }
        if (constraints == "After") {
            return this.lastItem;
        }
        throw new IllegalArgumentException("constraint " + constraints + " is not recognized");
    }

    public Component getLayoutComponent(Container container, Object constraints) {
        ComponentOrientation orient = container.getComponentOrientation();
        if (constraints == CENTER) {
            return this.center;
        }
        if (constraints == NORTH) {
            return this.north;
        }
        if (constraints == SOUTH) {
            return this.south;
        }
        if (constraints == WEST) {
            if (orient.isLeftToRight()) {
                return this.firstItem == null ? this.west : this.firstItem;
            }
            return this.lastItem == null ? this.west : this.lastItem;
        }
        if (constraints == EAST) {
            if (orient.isLeftToRight()) {
                return this.lastItem == null ? this.east : this.lastItem;
            }
            return this.firstItem == null ? this.east : this.firstItem;
        }
        throw new IllegalArgumentException("constraint " + constraints + " is not recognized");
    }

    public Object getConstraints(Component c) {
        if (c == null) {
            return null;
        }
        if (c == this.center) {
            return CENTER;
        }
        if (c == this.north) {
            return NORTH;
        }
        if (c == this.east) {
            return EAST;
        }
        if (c == this.south) {
            return SOUTH;
        }
        if (c == this.west) {
            return WEST;
        }
        if (c == this.firstLine) {
            return "First";
        }
        if (c == this.lastLine) {
            return "Last";
        }
        if (c == this.firstItem) {
            return "Before";
        }
        if (c == this.lastItem) {
            return "After";
        }
        return null;
    }
}

