/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.Appender;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.files.FileUtils;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class JadxCLIArgs {
    @Parameter(description="<input file> (.apk, .dex, .jar or .class)")
    protected List<String> files = new ArrayList<String>(1);
    @Parameter(names={"-d", "--output-dir"}, description="output directory")
    protected String outDir;
    @Parameter(names={"-ds", "--output-dir-src"}, description="output directory for sources")
    protected String outDirSrc;
    @Parameter(names={"-dr", "--output-dir-res"}, description="output directory for resources")
    protected String outDirRes;
    @Parameter(names={"-r", "--no-res"}, description="do not decode resources")
    protected boolean skipResources = false;
    @Parameter(names={"-s", "--no-src"}, description="do not decompile source code")
    protected boolean skipSources = false;
    @Parameter(names={"-e", "--export-gradle"}, description="save as android gradle project")
    protected boolean exportAsGradleProject = false;
    @Parameter(names={"-j", "--threads-count"}, description="processing threads count")
    protected int threadsCount = JadxArgs.DEFAULT_THREADS_COUNT;
    @Parameter(names={"--show-bad-code"}, description="show inconsistent code (incorrectly decompiled)")
    protected boolean showInconsistentCode = false;
    @Parameter(names={"--no-imports"}, description="disable use of imports, always write entire package name")
    protected boolean useImports = true;
    @Parameter(names={"--no-replace-consts"}, description="don't replace constant value with matching constant field")
    protected boolean replaceConsts = true;
    @Parameter(names={"--escape-unicode"}, description="escape non latin characters in strings (with \\u)")
    protected boolean escapeUnicode = false;
    @Parameter(names={"--deobf"}, description="activate deobfuscation")
    protected boolean deobfuscationOn = false;
    @Parameter(names={"--deobf-min"}, description="min length of name, renamed if shorter")
    protected int deobfuscationMinLength = 3;
    @Parameter(names={"--deobf-max"}, description="max length of name, renamed if longer")
    protected int deobfuscationMaxLength = 64;
    @Parameter(names={"--deobf-rewrite-cfg"}, description="force to save deobfuscation map")
    protected boolean deobfuscationForceSave = false;
    @Parameter(names={"--deobf-use-sourcename"}, description="use source file name as class name alias")
    protected boolean deobfuscationUseSourceNameAsAlias = true;
    @Parameter(names={"--cfg"}, description="save methods control flow graph to dot file")
    protected boolean cfgOutput = false;
    @Parameter(names={"--raw-cfg"}, description="save methods control flow graph (use raw instructions)")
    protected boolean rawCfgOutput = false;
    @Parameter(names={"-f", "--fallback"}, description="make simple dump (using goto instead of 'if', 'for', etc)")
    protected boolean fallbackMode = false;
    @Parameter(names={"-v", "--verbose"}, description="verbose output")
    protected boolean verbose = false;
    @Parameter(names={"--version"}, description="print jadx version")
    protected boolean printVersion = false;
    @Parameter(names={"-h", "--help"}, description="print this help", help=true)
    protected boolean printHelp = false;

    public boolean processArgs(String[] args) {
        return this.parse(args) && this.process();
    }

    private boolean parse(String[] args) {
        try {
            this.makeJCommander().parse(args);
            return true;
        }
        catch (ParameterException e) {
            System.err.println("Arguments parse error: " + e.getMessage());
            this.printUsage();
            return false;
        }
    }

    private JCommander makeJCommander() {
        return JCommander.newBuilder().addObject((Object)this).build();
    }

    private boolean process() {
        if (this.printHelp) {
            this.printUsage();
            return false;
        }
        if (this.printVersion) {
            System.out.println(JadxDecompiler.getVersion());
            return false;
        }
        try {
            Logger rootLogger;
            Appender appender;
            if (this.threadsCount <= 0) {
                throw new JadxException("Threads count must be positive, got: " + this.threadsCount);
            }
            if (this.verbose && (appender = (rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT")).getAppender("STDOUT")) != null) {
                appender.clearAllFilters();
            }
        }
        catch (JadxException e) {
            System.err.println("ERROR: " + e.getMessage());
            this.printUsage();
            return false;
        }
        return true;
    }

    public void printUsage() {
        Field[] fields;
        JCommander jc = this.makeJCommander();
        PrintStream out = System.out;
        out.println();
        out.println("jadx - dex to java decompiler, version: " + JadxDecompiler.getVersion());
        out.println();
        out.println("usage: jadx [options] " + jc.getMainParameterDescription());
        out.println("options:");
        List params = jc.getParameters();
        LinkedHashMap<String, ParameterDescription> paramsMap = new LinkedHashMap<String, ParameterDescription>(params.size());
        int maxNamesLen = 0;
        for (ParameterDescription p : params) {
            paramsMap.put(p.getParameterized().getName(), p);
            int len = p.getNames().length();
            if (len <= maxNamesLen) continue;
            maxNamesLen = len;
        }
        JadxCLIArgs args = new JadxCLIArgs();
        for (Field f : fields = args.getClass().getDeclaredFields()) {
            String name = f.getName();
            ParameterDescription p = (ParameterDescription)paramsMap.get(name);
            if (p == null) continue;
            StringBuilder opt = new StringBuilder();
            opt.append("  ").append(p.getNames());
            JadxCLIArgs.addSpaces(opt, maxNamesLen - opt.length() + 3);
            opt.append("- ").append(p.getDescription());
            this.addDefaultValue(args, f, opt);
            out.println(opt);
        }
        out.println("Example:");
        out.println("  jadx -d out classes.dex");
    }

    private void addDefaultValue(JadxCLIArgs args, Field f, StringBuilder opt) {
        Class<?> fieldType = f.getType();
        if (fieldType == Integer.TYPE) {
            try {
                int val = f.getInt(args);
                opt.append(" (default: ").append(val).append(")");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void addSpaces(StringBuilder str, int count) {
        for (int i = 0; i < count; ++i) {
            str.append(' ');
        }
    }

    public JadxArgs toJadxArgs() {
        JadxArgs args = new JadxArgs();
        args.setInputFiles(this.files.stream().map(FileUtils::toFile).collect(Collectors.toList()));
        args.setOutDir(FileUtils.toFile((String)this.outDir));
        args.setOutDirSrc(FileUtils.toFile((String)this.outDirSrc));
        args.setOutDirRes(FileUtils.toFile((String)this.outDirRes));
        args.setThreadsCount(this.threadsCount);
        args.setSkipSources(this.skipSources);
        args.setSkipResources(this.skipResources);
        args.setFallbackMode(this.fallbackMode);
        args.setShowInconsistentCode(this.showInconsistentCode);
        args.setCfgOutput(this.cfgOutput);
        args.setRawCFGOutput(this.rawCfgOutput);
        args.setReplaceConsts(this.replaceConsts);
        args.setDeobfuscationOn(this.deobfuscationOn);
        args.setDeobfuscationForceSave(this.deobfuscationForceSave);
        args.setDeobfuscationMinLength(this.deobfuscationMinLength);
        args.setDeobfuscationMaxLength(this.deobfuscationMaxLength);
        args.setUseSourceNameAsClassAlias(this.deobfuscationUseSourceNameAsAlias);
        args.setEscapeUnicode(this.escapeUnicode);
        args.setExportAsGradleProject(this.exportAsGradleProject);
        args.setUseImports(this.useImports);
        return args;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public String getOutDir() {
        return this.outDir;
    }

    public String getOutDirSrc() {
        return this.outDirSrc;
    }

    public String getOutDirRes() {
        return this.outDirRes;
    }

    public boolean isSkipResources() {
        return this.skipResources;
    }

    public boolean isSkipSources() {
        return this.skipSources;
    }

    public int getThreadsCount() {
        return this.threadsCount;
    }

    public boolean isFallbackMode() {
        return this.fallbackMode;
    }

    public boolean isShowInconsistentCode() {
        return this.showInconsistentCode;
    }

    public boolean isUseImports() {
        return this.useImports;
    }

    public boolean isDeobfuscationOn() {
        return this.deobfuscationOn;
    }

    public int getDeobfuscationMinLength() {
        return this.deobfuscationMinLength;
    }

    public int getDeobfuscationMaxLength() {
        return this.deobfuscationMaxLength;
    }

    public boolean isDeobfuscationForceSave() {
        return this.deobfuscationForceSave;
    }

    public boolean isDeobfuscationUseSourceNameAsAlias() {
        return this.deobfuscationUseSourceNameAsAlias;
    }

    public boolean escapeUnicode() {
        return this.escapeUnicode;
    }

    public boolean isEscapeUnicode() {
        return this.escapeUnicode;
    }

    public boolean isCfgOutput() {
        return this.cfgOutput;
    }

    public boolean isRawCfgOutput() {
        return this.rawCfgOutput;
    }

    public boolean isReplaceConsts() {
        return this.replaceConsts;
    }

    public boolean isExportAsGradleProject() {
        return this.exportAsGradleProject;
    }
}

