/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.blocksmaker;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.NamedArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.TryCatchBlock;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InstructionRemover;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockExceptionHandler
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(BlockExceptionHandler.class);

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            BlockExceptionHandler.markExceptionHandlers(block);
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            block.updateCleanSuccessors();
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            BlockExceptionHandler.processExceptionHandlers(mth, block);
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            BlockExceptionHandler.processTryCatchBlocks(mth, block);
        }
    }

    private static void markExceptionHandlers(BlockNode block) {
        ArgType argType;
        if (block.getInstructions().isEmpty()) {
            return;
        }
        InsnNode me = block.getInstructions().get(0);
        ExcHandlerAttr handlerAttr = me.get(AType.EXC_HANDLER);
        if (handlerAttr == null) {
            return;
        }
        ExceptionHandler excHandler = handlerAttr.getHandler();
        block.addAttr(handlerAttr);
        ArgType argType2 = argType = excHandler.isCatchAll() ? ArgType.THROWABLE : excHandler.getCatchType().getType();
        if (me.getType() == InsnType.MOVE_EXCEPTION) {
            RegisterArg resArg = InsnArg.reg(me.getResult().getRegNum(), argType);
            me.setResult(resArg);
            me.add(AFlag.DONT_INLINE);
            excHandler.setArg(resArg);
        } else {
            excHandler.setArg(new NamedArg("unused", argType));
        }
    }

    private static void processExceptionHandlers(MethodNode mth, BlockNode block) {
        ExcHandlerAttr handlerAttr = block.get(AType.EXC_HANDLER);
        if (handlerAttr == null) {
            return;
        }
        ExceptionHandler excHandler = handlerAttr.getHandler();
        excHandler.addBlock(block);
        for (BlockNode node : BlockUtils.collectBlocksDominatedBy(block, block)) {
            excHandler.addBlock(node);
        }
        for (BlockNode excBlock : excHandler.getBlocks()) {
            InstructionRemover remover = new InstructionRemover(mth, excBlock);
            for (InsnNode insn : excBlock.getInstructions()) {
                if (insn.getType() == InsnType.MONITOR_ENTER) break;
                if (insn.getType() != InsnType.MONITOR_EXIT) continue;
                remover.add(insn);
            }
            remover.perform();
            for (InsnNode insn : excBlock.getInstructions()) {
                CatchAttr catchAttr = insn.get(AType.CATCH_BLOCK);
                if (catchAttr == null || insn.getType() != InsnType.THROW && !BlockExceptionHandler.onlyAllHandler(catchAttr.getTryBlock())) continue;
                TryCatchBlock handlerBlock = handlerAttr.getTryBlock();
                TryCatchBlock catchBlock = catchAttr.getTryBlock();
                handlerBlock.merge(mth, catchBlock);
            }
        }
    }

    private static boolean onlyAllHandler(TryCatchBlock tryBlock) {
        ExceptionHandler eh;
        return tryBlock.getHandlersCount() == 1 && ((eh = tryBlock.getHandlers().iterator().next()).isCatchAll() || eh.isFinally());
    }

    private static void processTryCatchBlocks(MethodNode mth, BlockNode block) {
        CatchAttr commonCatchAttr = null;
        for (InsnNode insn : block.getInstructions()) {
            CatchAttr catchAttr = insn.get(AType.CATCH_BLOCK);
            if (catchAttr == null) continue;
            if (commonCatchAttr == null) {
                commonCatchAttr = catchAttr;
                continue;
            }
            if (commonCatchAttr == catchAttr) continue;
            commonCatchAttr = null;
            break;
        }
        if (commonCatchAttr != null) {
            block.addAttr(commonCatchAttr);
            for (ExceptionHandler handler : commonCatchAttr.getTryBlock().getHandlers()) {
                BlockExceptionHandler.connectHandler(mth, handler);
            }
        }
    }

    private static void connectHandler(MethodNode mth, ExceptionHandler handler) {
        int addr = handler.getHandleOffset();
        for (BlockNode block : mth.getBasicBlocks()) {
            ExcHandlerAttr bh = block.get(AType.EXC_HANDLER);
            if (bh == null || bh.getHandler().getHandleOffset() != addr) continue;
            handler.setHandlerBlock(block);
            break;
        }
        if (handler.getHandlerBlock() == null) {
            LOG.warn("Exception handler block not set for {}, mth: {}", (Object)handler, (Object)mth);
        }
    }
}

