/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.util.Objects;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.styleelement.MapImage;
import org.openstreetmap.josm.gui.mappaint.styleelement.NodeElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.PartiallyInsideAreaStrategy;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.PositionForAreaStrategy;
import org.openstreetmap.josm.tools.RotationAngle;

public class AreaIconElement
extends StyleElement {
    private final MapImage iconImage;
    private final RotationAngle iconImageAngle;
    private final PositionForAreaStrategy iconPosition;

    protected AreaIconElement(Cascade c, MapImage iconImage, RotationAngle iconImageAngle, PositionForAreaStrategy iconPosition) {
        super(c, 4.8f);
        this.iconImage = Objects.requireNonNull(iconImage, "iconImage");
        this.iconImageAngle = Objects.requireNonNull(iconImageAngle, "iconImageAngle");
        this.iconPosition = Objects.requireNonNull(iconPosition, "iconPosition");
    }

    @Override
    public void paintPrimitive(IPrimitive osm, MapPaintSettings paintSettings, StyledMapRenderer painter, boolean selected, boolean outermember, boolean member) {
        if (painter.isShowIcons()) {
            painter.drawAreaIcon(osm, this.iconImage, painter.isInactiveMode() || osm.isDisabled(), selected, member, this.iconImageAngle.getRotationAngle(osm), this.iconPosition);
        }
    }

    public static AreaIconElement create(Environment env) {
        Cascade c = env.mc.getCascade(env.layer);
        MapImage iconImage = NodeElement.createIcon(env);
        if (iconImage != null) {
            RotationAngle rotationAngle = NodeElement.createRotationAngle(env);
            Keyword positionKeyword = c.get("icon-position", null, Keyword.class);
            PositionForAreaStrategy position = PositionForAreaStrategy.forKeyword(positionKeyword, PartiallyInsideAreaStrategy.INSTANCE);
            return new AreaIconElement(c, iconImage, rotationAngle, position);
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.iconImage == null ? 0 : this.iconImage.hashCode());
        result = 31 * result + (this.iconImageAngle == null ? 0 : this.iconImageAngle.hashCode());
        result = 31 * result + (this.iconPosition == null ? 0 : this.iconPosition.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AreaIconElement other = (AreaIconElement)obj;
        return Objects.equals(this.iconImage, other.iconImage) && Objects.equals(this.iconImageAngle, other.iconImageAngle) && Objects.equals(this.iconPosition, other.iconPosition);
    }

    @Override
    public String toString() {
        return "AreaIconElement{" + super.toString() + "iconImage=[" + this.iconImage + "] iconImageAngle=[" + this.iconImageAngle + "]}";
    }
}

