'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiExpressionButton = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var EuiExpressionButton = function EuiExpressionButton(_ref) {
  var className = _ref.className,
      description = _ref.description,
      buttonValue = _ref.buttonValue,
      isActive = _ref.isActive,
      onClick = _ref.onClick,
      rest = _objectWithoutProperties(_ref, ['className', 'description', 'buttonValue', 'isActive', 'onClick']);

  var classes = (0, _classnames2.default)('euiExpressionButton', className, {
    'euiExpressionButton-isActive': isActive
  });

  return _react2.default.createElement(
    'button',
    _extends({
      className: classes,
      onClick: onClick
    }, rest),
    _react2.default.createElement(
      'span',
      { className: 'euiExpressionButton__description' },
      description
    ),
    ' ',
    _react2.default.createElement(
      'span',
      { className: 'euiExpressionButton__value' },
      buttonValue
    )
  );
};

exports.EuiExpressionButton = EuiExpressionButton;
EuiExpressionButton.propTypes = {
  className: _propTypes2.default.string,
  description: _propTypes2.default.string.isRequired,
  buttonValue: _propTypes2.default.string.isRequired,
  isActive: _propTypes2.default.bool.isRequired,
  onClick: _propTypes2.default.func.isRequired
};

EuiExpressionButton.defaultProps = {
  isActive: false
};
EuiExpressionButton.__docgenInfo = [{
  'description': '',
  'methods': [],
  'props': {
    'className': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'description': {
      'type': {
        'name': 'string'
      },
      'required': true,
      'description': ''
    },
    'buttonValue': {
      'type': {
        'name': 'string'
      },
      'required': true,
      'description': ''
    },
    'isActive': {
      'type': {
        'name': 'bool'
      },
      'required': true,
      'description': '',
      'defaultValue': {
        'value': 'false',
        'computed': false
      }
    },
    'onClick': {
      'type': {
        'name': 'func'
      },
      'required': true,
      'description': ''
    }
  }
}];