/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Transient;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.Module;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.Network6Address;
import onl.netfishers.netshot.device.NetworkInterface;
import onl.netfishers.netshot.device.attribute.ConfigAttribute;
import onl.netfishers.netshot.device.attribute.DeviceAttribute;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceDataProvider {
    private static Logger logger = LoggerFactory.getLogger(DeviceDataProvider.class);
    private Device device = null;
    private Session session;
    private List<String> log = new ArrayList<String>();

    public DeviceDataProvider(Session session, Device device) {
        this.session = session;
        this.device = device;
    }

    private Object getDeviceItem(Device device, String item) {
        DeviceDriver driver;
        try {
            driver = device.getDeviceDriver();
        }
        catch (Device.MissingDeviceDriverException e) {
            return null;
        }
        if ("type".equals(item)) {
            return driver.getDescription();
        }
        if ("name".equals(item)) {
            return device.getName();
        }
        if ("family".equals(item)) {
            return device.getFamily();
        }
        if ("location".equals(item)) {
            return device.getLocation();
        }
        if ("contact".equals(item)) {
            return device.getContact();
        }
        if ("softwareVersion".equals(item)) {
            return device.getSoftwareVersion();
        }
        if ("serialNumber".equals(item)) {
            return device.getSerialNumber();
        }
        if ("networkClass".equals(item)) {
            return device.getNetworkClass() == null ? null : device.getNetworkClass().toString();
        }
        if ("virtualDevices".equals(item)) {
            return device.getVirtualDevices().toArray();
        }
        if ("vrfs".equals(item)) {
            return device.getVrfInstances().toArray();
        }
        if ("modules".equals(item)) {
            ArrayList modules = new ArrayList();
            for (Module m : device.getModules()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("slot", m.getSlot());
                hashMap.put("partNumber", m.getPartNumber());
                hashMap.put("serialNumber", m.getSerialNumber());
                modules.add(hashMap);
            }
            return modules.toArray();
        }
        if ("interfaces".equals(item)) {
            ArrayList networkInterfaces = new ArrayList();
            for (NetworkInterface ni : device.getNetworkInterfaces()) {
                HashMap<String, String> ip;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("name", ni.getInterfaceName());
                hashMap.put("description", ni.getDescription());
                hashMap.put("mac", ni.getMacAddress());
                hashMap.put("virtualDevice", ni.getVirtualDevice());
                hashMap.put("vrf", ni.getVrfInstance());
                hashMap.put("enabled", ni.isEnabled());
                hashMap.put("level3", ni.isLevel3());
                ArrayList ips = new ArrayList();
                for (Network4Address network4Address : ni.getIp4Addresses()) {
                    ip = new HashMap<String, String>();
                    ip.put("ip", network4Address.getIp());
                    ip.put("mask", Integer.toString(network4Address.getPrefixLength()));
                    ip.put("usage", network4Address.getAddressUsage().toString());
                    ips.add(ip);
                }
                for (Network6Address network6Address : ni.getIp6Addresses()) {
                    ip = new HashMap();
                    ip.put("ipv6", network6Address.getIp());
                    ip.put("mask", Integer.toString(network6Address.getPrefixLength()));
                    ip.put("usage", network6Address.getAddressUsage().toString());
                    ips.add(ip);
                }
                hashMap.put("ip", ips.toArray());
                networkInterfaces.add(hashMap);
            }
            return networkInterfaces.toArray();
        }
        for (DeviceDriver.AttributeDefinition definition : driver.getAttributes()) {
            if (!definition.getName().equals(item) && !definition.getTitle().equals(item) || !definition.isCheckable()) continue;
            if (definition.getLevel() == DeviceDriver.AttributeLevel.CONFIG && device.getLastConfig() != null) {
                for (ConfigAttribute configAttribute : device.getLastConfig().getAttributes()) {
                    if (!configAttribute.getName().equals(item)) continue;
                    return configAttribute.getData();
                }
                continue;
            }
            if (definition.getLevel() != DeviceDriver.AttributeLevel.DEVICE) continue;
            for (DeviceAttribute deviceAttribute : device.getAttributes()) {
                if (!deviceAttribute.getName().equals(item)) continue;
                return deviceAttribute.getData();
            }
        }
        return null;
    }

    public Object get(String item) {
        logger.debug("JavaScript request for item {} on current device.", (Object)item);
        return this.getDeviceItem(this.device, item);
    }

    private Device loadDevice(long id) throws HibernateException {
        Device device = (Device)this.session.createQuery("from Device d join fetch d.lastConfig where d.id = :id").setLong("id", id).uniqueResult();
        return device;
    }

    private Device loadDevice(String name) throws HibernateException {
        Device device = (Device)this.session.createQuery("from Device d join fetch d.lastConfig where d.name = :name").setString("name", name).uniqueResult();
        return device;
    }

    public void destroy() {
    }

    public Object get(String item, long deviceId) {
        logger.debug("JavaScript request for item {} on device {}.", (Object)item, (Object)deviceId);
        if (deviceId == this.device.getId()) {
            return this.get(item);
        }
        try {
            this.device = this.loadDevice(deviceId);
            Object result = this.getDeviceItem(this.device, item);
            this.session.evict(this.device);
            return result;
        }
        catch (ObjectNotFoundException e) {
            logger.error("Device not found on JavaScript get, item {}, device {}.", item, deviceId, e);
            this.logIt(String.format("Unable to find the device %d.", deviceId), 3);
        }
        catch (Exception e) {
            logger.error("Error on JavaScript get, item {}, device {}.", item, deviceId, e);
            this.logIt(String.format("Unable to get data %s for device %d.", deviceId), 3);
        }
        return null;
    }

    public Object get(String item, String deviceName) {
        logger.debug("JavaScript request for item {} on device named {}.", (Object)item, (Object)deviceName);
        try {
            if (this.device.getName().equals(deviceName)) {
                return this.get(item);
            }
            this.device = this.loadDevice(deviceName);
            Object result = this.getDeviceItem(this.device, item);
            this.session.evict(this.device);
            return result;
        }
        catch (ObjectNotFoundException e) {
            logger.error("Device not found on JavaScript get, item {}, device named {}.", item, deviceName, e);
            this.logIt(String.format("Unable to find the device named %s.", deviceName), 3);
        }
        catch (Exception e) {
            logger.error("Error on JavaScript get, item {}, device named {}.", item, deviceName, e);
            this.logIt(String.format("Unable to get data %s for device named %s.", deviceName), 3);
        }
        return null;
    }

    public Object nslookup(String host) {
        String name = "";
        String address = "";
        try {
            InetAddress ip = InetAddress.getByName(host);
            name = ip.getHostName();
            address = ip.getHostAddress();
        }
        catch (UnknownHostException ip) {
            // empty catch block
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("name", name);
        result.put("address", address);
        return result;
    }

    public void debug(String message) {
        this.logIt("DEBUG: " + message, 5);
    }

    protected void logIt(String log, int level) {
        this.log.add("[" + level + "] " + log);
    }

    @Transient
    public List<String> getLog() {
        return this.log;
    }

    @Transient
    public String getPlainLog() {
        StringBuffer buffer = new StringBuffer();
        for (String log : this.log) {
            buffer.append(log);
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

