/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.access;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import onl.netfishers.netshot.device.NetworkAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Cli {
    private static Logger logger = LoggerFactory.getLogger(Cli.class);
    private static Pattern ansiEscapePattern = Pattern.compile("\u001b\\[[;\\d]*m");
    protected int connectionTimeout = 5000;
    protected int receiveTimeout = 60000;
    protected int commandTimeout = 120000;
    protected String prompt;
    protected NetworkAddress host;
    protected String lastCommand;
    protected Matcher lastExpectMatch;
    protected String lastExpectMatchPattern;
    protected int lastExpectMatchIndex = -1;
    protected String lastFullOutput;
    protected InputStream inStream;
    protected PrintStream outStream;

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public int getCommandTimeout() {
        return this.commandTimeout;
    }

    public void setCommandTimeout(int commandTimeout) {
        this.commandTimeout = commandTimeout;
    }

    public Cli(NetworkAddress host) {
        this.host = host;
    }

    public String getLastCommand() {
        return this.lastCommand;
    }

    public Matcher getLastExpectMatch() {
        return this.lastExpectMatch;
    }

    public String getLastExpectMatchPattern() {
        return this.lastExpectMatchPattern;
    }

    public int getLastExpectMatchIndex() {
        return this.lastExpectMatchIndex;
    }

    public String getLastFullOutput() {
        return this.lastFullOutput;
    }

    public abstract void connect() throws IOException;

    public String send(String command, String expect) throws IOException {
        String[] expects = new String[]{expect};
        return this.send(command, expects);
    }

    public abstract void disconnect();

    protected String readUntil(String[] expects) throws IOException {
        StringBuffer buffer = new StringBuffer();
        byte[] miniBuffer = new byte[4096];
        Pattern[] patterns = new Pattern[expects.length];
        for (int i = 0; i < expects.length; ++i) {
            patterns[i] = Pattern.compile(expects[i], 8);
        }
        long maxTime = System.currentTimeMillis() + (long)this.commandTimeout;
        while (true) {
            if (this.inStream != null && this.inStream.available() > 0) {
                int length = this.inStream.read(miniBuffer);
                String s = new String(miniBuffer, 0, length);
                logger.debug("Received data '{}'.", (Object)s);
                buffer.append(s);
                continue;
            }
            for (int i = 0; i < patterns.length; ++i) {
                String received = buffer.toString();
                Matcher matcher = patterns[i].matcher(received = ansiEscapePattern.matcher(received).replaceAll(""));
                if (!matcher.find()) continue;
                this.lastExpectMatch = matcher;
                this.lastExpectMatchIndex = i;
                this.lastFullOutput = received;
                this.lastExpectMatchPattern = expects[i];
                return matcher.replaceFirst("");
            }
            if (System.currentTimeMillis() > maxTime) break;
        }
        throw new WithBufferIOException("Timeout waiting for the command output.", buffer);
    }

    protected void write(String value) {
        this.outStream.print(value);
        this.outStream.flush();
    }

    public String send(String command, String[] expects) throws IOException {
        logger.debug("Command to send: '{}'.", (Object)command);
        this.write(command);
        this.lastCommand = command;
        return this.readUntil(expects);
    }

    public class WithBufferIOException
    extends IOException {
        private static final long serialVersionUID = -1759143581862318498L;
        private StringBuffer receivedBuffer;

        public WithBufferIOException(String message, StringBuffer receivedBuffer) {
            super(message);
            this.receivedBuffer = receivedBuffer;
        }

        public StringBuffer getReceivedBuffer() {
            return this.receivedBuffer;
        }
    }
}

