/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.access;

import java.io.IOException;
import onl.netfishers.netshot.device.NetworkAddress;
import onl.netfishers.netshot.device.access.Poller;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class Snmp
extends Poller {
    private org.snmp4j.Snmp snmp;
    private Target target;
    private static int PORT = 161;

    public Snmp(NetworkAddress address, String community, boolean v1) throws IOException {
        this.target = new CommunityTarget(new UdpAddress(address.getInetAddress(), PORT), new OctetString(community));
        this.target.setVersion(v1 ? 0 : 1);
        this.start();
    }

    public Snmp(NetworkAddress address, String community) throws IOException {
        this(address, community, false);
    }

    public Snmp(NetworkAddress address, String username, String password) {
    }

    private void start() throws IOException {
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
        this.snmp = new org.snmp4j.Snmp(transport);
        transport.listen();
    }

    public void stop() throws IOException {
        this.snmp.close();
    }

    public String getAsString(OID oid) throws IOException {
        ResponseEvent event = this.get(new OID[]{oid});
        PDU response = event.getResponse();
        if (response == null || response.size() == 0) {
            throw new IOException("No SNMP response.");
        }
        return response.get(0).getVariable().toString();
    }

    public String getAsString(String oid) throws IOException {
        return this.getAsString(new OID(oid));
    }

    private PDU getPDU(OID[] oids) {
        PDU pdu = new PDU();
        for (OID oid : oids) {
            pdu.add(new VariableBinding(oid));
        }
        pdu.setType(-96);
        return pdu;
    }

    public ResponseEvent get(OID[] oids) throws IOException {
        ResponseEvent event = this.snmp.send(this.getPDU(oids), this.target, null);
        if (event != null) {
            return event;
        }
        throw new RuntimeException("SNMP Get timed out");
    }
}

