/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work.tasks;

import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.compliance.HardwareRule;
import onl.netfishers.netshot.compliance.Policy;
import onl.netfishers.netshot.compliance.SoftwareRule;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.work.Task;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.criterion.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class CheckComplianceTask
extends Task {
    private static Logger logger = LoggerFactory.getLogger(CheckComplianceTask.class);
    private Device device;

    protected CheckComplianceTask() {
    }

    public CheckComplianceTask(Device device, String comments, String author) {
        super(comments, device.getLastConfig() == null ? device.getMgmtAddress().getIp() : device.getName(), author);
        this.device = device;
    }

    @Override
    public void prepare() {
        Hibernate.initialize(this.device);
        Hibernate.initialize(this.device.getComplianceCheckResults());
        Hibernate.initialize(this.device.getComplianceExemptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug("Starting check compliance task for device {}.", (Object)this.device.getId());
        this.logIt(String.format("Check compliance task for device %s (%s).", this.device.getName(), this.device.getMgmtAddress().getIp()), 5);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            session.createQuery("delete from CheckResult c where c.key.device.id = :id").setLong("id", this.device.getId()).executeUpdate();
            session.evict(this.device);
            Device device = (Device)session.createQuery("from Device d join fetch d.lastConfig where d.id = :id").setLong("id", this.device.getId()).uniqueResult();
            if (device == null) {
                logger.info("Unable to fetch the device with its last config... has it been captured at least once?");
                throw new Exception("No last config for this device. Has it been captured at least once?");
            }
            List policies = session.createQuery("select p from Policy p join p.targetGroup g join g.cachedDevices d where d.id = :id").setLong("id", this.device.getId()).list();
            for (Object policy : policies) {
                ((Policy)policy).check(device, session);
                session.merge(policy);
            }
            List softwareRules = session.createCriteria(SoftwareRule.class).addOrder(Property.forName("priority").asc()).list();
            device.setSoftwareLevel(SoftwareRule.ConformanceLevel.UNKNOWN);
            for (SoftwareRule rule : softwareRules) {
                rule.check(device);
                if (device.getSoftwareLevel() == SoftwareRule.ConformanceLevel.UNKNOWN) continue;
                break;
            }
            List hardwareRules = session.createCriteria(HardwareRule.class).list();
            device.resetEoX();
            for (HardwareRule rule : hardwareRules) {
                rule.check(device);
            }
            session.merge(device);
            session.getTransaction().commit();
            this.status = Task.Status.SUCCESS;
        }
    }

    @Override
    @XmlElement
    @Transient
    public String getTaskDescription() {
        return "Device compliance check";
    }

    @ManyToOne(fetch=FetchType.LAZY)
    protected Device getDevice() {
        return this.device;
    }

    protected void setDevice(Device device) {
        this.device = device;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CheckComplianceTask task = (CheckComplianceTask)super.clone();
        task.setDevice(this.device);
        return task;
    }
}

