/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * clamp(uvec3(0u, 0u, 0u), uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u)) => uvec3(0u, 0u, 0u)
 * clamp(uvec3(0u, 0u, 0u), uvec3(0u, 0u, 1u), uvec3(5u, 34u, 1u)) => uvec3(0u, 0u, 1u)
 * clamp(uvec3(0u, 0u, 0u), uvec3(1u, 1u, 1u), uvec3(2u, 5u, 34u)) => uvec3(1u, 1u, 1u)
 * clamp(uvec3(0u, 0u, 0u), uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u)) => uvec3(2u, 2u, 2u)
 * clamp(uvec3(0u, 0u, 0u), uvec3(5u, 5u, 34u), uvec3(5u, 34u, 34u)) => uvec3(5u, 5u, 34u)
 * clamp(uvec3(1u, 1u, 1u), uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u)) => uvec3(0u, 1u, 1u)
 * clamp(uvec3(1u, 1u, 1u), uvec3(0u, 0u, 1u), uvec3(5u, 34u, 1u)) => uvec3(1u, 1u, 1u)
 * clamp(uvec3(1u, 1u, 1u), uvec3(1u, 1u, 1u), uvec3(2u, 5u, 34u)) => uvec3(1u, 1u, 1u)
 * clamp(uvec3(1u, 1u, 1u), uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u)) => uvec3(2u, 2u, 2u)
 * clamp(uvec3(1u, 1u, 1u), uvec3(5u, 5u, 34u), uvec3(5u, 34u, 34u)) => uvec3(5u, 5u, 34u)
 * clamp(uvec3(2u, 2u, 2u), uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u)) => uvec3(0u, 1u, 2u)
 * clamp(uvec3(2u, 2u, 2u), uvec3(0u, 0u, 1u), uvec3(5u, 34u, 1u)) => uvec3(2u, 2u, 1u)
 * clamp(uvec3(2u, 2u, 2u), uvec3(1u, 1u, 1u), uvec3(2u, 5u, 34u)) => uvec3(2u, 2u, 2u)
 * clamp(uvec3(2u, 2u, 2u), uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u)) => uvec3(2u, 2u, 2u)
 * clamp(uvec3(2u, 2u, 2u), uvec3(5u, 5u, 34u), uvec3(5u, 34u, 34u)) => uvec3(5u, 5u, 34u)
 * clamp(uvec3(5u, 5u, 5u), uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u)) => uvec3(0u, 1u, 2u)
 * clamp(uvec3(5u, 5u, 5u), uvec3(0u, 0u, 1u), uvec3(5u, 34u, 1u)) => uvec3(5u, 5u, 1u)
 * clamp(uvec3(5u, 5u, 5u), uvec3(1u, 1u, 1u), uvec3(2u, 5u, 34u)) => uvec3(2u, 5u, 5u)
 * clamp(uvec3(5u, 5u, 5u), uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u)) => uvec3(2u, 5u, 5u)
 * clamp(uvec3(5u, 5u, 5u), uvec3(5u, 5u, 34u), uvec3(5u, 34u, 34u)) => uvec3(5u, 5u, 34u)
 * clamp(uvec3(34u, 34u, 34u), uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u)) => uvec3(0u, 1u, 2u)
 * clamp(uvec3(34u, 34u, 34u), uvec3(0u, 0u, 1u), uvec3(5u, 34u, 1u)) => uvec3(5u, 34u, 1u)
 * clamp(uvec3(34u, 34u, 34u), uvec3(1u, 1u, 1u), uvec3(2u, 5u, 34u)) => uvec3(2u, 5u, 34u)
 * clamp(uvec3(34u, 34u, 34u), uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u)) => uvec3(2u, 5u, 34u)
 * clamp(uvec3(34u, 34u, 34u), uvec3(5u, 5u, 34u), uvec3(5u, 34u, 34u)) => uvec3(5u, 34u, 34u)
 */
#version 130

void main()
{
  float[all(equal(clamp(uvec3(0u, 0u, 0u), uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u)), uvec3(0u, 0u, 0u))) ? 1 : -1] array0;
  float[all(equal(clamp(uvec3(0u, 0u, 0u), uvec3(0u, 0u, 1u), uvec3(5u, 34u, 1u)), uvec3(0u, 0u, 1u))) ? 1 : -1] array1;
  float[all(equal(clamp(uvec3(0u, 0u, 0u), uvec3(1u, 1u, 1u), uvec3(2u, 5u, 34u)), uvec3(1u, 1u, 1u))) ? 1 : -1] array2;
  float[all(equal(clamp(uvec3(0u, 0u, 0u), uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u)), uvec3(2u, 2u, 2u))) ? 1 : -1] array3;
  float[all(equal(clamp(uvec3(0u, 0u, 0u), uvec3(5u, 5u, 34u), uvec3(5u, 34u, 34u)), uvec3(5u, 5u, 34u))) ? 1 : -1] array4;
  float[all(equal(clamp(uvec3(1u, 1u, 1u), uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u)), uvec3(0u, 1u, 1u))) ? 1 : -1] array5;
  float[all(equal(clamp(uvec3(1u, 1u, 1u), uvec3(0u, 0u, 1u), uvec3(5u, 34u, 1u)), uvec3(1u, 1u, 1u))) ? 1 : -1] array6;
  float[all(equal(clamp(uvec3(1u, 1u, 1u), uvec3(1u, 1u, 1u), uvec3(2u, 5u, 34u)), uvec3(1u, 1u, 1u))) ? 1 : -1] array7;
  float[all(equal(clamp(uvec3(1u, 1u, 1u), uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u)), uvec3(2u, 2u, 2u))) ? 1 : -1] array8;
  float[all(equal(clamp(uvec3(1u, 1u, 1u), uvec3(5u, 5u, 34u), uvec3(5u, 34u, 34u)), uvec3(5u, 5u, 34u))) ? 1 : -1] array9;
  float[all(equal(clamp(uvec3(2u, 2u, 2u), uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u)), uvec3(0u, 1u, 2u))) ? 1 : -1] array10;
  float[all(equal(clamp(uvec3(2u, 2u, 2u), uvec3(0u, 0u, 1u), uvec3(5u, 34u, 1u)), uvec3(2u, 2u, 1u))) ? 1 : -1] array11;
  float[all(equal(clamp(uvec3(2u, 2u, 2u), uvec3(1u, 1u, 1u), uvec3(2u, 5u, 34u)), uvec3(2u, 2u, 2u))) ? 1 : -1] array12;
  float[all(equal(clamp(uvec3(2u, 2u, 2u), uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u)), uvec3(2u, 2u, 2u))) ? 1 : -1] array13;
  float[all(equal(clamp(uvec3(2u, 2u, 2u), uvec3(5u, 5u, 34u), uvec3(5u, 34u, 34u)), uvec3(5u, 5u, 34u))) ? 1 : -1] array14;
  float[all(equal(clamp(uvec3(5u, 5u, 5u), uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u)), uvec3(0u, 1u, 2u))) ? 1 : -1] array15;
  float[all(equal(clamp(uvec3(5u, 5u, 5u), uvec3(0u, 0u, 1u), uvec3(5u, 34u, 1u)), uvec3(5u, 5u, 1u))) ? 1 : -1] array16;
  float[all(equal(clamp(uvec3(5u, 5u, 5u), uvec3(1u, 1u, 1u), uvec3(2u, 5u, 34u)), uvec3(2u, 5u, 5u))) ? 1 : -1] array17;
  float[all(equal(clamp(uvec3(5u, 5u, 5u), uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u)), uvec3(2u, 5u, 5u))) ? 1 : -1] array18;
  float[all(equal(clamp(uvec3(5u, 5u, 5u), uvec3(5u, 5u, 34u), uvec3(5u, 34u, 34u)), uvec3(5u, 5u, 34u))) ? 1 : -1] array19;
  float[all(equal(clamp(uvec3(34u, 34u, 34u), uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u)), uvec3(0u, 1u, 2u))) ? 1 : -1] array20;
  float[all(equal(clamp(uvec3(34u, 34u, 34u), uvec3(0u, 0u, 1u), uvec3(5u, 34u, 1u)), uvec3(5u, 34u, 1u))) ? 1 : -1] array21;
  float[all(equal(clamp(uvec3(34u, 34u, 34u), uvec3(1u, 1u, 1u), uvec3(2u, 5u, 34u)), uvec3(2u, 5u, 34u))) ? 1 : -1] array22;
  float[all(equal(clamp(uvec3(34u, 34u, 34u), uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u)), uvec3(2u, 5u, 34u))) ? 1 : -1] array23;
  float[all(equal(clamp(uvec3(34u, 34u, 34u), uvec3(5u, 5u, 34u), uvec3(5u, 34u, 34u)), uvec3(5u, 34u, 34u))) ? 1 : -1] array24;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length());
}
